/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OAlterPropertyStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class OCommandExecutorSQLAlterProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private OProperty.ATTRIBUTES attribute;
    private String value;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLAlterProperty parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLAlterProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
                throw new OCommandSQLParsingException("Keyword ALTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
                throw new OCommandSQLParsingException("Keyword PROPERTY not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            String[] parts = word.toString().split("\\.");
            if (parts.length != 2) {
                if (parts[1].startsWith("`") && parts[parts.length - 1].endsWith("`")) {
                    StringBuilder fullName = new StringBuilder();
                    for (int i = 1; i < parts.length; ++i) {
                        if (i > 1) {
                            fullName.append(".");
                        }
                        fullName.append(parts[i]);
                    }
                    parts = new String[]{parts[0], fullName.toString()};
                } else {
                    throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, oldPos);
                }
            }
            this.className = this.decodeClassName(parts[0]);
            if (this.className == null) {
                throw new OCommandSQLParsingException("Class not found", this.parserText, oldPos);
            }
            this.fieldName = this.decodeClassName(parts[1]);
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Missing property attribute to change. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            String attributeAsString = word.toString();
            try {
                this.attribute = OProperty.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException(new OCommandSQLParsingException("Unknown property attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OProperty.ATTRIBUTES.values()), this.parserText, oldPos), e);
            }
            this.value = this.parserText.substring(pos + 1).trim();
            if (this.attribute.equals((Object)OProperty.ATTRIBUTES.NAME) || this.attribute.equals((Object)OProperty.ATTRIBUTES.LINKEDCLASS)) {
                this.value = this.decodeClassName(this.value);
            }
            if (this.value.length() == 0) {
                throw new OCommandSQLParsingException("Missing property value to change for attribute '" + (Object)((Object)this.attribute) + "'. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            if (this.preParsedStatement != null) {
                OAlterPropertyStatement stm = (OAlterPropertyStatement)this.preParsedStatement;
                OExpression settingExp = stm.settingValue;
                if (settingExp != null) {
                    Object expValue = settingExp.execute(null, this.context);
                    if (expValue == null) {
                        expValue = settingExp.toString();
                    }
                    this.value = expValue != null ? (expValue instanceof Date ? ODateHelper.getDateTimeFormatInstance().format((Date)expValue) : expValue.toString()) : null;
                    if (this.attribute.equals((Object)OProperty.ATTRIBUTES.NAME) || this.attribute.equals((Object)OProperty.ATTRIBUTES.LINKEDCLASS)) {
                        this.value = this.decodeClassName(this.value);
                    }
                } else if (stm.customPropertyName != null) {
                    this.value = "" + stm.customPropertyName.getStringValue() + "=" + stm.customPropertyValue.toString();
                } else if (stm.clearCustom) {
                    this.value = "clear";
                }
            } else {
                if (this.value.equalsIgnoreCase("null")) {
                    this.value = null;
                }
                if (this.value != null && this.isQuoted(this.value)) {
                    this.value = this.removeQuotes(this.value);
                }
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    private String removeQuotes(String s) {
        s = s.trim();
        return s.substring(1, s.length() - 1).replaceAll("\\\\\"", "\"");
    }

    private boolean isQuoted(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("`") && s.endsWith("`");
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        OClassImpl sourceClass = (OClassImpl)OCommandExecutorSQLAlterProperty.getDatabase().getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        OPropertyImpl prop = (OPropertyImpl)sourceClass.getProperty(this.fieldName);
        if (prop == null) {
            throw new OCommandExecutionException("Property '" + this.className + "." + this.fieldName + "' not exists");
        }
        if ("null".equalsIgnoreCase(this.value)) {
            prop.set(this.attribute, null);
        } else {
            prop.set(this.attribute, this.value);
        }
        return null;
    }

    @Override
    public String getSyntax() {
        return "ALTER PROPERTY <class>.<property> <attribute-name> <attribute-value>";
    }
}

