/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLCreateUser
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_USER = "USER";
    public static final String KEYWORD_IDENTIFIED = "IDENTIFIED";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_ROLE = "ROLE";
    public static final String SYNTAX = "CREATE USER <user-name> IDENTIFIED BY <user-password> [ ROLE <role-name> ]";
    private static final String USER_CLASS = "OUser";
    private static final String USER_FIELD_NAME = "name";
    private static final String USER_FIELD_PASSWORD = "password";
    private static final String USER_FIELD_STATUS = "status";
    private static final String USER_FIELD_ROLES = "roles";
    private static final String DEFAULT_STATUS = "ACTIVE";
    private static final String DEFAULT_ROLE = "writer";
    private static final String ROLE_CLASS = "ORole";
    private static final String ROLE_FIELD_NAME = "name";
    private String userName;
    private String pass;
    private List<String> roles;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OCommandExecutorSQLCreateUser parse(OCommandRequest iRequest) {
        String temp;
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(KEYWORD_CREATE);
        this.parserRequiredKeyword(KEYWORD_USER);
        this.userName = this.parserRequiredWord(false, "Expected <user-name>");
        this.parserRequiredKeyword(KEYWORD_IDENTIFIED);
        this.parserRequiredKeyword(KEYWORD_BY);
        this.pass = this.parserRequiredWord(false, "Expected <user-password>");
        this.roles = new ArrayList<String>();
        while ((temp = this.parseOptionalWord(true, new String[0])) != null && !this.parserIsEnded()) {
            String role;
            int roleLen;
            if (!temp.equals(KEYWORD_ROLE) || (roleLen = (role = this.parserRequiredWord(false, "Expected <role-name>")) != null ? role.length() : 0) <= 0) continue;
            if (role.charAt(0) == '[' && role.charAt(roleLen - 1) == ']') {
                String[] splits;
                role = role.substring(1, role.length() - 1);
                for (String spl : splits = role.split("[, ]")) {
                    if (spl.length() <= 0) continue;
                    this.roles.add(spl);
                }
                continue;
            }
            this.roles.add(role);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.userName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(USER_CLASS);
        sb.append(" SET ");
        sb.append("name");
        sb.append("='");
        sb.append(this.userName);
        sb.append("'");
        sb.append(',');
        sb.append(USER_FIELD_PASSWORD);
        sb.append("='");
        sb.append(this.pass);
        sb.append("'");
        sb.append(',');
        sb.append(USER_FIELD_STATUS);
        sb.append("='");
        sb.append(DEFAULT_STATUS);
        sb.append("'");
        if (this.roles.size() == 0) {
            this.roles.add(DEFAULT_ROLE);
        }
        sb.append(',');
        sb.append(USER_FIELD_ROLES);
        sb.append("=(SELECT FROM ");
        sb.append(ROLE_CLASS);
        sb.append(" WHERE ");
        sb.append("name");
        sb.append(" IN [");
        for (int i = 0; i < this.roles.size(); ++i) {
            String role;
            if (i > 0) {
                sb.append(", ");
            }
            if ((role = this.roles.get(i)).startsWith("'") || role.startsWith("\"")) {
                sb.append(this.roles.get(i));
                continue;
            }
            sb.append("'");
            sb.append(this.roles.get(i));
            sb.append("'");
        }
        sb.append("])");
        return OCommandExecutorSQLCreateUser.getDatabase().command(new OCommandSQL(sb.toString())).execute(new Object[0]);
    }

    @Override
    public String getSyntax() {
        return SYNTAX;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

