/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Map;

public class OCommandExecutorSQLTransactional
extends OCommandExecutorSQLDelegate {
    public static final String KEYWORD_TRANSACTIONAL = "TRANSACTIONAL";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public OCommandExecutorSQLTransactional parse(OCommandRequest iCommand) {
        String cmd = ((OCommandSQL)iCommand).getText();
        super.parse(new OCommandSQL(cmd.substring(KEYWORD_TRANSACTIONAL.length())));
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        boolean txbegun;
        ODatabaseDocumentInternal database = OCommandExecutorSQLTransactional.getDatabase();
        boolean bl = txbegun = database.getTransaction() == null || !database.getTransaction().isActive();
        if (txbegun) {
            database.begin();
        }
        try {
            Object result = super.execute(iArgs);
            if (txbegun) {
                database.commit();
            }
            return result;
        }
        catch (Exception e) {
            if (txbegun) {
                database.rollback();
            }
            throw OException.wrapException(new OCommandExecutionException("Transactional command failed"), e);
        }
    }
}

