/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OSoftQueryResultTimSort;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class OSoftQueryResultList<E>
implements List<E> {
    private final List<SoftReference<E>> buffer;
    private final ReferenceQueue<E> queue = new ReferenceQueue();
    private final String query;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static <T> List<T> createResultList(String query) {
        if (OGlobalConfiguration.QUERY_USE_SOFT_REFENCES_IN_RESULT_SET.getValueAsBoolean()) {
            return new OSoftQueryResultList(query);
        }
        return new ArrayList();
    }

    static <T> List<T> createResultList(String query, List<T> other) {
        if (OGlobalConfiguration.QUERY_USE_SOFT_REFENCES_IN_RESULT_SET.getValueAsBoolean()) {
            return new OSoftQueryResultList<T>(other, query);
        }
        return new ArrayList<T>(other);
    }

    OSoftQueryResultList(String query) {
        this.query = query;
        this.buffer = new ArrayList<SoftReference<E>>();
    }

    OSoftQueryResultList(List<? extends E> other, String query) {
        this(query);
        for (E x : other) {
            this.buffer.add(new SoftReference<E>(x, this.queue));
        }
    }

    private OSoftQueryResultList(String query, List<SoftReference<E>> buffer) {
        this.buffer = buffer;
        this.query = query;
    }

    private void checkQueue() {
        if (this.queue.poll() != null) {
            this.throwCanExecuteException();
        }
    }

    @Override
    public int size() {
        this.checkQueue();
        return this.buffer.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkQueue();
        return this.buffer.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.checkQueue();
        for (SoftReference<E> ref : this.buffer) {
            E item = this.getItem(ref);
            if (!item.equals(o)) continue;
            return true;
        }
        return false;
    }

    private E getItem(SoftReference<E> ref) {
        this.checkQueue();
        E result = ref.get();
        if (result == null) {
            this.throwCanExecuteException();
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        this.checkQueue();
        return new Iterator<E>(){
            private SoftReference<E> current = null;
            private Iterator<SoftReference<E>> innerIterator = OSoftQueryResultList.access$000(OSoftQueryResultList.this).iterator();
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public boolean hasNext() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.hasNext();
            }

            @Override
            public E next() {
                OSoftQueryResultList.this.checkQueue();
                this.current = this.innerIterator.next();
                return OSoftQueryResultList.this.getItem(this.current);
            }

            @Override
            public void remove() {
                OSoftQueryResultList.this.checkQueue();
                if (this.current == null) {
                    throw new IllegalStateException("Can not clear currently processed soft reference");
                }
                this.current.clear();
                this.innerIterator.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Operation is not supported because may cause OOM exception");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Operation is not supported because may cause OOM exception");
    }

    @Override
    public boolean add(E e) {
        this.checkQueue();
        if (e == null) {
            throw new NullPointerException("Null value is passed");
        }
        return this.buffer.add(new SoftReference<E>(e, this.queue));
    }

    @Override
    public boolean remove(Object o) {
        this.checkQueue();
        for (SoftReference<E> ref : this.buffer) {
            E item = this.getItem(ref);
            if (!item.equals(o)) continue;
            ref.clear();
            this.buffer.remove(ref);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkQueue();
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkQueue();
        boolean added = false;
        for (E o : c) {
            added |= this.add(o);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkQueue();
        boolean added = false;
        for (E o : c) {
            added = true;
            this.add(index++, o);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkQueue();
        boolean updated = false;
        Iterator<SoftReference<E>> iter = this.buffer.iterator();
        block0: while (iter.hasNext()) {
            SoftReference<E> item = iter.next();
            E val = this.getItem(item);
            for (Object o : c) {
                if (!val.equals(o)) continue;
                updated = true;
                item.clear();
                iter.remove();
                continue block0;
            }
        }
        return updated;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkQueue();
        boolean updated = false;
        Iterator<SoftReference<E>> iter = this.buffer.iterator();
        while (iter.hasNext()) {
            SoftReference<E> item = iter.next();
            E val = this.getItem(item);
            boolean found = false;
            for (Object o : c) {
                if (!val.equals(o)) continue;
                found = true;
                break;
            }
            if (found) continue;
            item.clear();
            iter.remove();
            updated = true;
        }
        return updated;
    }

    @Override
    public void clear() {
        this.checkQueue();
        for (SoftReference<E> ref : this.buffer) {
            ref.clear();
        }
        this.buffer.clear();
    }

    @Override
    public E get(int index) {
        this.checkQueue();
        SoftReference<E> res = this.buffer.get(index);
        assert (res != null);
        return this.getItem(res);
    }

    @Override
    public E set(int index, E element) {
        this.checkQueue();
        if (element == null) {
            throw new NullPointerException("Null value passed");
        }
        SoftReference<E> res = this.buffer.set(index, new SoftReference<E>(element, this.queue));
        assert (res != null);
        E item = this.getItem(res);
        res.clear();
        return item;
    }

    @Override
    public void add(int index, E element) {
        this.checkQueue();
        if (element == null) {
            throw new NullPointerException("Null value passed");
        }
        this.buffer.add(index, new SoftReference<E>(element, this.queue));
    }

    @Override
    public E remove(int index) {
        this.checkQueue();
        SoftReference<E> res = this.buffer.remove(index);
        assert (res != null);
        E item = this.getItem(res);
        res.clear();
        return item;
    }

    @Override
    public int indexOf(Object o) {
        this.checkQueue();
        if (o == null) {
            throw new NullPointerException("Null value passed");
        }
        for (int i = 0; i < this.buffer.size(); ++i) {
            E item = this.getItem(this.buffer.get(i));
            if (!item.equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.checkQueue();
        if (o == null) {
            throw new NullPointerException("Null value passed");
        }
        for (int i = this.buffer.size() - 1; i >= 0; --i) {
            E item = this.getItem(this.buffer.get(i));
            if (!item.equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        this.checkQueue();
        return new ListIterator<E>(){
            private SoftReference<E> current = null;
            private ListIterator<SoftReference<E>> innerIterator = OSoftQueryResultList.access$000(OSoftQueryResultList.this).listIterator();
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public boolean hasNext() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.hasNext();
            }

            @Override
            public E next() {
                this.current = this.innerIterator.next();
                return OSoftQueryResultList.this.getItem(this.current);
            }

            @Override
            public boolean hasPrevious() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.hasPrevious();
            }

            @Override
            public E previous() {
                this.current = this.innerIterator.previous();
                return OSoftQueryResultList.this.getItem(this.current);
            }

            @Override
            public int nextIndex() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.previousIndex();
            }

            @Override
            public void remove() {
                OSoftQueryResultList.this.checkQueue();
                if (this.current == null) {
                    throw new IllegalStateException("Can not clear currently processed soft reference");
                }
                this.current.clear();
                this.innerIterator.remove();
            }

            @Override
            public void set(E e) {
                OSoftQueryResultList.this.checkQueue();
                if (e == null) {
                    throw new NullPointerException("Null value is passed as argument");
                }
                if (this.current == null) {
                    throw new IllegalStateException("Can not clear currently processed soft reference");
                }
                this.current.clear();
                this.innerIterator.set(new SoftReference(e, OSoftQueryResultList.this.queue));
            }

            @Override
            public void add(E e) {
                OSoftQueryResultList.this.checkQueue();
                if (e == null) {
                    throw new NullPointerException("Null value is passed as argument");
                }
                this.innerIterator.add(new SoftReference(e, OSoftQueryResultList.this.queue));
            }
        };
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        this.checkQueue();
        return new ListIterator<E>(){
            private SoftReference<E> current = null;
            private ListIterator<SoftReference<E>> innerIterator = OSoftQueryResultList.access$000(OSoftQueryResultList.this).listIterator(index);
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public boolean hasNext() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.hasNext();
            }

            @Override
            public E next() {
                this.current = this.innerIterator.next();
                return OSoftQueryResultList.this.getItem(this.current);
            }

            @Override
            public boolean hasPrevious() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.hasPrevious();
            }

            @Override
            public E previous() {
                this.current = this.innerIterator.previous();
                return OSoftQueryResultList.this.getItem(this.current);
            }

            @Override
            public int nextIndex() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                OSoftQueryResultList.this.checkQueue();
                return this.innerIterator.previousIndex();
            }

            @Override
            public void remove() {
                OSoftQueryResultList.this.checkQueue();
                if (this.current == null) {
                    throw new IllegalStateException("Can not clear currently processed soft reference");
                }
                this.current.clear();
                this.innerIterator.remove();
            }

            @Override
            public void set(E e) {
                OSoftQueryResultList.this.checkQueue();
                if (e == null) {
                    throw new NullPointerException("Null value is passed as argument");
                }
                if (this.current == null) {
                    throw new IllegalStateException("Can not clear currently processed soft reference");
                }
                this.current.clear();
                this.innerIterator.set(new SoftReference(e, OSoftQueryResultList.this.queue));
            }

            @Override
            public void add(E e) {
                OSoftQueryResultList.this.checkQueue();
                if (e == null) {
                    throw new NullPointerException("Null value is passed as argument");
                }
                this.innerIterator.add(new SoftReference(e, OSoftQueryResultList.this.queue));
            }
        };
    }

    @Override
    public OSoftQueryResultList<E> subList(int fromIndex, int toIndex) {
        this.checkQueue();
        return new OSoftQueryResultList<E>(this.query, this.buffer.subList(fromIndex, toIndex));
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        this.checkQueue();
        SoftReference[] softRefs = new SoftReference[this.buffer.size()];
        for (int i = 0; i < softRefs.length; ++i) {
            softRefs[i] = this.buffer.get(i);
        }
        OSoftQueryResultTimSort<? super E> sort = new OSoftQueryResultTimSort<E>(this.query, this.queue);
        sort.sort(softRefs, 0, this.buffer.size(), comparator);
        for (int i = 0; i < this.buffer.size(); ++i) {
            this.buffer.set(i, softRefs[i]);
        }
    }

    private void throwCanExecuteException() {
        if (this.query != null) {
            throw new OCommandExecutionException("Cannot execute query \"" + this.query + "\": low heap memory");
        }
        throw new OCommandExecutionException("Cannot execute query: low heap memory");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)obj).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    static /* synthetic */ List access$000(OSoftQueryResultList x0) {
        return x0.buffer;
    }

    static {
        try {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

