/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionMap
extends OSQLFunctionMultiValueAbstract<Map<Object, Object>> {
    public static final String NAME = "map";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLFunctionMap() {
        super(NAME, 1, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams.length > 2) {
            this.context = new HashMap();
        }
        if (iParams.length == 1) {
            if (iParams[0] == null) {
                return null;
            }
            if (!(iParams[0] instanceof Map)) throw new IllegalArgumentException("Map function: expected a map or pairs of parameters as key, value");
            if (this.context == null) {
                this.context = new HashMap();
            }
            ((Map)this.context).putAll((Map)iParams[0]);
            return this.prepareResult((Map)this.context);
        } else {
            if (iParams.length % 2 != 0) {
                throw new IllegalArgumentException("Map function: expected a map or pairs of parameters as key, value");
            }
            for (int i = 0; i < iParams.length; i += 2) {
                Object key = iParams[i];
                Object value = iParams[i + 1];
                if (value == null) continue;
                if (iParams.length <= 2 && this.context == null) {
                    this.context = new HashMap();
                }
                ((Map)this.context).put(key, value);
            }
        }
        return this.prepareResult((Map)this.context);
    }

    @Override
    public String getSyntax() {
        return "map(<map>|[<key>,<value>]*)";
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return configuredParameters.length <= 2;
    }

    @Override
    public Map<Object, Object> getResult() {
        Map res = (Map)this.context;
        this.context = null;
        return this.prepareResult(res);
    }

    protected Map<Object, Object> prepareResult(Map<Object, Object> res) {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("node", this.getDistributedStorageId());
            doc.put("context", res);
            return Collections.singletonMap("doc", doc);
        }
        return res;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        if (this.returnDistributedResult()) {
            HashMap result = new HashMap();
            for (Object iParameter : resultsToMerge) {
                Map container = (Map)((Map)iParameter).get("doc");
                result.putAll((Map)container.get("context"));
            }
            return result;
        }
        if (!resultsToMerge.isEmpty()) {
            return resultsToMerge.get(0);
        }
        return null;
    }
}

