/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class OSQLFunctionAbsoluteValue
extends OSQLFunctionMathAbstract {
    public static final String NAME = "abs";
    private Object result;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLFunctionAbsoluteValue() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object inputValue = iParams[0];
        if (inputValue == null) {
            this.result = null;
        } else if (inputValue instanceof BigDecimal) {
            this.result = ((BigDecimal)inputValue).abs();
        } else if (inputValue instanceof BigInteger) {
            this.result = ((BigInteger)inputValue).abs();
        } else if (inputValue instanceof Integer) {
            this.result = Math.abs((Integer)inputValue);
        } else if (inputValue instanceof Long) {
            this.result = Math.abs((Long)inputValue);
        } else if (inputValue instanceof Short) {
            this.result = (short)Math.abs(((Short)inputValue).shortValue());
        } else if (inputValue instanceof Double) {
            this.result = Math.abs((Double)inputValue);
        } else if (inputValue instanceof Float) {
            this.result = Float.valueOf(Math.abs(((Float)inputValue).floatValue()));
        } else {
            throw new IllegalArgumentException("Argument to absolute value must be a number.");
        }
        return this.getResult();
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "abs(<number>)";
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        return null;
    }
}

