/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OQueryOperatorContainsKey
extends OQueryOperatorEqualityNotNulls {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OQueryOperatorContainsKey() {
        super("CONTAINSKEY", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            return map.containsKey(iRight);
        }
        if (iRight instanceof Map) {
            Map map = (Map)iRight;
            return map.containsKey(iLeft);
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            if (!(indexDefinition instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)indexDefinition).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
                return null;
            }
            Object key = ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0));
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, key) : new OIndexCursorCollectionValue((Collection)indexResult, key);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            if (!(compositeIndexDefinition.getMultiValueDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)compositeIndexDefinition.getMultiValueDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
                return null;
            }
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            if (internalIndex.hasRangeQuerySupport()) {
                OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
                cursor = index.iterateEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                Object indexResult = index.get(keyOne);
                cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, keyOne) : new OIndexCursorCollectionValue((Collection)indexResult, keyOne);
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

