/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import java.math.BigDecimal;
import java.util.Date;

public class OQueryOperatorMultiply
extends OQueryOperator {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OQueryOperatorMultiply() {
        super("*", 10, false);
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iRight == null || iLeft == null) {
            return null;
        }
        if (iLeft instanceof Date) {
            iLeft = ((Date)iLeft).getTime();
        }
        if (iRight instanceof Date) {
            iRight = ((Date)iRight).getTime();
        }
        if (iLeft instanceof Number && iRight instanceof Number) {
            Number l = (Number)iLeft;
            Number r = (Number)iRight;
            Class maxPrecisionClass = OQueryOperatorMultiply.getMaxPrecisionClass(l, r);
            if (Integer.class.equals((Object)maxPrecisionClass)) {
                return OQueryOperatorMultiply.tryDownscaleToInt(l.longValue() * r.longValue());
            }
            if (Long.class.equals((Object)maxPrecisionClass)) {
                return l.longValue() * r.longValue();
            }
            if (Short.class.equals((Object)maxPrecisionClass)) {
                return l.shortValue() * r.shortValue();
            }
            if (Float.class.equals((Object)maxPrecisionClass)) {
                return Float.valueOf(l.floatValue() * r.floatValue());
            }
            if (Double.class.equals((Object)maxPrecisionClass)) {
                return l.doubleValue() * r.doubleValue();
            }
            if (BigDecimal.class.equals((Object)maxPrecisionClass)) {
                return OQueryOperatorMultiply.toBigDecimal(l).multiply(OQueryOperatorMultiply.toBigDecimal(r));
            }
        }
        return null;
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Float) {
            return new BigDecimal(number.floatValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Integer) {
            return new BigDecimal(number.intValue());
        }
        if (number instanceof Short) {
            return new BigDecimal(number.intValue());
        }
        return null;
    }

    public static Class getMaxPrecisionClass(Number l, Number r) {
        Class<?> lClass = l.getClass();
        Class<?> rClass = r.getClass();
        if (lClass.equals(BigDecimal.class) || rClass.equals(BigDecimal.class)) {
            return BigDecimal.class;
        }
        if (lClass.equals(Double.class) || rClass.equals(Double.class)) {
            return Double.class;
        }
        if (lClass.equals(Float.class) || rClass.equals(Float.class)) {
            return Float.class;
        }
        if (lClass.equals(Long.class) || rClass.equals(Long.class)) {
            return Long.class;
        }
        if (lClass.equals(Integer.class) || rClass.equals(Integer.class)) {
            return Integer.class;
        }
        if (lClass.equals(Short.class) || rClass.equals(Short.class)) {
            return Short.class;
        }
        return null;
    }

    public static Object tryDownscaleToInt(long value) {
        if (value < Integer.MAX_VALUE && value > Integer.MIN_VALUE) {
            return (int)value;
        }
        return value;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

