/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OAndBlock
extends OBooleanExpression {
    List<OBooleanExpression> subBlocks = new ArrayList<OBooleanExpression>();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OAndBlock(int id) {
        super(id);
    }

    public OAndBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        if (this.getSubBlocks() == null) {
            return true;
        }
        for (OBooleanExpression block : this.subBlocks) {
            if (block.evaluate(currentRecord, ctx)) continue;
            return false;
        }
        return true;
    }

    public List<OBooleanExpression> getSubBlocks() {
        return this.subBlocks;
    }

    public void setSubBlocks(List<OBooleanExpression> subBlocks) {
        this.subBlocks = subBlocks;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.subBlocks == null || this.subBlocks.size() == 0) {
            return;
        }
        boolean first = true;
        for (OBooleanExpression expr : this.subBlocks) {
            if (!first) {
                builder.append(" AND ");
            }
            expr.toString(params, builder);
            first = false;
        }
    }

    @Override
    protected boolean supportsBasicCalculation() {
        for (OBooleanExpression expr : this.subBlocks) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int result = 0;
        for (OBooleanExpression expr : this.subBlocks) {
            result += expr.getNumberOfExternalCalculations();
        }
        return result;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OBooleanExpression expr : this.subBlocks) {
            result.addAll(expr.getExternalCalculationConditions());
        }
        return result;
    }

    @Override
    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.subBlocks == null) {
            return null;
        }
        ArrayList<OBinaryCondition> result = new ArrayList<OBinaryCondition>();
        for (OBooleanExpression exp : this.subBlocks) {
            List<OBinaryCondition> sub = exp.getIndexedFunctionConditions(iSchemaClass, database);
            if (sub == null || sub.size() <= 0) continue;
            result.addAll(sub);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public List<OAndBlock> flatten() {
        ArrayList<OAndBlock> result = new ArrayList<OAndBlock>();
        boolean first = true;
        for (OBooleanExpression sub : this.subBlocks) {
            List<OAndBlock> subFlattened = sub.flatten();
            ArrayList<OAndBlock> oldResult = result;
            result = new ArrayList();
            for (OAndBlock subAndItem : subFlattened) {
                if (first) {
                    result.add(subAndItem);
                    continue;
                }
                for (OAndBlock oldResultItem : oldResult) {
                    OAndBlock block = new OAndBlock(-1);
                    block.subBlocks.addAll(oldResultItem.subBlocks);
                    for (OBooleanExpression resultItem : subAndItem.subBlocks) {
                        block.subBlocks.add(resultItem);
                    }
                    result.add(block);
                }
            }
            first = false;
        }
        return result;
    }

    @Override
    protected OAndBlock encapsulateInAndBlock(OBooleanExpression item) {
        if (item instanceof OAndBlock) {
            return (OAndBlock)item;
        }
        OAndBlock result = new OAndBlock(-1);
        result.subBlocks.add(item);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        for (OBooleanExpression exp : this.subBlocks) {
            List<String> x = exp.getMatchPatternInvolvedAliases();
            if (x == null) continue;
            result.addAll(x);
        }
        return result.size() == 0 ? null : result;
    }
}

