/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OBaseExpression
extends OMathExpression {
    private static final Object UNSET;
    private Object inputFinalValue = UNSET;
    protected ONumber number;
    protected OBaseIdentifier identifier;
    protected OInputParameter inputParam;
    protected String string;
    OModifier modifier;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OBaseExpression(int id) {
        super(id);
    }

    public OBaseExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.number != null) {
            this.number.toString(params, builder);
        } else if (this.identifier != null) {
            this.identifier.toString(params, builder);
        } else if (this.string != null) {
            builder.append(this.string);
        } else if (this.inputParam != null) {
            this.inputParam.toString(params, builder);
        }
        if (this.modifier != null) {
            this.modifier.toString(params, builder);
        }
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        Object result = null;
        if (this.number != null) {
            result = this.number.getValue();
        }
        if (this.identifier != null) {
            result = this.identifier.execute(iCurrentRecord, ctx);
        }
        if (this.string != null && this.string.length() > 1) {
            result = OStringSerializerHelper.decode(this.string.substring(1, this.string.length() - 1));
        }
        if (this.modifier != null) {
            result = this.modifier.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    @Override
    protected boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    public boolean isIndexedFunctionCall() {
        if (this.identifier == null) {
            return false;
        }
        return this.identifier.isIndexedFunctionCall();
    }

    @Override
    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return -1L;
        }
        return this.identifier.estimateIndexedFunction(target, context, operator, right);
    }

    @Override
    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return null;
        }
        return this.identifier.executeIndexedFunction(target, context, operator, right);
    }

    @Override
    public boolean isBaseIdentifier() {
        return this.identifier != null && this.modifier == null && this.identifier.isBaseIdentifier();
    }

    public OIdentifier getBaseIdentifier() {
        return this.identifier.suffix.identifier;
    }

    @Override
    public boolean isEarlyCalculated() {
        return this.number != null || this.inputParam != null || this.string != null;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        if (this.identifier != null && this.identifier.toString().equals("$matched") && this.modifier != null && this.modifier.suffix != null && this.modifier.suffix.identifier != null) {
            return Collections.singletonList(this.modifier.suffix.identifier.toString());
        }
        return null;
    }

    static {
        try {
            try {
                UNSET = new Object();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

