/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIndexName;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCreateIndexStatement
extends OStatement {
    protected OIndexName name;
    protected OIdentifier className;
    protected List<Property> propertyList = new ArrayList<Property>();
    protected OIdentifier type;
    protected OIdentifier engine;
    protected List<OIdentifier> keyTypes = new ArrayList<OIdentifier>();
    protected OJson metadata;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OCreateIndexStatement(int id) {
        super(id);
    }

    public OCreateIndexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first;
        builder.append("CREATE INDEX ");
        this.name.toString(params, builder);
        if (this.className != null) {
            builder.append(" ON ");
            this.className.toString(params, builder);
            builder.append(" (");
            first = true;
            for (Property prop : this.propertyList) {
                if (!first) {
                    builder.append(", ");
                }
                if (prop.name != null) {
                    prop.name.toString(params, builder);
                } else {
                    prop.recordAttribute.toString(params, builder);
                }
                if (prop.byKey) {
                    builder.append(" BY KEY");
                } else if (prop.byValue) {
                    builder.append(" BY VALUE");
                }
                if (prop.collate != null) {
                    builder.append(" COLLATE ");
                    prop.collate.toString(params, builder);
                }
                first = false;
            }
            builder.append(")");
        }
        builder.append(" ");
        this.type.toString(params, builder);
        if (this.engine != null) {
            builder.append(" ENGINE ");
            this.engine.toString(params, builder);
        }
        if (this.keyTypes != null && this.keyTypes.size() > 0) {
            first = true;
            builder.append(" ");
            for (OIdentifier keyType : this.keyTypes) {
                if (!first) {
                    builder.append(",");
                }
                keyType.toString(params, builder);
                first = false;
            }
        }
        if (this.metadata != null) {
            builder.append(" METADATA ");
            this.metadata.toString(params, builder);
        }
    }

    public static class Property {
        protected OIdentifier name;
        protected ORecordAttribute recordAttribute;
        protected OIdentifier className;
        protected boolean byKey = false;
        protected boolean byValue = false;
        protected OIdentifier collate;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
    }
}

