/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.List;
import java.util.Map;

public class OExpression
extends SimpleNode {
    protected Boolean singleQuotes;
    protected Boolean doubleQuotes;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OExpression(int id) {
        super(id);
    }

    public OExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.value instanceof ORid) {
            ORid v = (ORid)this.value;
            return new ORecordId(v.cluster.getValue().intValue(), v.position.getValue().longValue());
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).execute(iCurrentRecord, ctx);
        }
        if (this.value instanceof OJson) {
            return ((OJson)this.value).toMap(iCurrentRecord, ctx);
        }
        if (this.value instanceof String) {
            return this.value;
        }
        if (this.value instanceof Number) {
            return this.value;
        }
        return this.value;
    }

    public boolean isBaseIdentifier() {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).isBaseIdentifier();
        }
        return false;
    }

    public boolean isEarlyCalculated() {
        if (this.value instanceof Number) {
            return true;
        }
        if (this.value instanceof String) {
            return true;
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).isEarlyCalculated();
        }
        return false;
    }

    public OIdentifier getDefaultAlias() {
        if (this.value instanceof String) {
            OIdentifier identifier = new OIdentifier(-1);
            identifier.setValue((String)this.value);
            return identifier;
        }
        if (this.value instanceof OBaseExpression && ((OBaseExpression)this.value).isBaseIdentifier()) {
            return ((OBaseExpression)this.value).identifier.suffix.identifier;
        }
        String result = ("" + this.value).replaceAll("\\.", "_").replaceAll(" ", "_").replaceAll("\n", "_").replaceAll("\b", "_").replaceAll("\\[", "_").replaceAll("\\]", "_").replaceAll("\\(", "_").replaceAll("\\)", "_");
        OIdentifier identifier = new OIdentifier(-1);
        identifier.setValue(result);
        return identifier;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.value == null) {
            builder.append("null");
        } else if (this.value instanceof SimpleNode) {
            ((SimpleNode)this.value).toString(params, builder);
        } else if (this.value instanceof String) {
            if (Boolean.TRUE.equals(this.singleQuotes)) {
                builder.append("'" + OExpression.encode((String)this.value) + "'");
            } else {
                builder.append("\"" + OExpression.encode((String)this.value) + "\"");
            }
        } else {
            builder.append("" + this.value);
        }
    }

    public static String encode(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (char c : s.toCharArray()) {
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c == '\\' || c == '\"' || c == '\'') {
                builder.append("\\");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public boolean supportsBasicCalculation() {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).supportsBasicCalculation();
        }
        return true;
    }

    public boolean isIndexedFunctionCal() {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).isIndexedFunctionCall();
        }
        return false;
    }

    public static String encodeSingle(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (char c : s.toCharArray()) {
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c == '\\' || c == '\'') {
                builder.append("\\");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).estimateIndexedFunction(target, context, operator, right);
        }
        return -1L;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).executeIndexedFunction(target, context, operator, right);
        }
        return null;
    }

    List<String> getMatchPatternInvolvedAliases() {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).getMatchPatternInvolvedAliases();
        }
        return null;
    }
}

