/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.filter.OSQLTarget;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OInCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OBinaryCompareOperator operator;
    protected OSelectStatement rightStatement;
    protected OInputParameter rightParam;
    protected OMathExpression rightMathExpression;
    protected Object right;
    private static final Object UNSET;
    private Object inputFinalValue = UNSET;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OInCondition(int id) {
        super(id);
    }

    public OInCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        Object rightValue = null;
        rightValue = this.rightStatement != null ? this.query(this.rightStatement.toString(), ctx) : (this.rightParam != null ? this.rightParam.bindFromInputParams(ctx.getInputParameters()) : (this.rightMathExpression != null ? this.rightMathExpression.execute(currentRecord, ctx) : this.right));
        if (rightValue == null) {
            return false;
        }
        if (rightValue instanceof Collection) {
            return ((Collection)rightValue).contains(leftValue);
        }
        if (rightValue instanceof OIdentifiable) {
            return rightValue.equals(leftValue);
        }
        if (rightValue instanceof Iterable) {
            rightValue = ((Iterable)rightValue).iterator();
        }
        if (rightValue instanceof Iterator) {
            Iterator iter = rightValue;
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next == null && leftValue == null) {
                    return true;
                }
                if (next == null || !next.equals(leftValue)) continue;
                return true;
            }
        }
        return false;
    }

    private Object query(String text, OCommandContext ctx) {
        OSQLTarget target = new OSQLTarget(text, ctx);
        Iterable<? extends OIdentifiable> targetResult = target.getTargetRecords();
        if (targetResult == null) {
            return null;
        }
        return targetResult.iterator();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" IN ");
        if (this.rightStatement != null) {
            builder.append("(");
            this.rightStatement.toString(params, builder);
            builder.append(")");
        } else if (this.right != null) {
            builder.append(this.convertToString(this.right));
        } else if (this.rightParam != null) {
            this.rightParam.toString(params, builder);
        } else if (this.rightMathExpression != null) {
            this.rightMathExpression.toString(params, builder);
        }
    }

    private String convertToString(Object o) {
        if (o instanceof String) {
            return "\"" + ((String)o).replaceAll("\"", "\\\"") + "\"";
        }
        return o.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (!this.left.supportsBasicCalculation()) {
            return false;
        }
        if (!this.rightMathExpression.supportsBasicCalculation()) {
            return false;
        }
        return this.operator.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.operator != null) {
            result.add(this);
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            result.add(this.rightMathExpression);
        }
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> conditionX = this.rightMathExpression == null ? null : this.rightMathExpression.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (conditionX != null) {
            result.addAll(conditionX);
        }
        return result.size() == 0 ? null : result;
    }

    static {
        try {
            try {
                UNSET = new Object();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

