/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OMathExpression
extends SimpleNode {
    protected List<OMathExpression> childExpressions = new ArrayList<OMathExpression>();
    protected List<Operator> operators = new ArrayList<Operator>();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OMathExpression(int id) {
        super(id);
    }

    public OMathExpression(OrientSql p, int id) {
        super(p, id);
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.childExpressions.size() == 0) {
            return null;
        }
        OMathExpression nextExpression = this.childExpressions.get(0);
        Object nextValue = nextExpression.execute(iCurrentRecord, ctx);
        for (int i = 0; i < this.operators.size() && i + 1 < this.childExpressions.size(); ++i) {
            Operator nextOperator = this.operators.get(i);
            Object rightValue = this.childExpressions.get(i + 1).execute(iCurrentRecord, ctx);
            nextValue = this.apply(nextValue, nextOperator, rightValue);
        }
        return nextValue;
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<OMathExpression> getChildExpressions() {
        return this.childExpressions;
    }

    public void setChildExpressions(List<OMathExpression> childExpressions) {
        this.childExpressions = childExpressions;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        for (int i = 0; i < this.childExpressions.size(); ++i) {
            if (i > 0) {
                builder.append(" ");
                switch (this.operators.get(i - 1)) {
                    case PLUS: {
                        builder.append("+");
                        break;
                    }
                    case MINUS: {
                        builder.append("-");
                        break;
                    }
                    case STAR: {
                        builder.append("*");
                        break;
                    }
                    case SLASH: {
                        builder.append("/");
                        break;
                    }
                    case REM: {
                        builder.append("%");
                    }
                }
                builder.append(" ");
            }
            this.childExpressions.get(i).toString(params, builder);
        }
    }

    public Object apply(Object a, Operator operation, Object b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (a instanceof Number && b instanceof Number) {
            return this.apply((Number)a, operation, (Number)b);
        }
        if (a instanceof String || b instanceof String) {
            return "" + a + b;
        }
        throw new IllegalArgumentException("Cannot apply operaton " + (Object)((Object)operation) + " to value '" + a + "' (" + a.getClass() + ") with '" + b + "' (" + b.getClass() + ")");
    }

    public Number apply(Number a, Operator operation, Number b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Cannot increment a null value");
        }
        if (a instanceof Integer || a instanceof Short) {
            if (b instanceof Integer || b instanceof Short) {
                return operation.apply(a.intValue(), b.intValue());
            }
            if (b instanceof Long) {
                return operation.apply(a.longValue(), b.longValue());
            }
            if (b instanceof Float) {
                return operation.apply(Float.valueOf(a.floatValue()), Float.valueOf(b.floatValue()));
            }
            if (b instanceof Double) {
                return operation.apply(a.doubleValue(), b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return operation.apply(new BigDecimal((Integer)a), (BigDecimal)b);
            }
        } else if (a instanceof Long) {
            if (b instanceof Integer || b instanceof Long || b instanceof Short) {
                return operation.apply(a.longValue(), b.longValue());
            }
            if (b instanceof Float) {
                return operation.apply(Float.valueOf(a.floatValue()), Float.valueOf(b.floatValue()));
            }
            if (b instanceof Double) {
                return operation.apply(a.doubleValue(), b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return operation.apply(new BigDecimal((Long)a), (BigDecimal)b);
            }
        } else if (a instanceof Float) {
            if (b instanceof Short || b instanceof Integer || b instanceof Long || b instanceof Float) {
                return operation.apply(Float.valueOf(a.floatValue()), Float.valueOf(b.floatValue()));
            }
            if (b instanceof Double) {
                return operation.apply(a.doubleValue(), b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return operation.apply(new BigDecimal(((Float)a).floatValue()), (BigDecimal)b);
            }
        } else if (a instanceof Double) {
            if (b instanceof Short || b instanceof Integer || b instanceof Long || b instanceof Float || b instanceof Double) {
                return operation.apply(a.doubleValue(), b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return operation.apply(new BigDecimal((Double)a), (BigDecimal)b);
            }
        } else if (a instanceof BigDecimal) {
            if (b instanceof Integer) {
                return operation.apply((BigDecimal)a, new BigDecimal((Integer)b));
            }
            if (b instanceof Long) {
                return operation.apply((BigDecimal)a, new BigDecimal((Long)b));
            }
            if (b instanceof Short) {
                return operation.apply((BigDecimal)a, new BigDecimal(((Short)b).shortValue()));
            }
            if (b instanceof Float) {
                return operation.apply((BigDecimal)a, new BigDecimal(((Float)b).floatValue()));
            }
            if (b instanceof Double) {
                return operation.apply((BigDecimal)a, new BigDecimal((Double)b));
            }
            if (b instanceof BigDecimal) {
                return operation.apply((BigDecimal)a, (BigDecimal)b);
            }
        }
        throw new IllegalArgumentException("Cannot increment value '" + a + "' (" + a.getClass() + ") with '" + b + "' (" + b.getClass() + ")");
    }

    protected boolean supportsBasicCalculation() {
        for (OMathExpression expr : this.childExpressions) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    public boolean isIndexedFunctionCall() {
        if (this.childExpressions.size() != 1) {
            return false;
        }
        return this.childExpressions.get(0).isIndexedFunctionCall();
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return -1L;
        }
        return this.childExpressions.get(0).estimateIndexedFunction(target, context, operator, right);
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return null;
        }
        return this.childExpressions.get(0).executeIndexedFunction(target, context, operator, right);
    }

    public boolean isBaseIdentifier() {
        if (this.childExpressions.size() == 1) {
            return this.childExpressions.get(0).isBaseIdentifier();
        }
        return false;
    }

    public boolean isEarlyCalculated() {
        for (OMathExpression exp : this.childExpressions) {
            if (exp.isEarlyCalculated()) continue;
            return false;
        }
        return true;
    }

    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        for (OMathExpression exp : this.childExpressions) {
            List<String> x = exp.getMatchPatternInvolvedAliases();
            if (x == null) continue;
            result.addAll(x);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public static abstract class Operator
    extends Enum<Operator> {
        public static final /* enum */ Operator PLUS;
        public static final /* enum */ Operator MINUS;
        public static final /* enum */ Operator STAR;
        public static final /* enum */ Operator SLASH;
        public static final /* enum */ Operator REM;
        private static final /* synthetic */ Operator[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static Operator[] values() {
            return (Operator[])$VALUES.clone();
        }

        public static Operator valueOf(String name) {
            return Enum.valueOf(Operator.class, name);
        }

        public abstract Number apply(Integer var1, Integer var2);

        public abstract Number apply(Long var1, Long var2);

        public abstract Number apply(Float var1, Float var2);

        public abstract Number apply(Double var1, Double var2);

        public abstract Number apply(BigDecimal var1, BigDecimal var2);

        static {
            try {
                try {
                    PLUS = new Operator(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        @Override
                        public Number apply(Integer left, Integer right) {
                            Integer sum = left + right;
                            if (sum < 0 && left > 0 && right > 0) {
                                return left.longValue() + (long)right.intValue();
                            }
                            return sum;
                        }

                        @Override
                        public Number apply(Long left, Long right) {
                            return left + right;
                        }

                        @Override
                        public Number apply(Float left, Float right) {
                            return Float.valueOf(left.floatValue() + right.floatValue());
                        }

                        @Override
                        public Number apply(Double left, Double right) {
                            return left + right;
                        }

                        @Override
                        public Number apply(BigDecimal left, BigDecimal right) {
                            return left.add(right);
                        }
                    };
                    MINUS = new Operator(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        @Override
                        public Number apply(Integer left, Integer right) {
                            int result = left - right;
                            if (result > 0 && left < 0 && right > 0) {
                                return left.longValue() - (long)right.intValue();
                            }
                            return result;
                        }

                        @Override
                        public Number apply(Long left, Long right) {
                            return left - right;
                        }

                        @Override
                        public Number apply(Float left, Float right) {
                            return Float.valueOf(left.floatValue() - right.floatValue());
                        }

                        @Override
                        public Number apply(Double left, Double right) {
                            return left - right;
                        }

                        @Override
                        public Number apply(BigDecimal left, BigDecimal right) {
                            return left.subtract(right);
                        }
                    };
                    STAR = new Operator(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        @Override
                        public Number apply(Integer left, Integer right) {
                            return left * right;
                        }

                        @Override
                        public Number apply(Long left, Long right) {
                            return left * right;
                        }

                        @Override
                        public Number apply(Float left, Float right) {
                            return Float.valueOf(left.floatValue() * right.floatValue());
                        }

                        @Override
                        public Number apply(Double left, Double right) {
                            return left * right;
                        }

                        @Override
                        public Number apply(BigDecimal left, BigDecimal right) {
                            return left.multiply(right);
                        }
                    };
                    SLASH = new Operator(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        @Override
                        public Number apply(Integer left, Integer right) {
                            return left / right;
                        }

                        @Override
                        public Number apply(Long left, Long right) {
                            return left / right;
                        }

                        @Override
                        public Number apply(Float left, Float right) {
                            return Float.valueOf(left.floatValue() / right.floatValue());
                        }

                        @Override
                        public Number apply(Double left, Double right) {
                            return left / right;
                        }

                        @Override
                        public Number apply(BigDecimal left, BigDecimal right) {
                            return left.divide(right, 4);
                        }
                    };
                    REM = new Operator(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        @Override
                        public Number apply(Integer left, Integer right) {
                            return left % right;
                        }

                        @Override
                        public Number apply(Long left, Long right) {
                            return left % right;
                        }

                        @Override
                        public Number apply(Float left, Float right) {
                            return Float.valueOf(left.floatValue() % right.floatValue());
                        }

                        @Override
                        public Number apply(Double left, Double right) {
                            return left % right;
                        }

                        @Override
                        public Number apply(BigDecimal left, BigDecimal right) {
                            return left.remainder(right);
                        }
                    };
                    $VALUES = new Operator[]{PLUS, MINUS, STAR, SLASH, REM};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

