/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OArrayRangeSelector;
import com.orientechnologies.orient.core.sql.parser.OArraySingleValuesSelector;
import com.orientechnologies.orient.core.sql.parser.OMethodCall;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import com.orientechnologies.orient.core.sql.parser.OSuffixIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class OModifier
extends SimpleNode {
    boolean squareBrackets = false;
    OArrayRangeSelector arrayRange;
    OOrBlock condition;
    OArraySingleValuesSelector arraySingleValues;
    OMethodCall methodCall;
    OSuffixIdentifier suffix;
    OModifier next;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OModifier(int id) {
        super(id);
    }

    public OModifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.squareBrackets) {
            builder.append("[");
            if (this.arrayRange != null) {
                this.arrayRange.toString(params, builder);
            } else if (this.condition != null) {
                this.condition.toString(params, builder);
            } else if (this.arraySingleValues != null) {
                this.arraySingleValues.toString(params, builder);
            }
            builder.append("]");
        } else if (this.methodCall != null) {
            this.methodCall.toString(params, builder);
        } else if (this.suffix != null) {
            builder.append(".");
            this.suffix.toString(params, builder);
        }
        if (this.next != null) {
            this.next.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, Object result, OCommandContext ctx) {
        if (this.methodCall != null) {
            result = this.methodCall.execute(result, ctx);
        } else if (this.suffix != null) {
            result = this.suffix.execute(result, ctx);
        } else if (this.arrayRange != null) {
            result = this.arrayRange.execute(iCurrentRecord, result, ctx);
        } else if (this.condition != null) {
            result = this.filterByCondition(iCurrentRecord, result, ctx);
        } else if (this.arraySingleValues != null) {
            result = this.arraySingleValues.execute(iCurrentRecord, result, ctx);
        }
        if (this.next != null) {
            result = this.next.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    private Object filterByCondition(OIdentifiable iCurrentRecord, Object iResult, OCommandContext ctx) {
        if (iResult == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (iResult.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(iResult); ++i) {
                Object item = Array.get(iResult, i);
                if (!this.condition.evaluate(item, ctx)) continue;
                result.add(item);
            }
            return result;
        }
        if (iResult instanceof Iterable) {
            iResult = ((Iterable)((Object)iResult)).iterator();
        }
        if (iResult instanceof Iterator) {
            while (iResult.hasNext()) {
                Object item = iResult.next();
                if (!this.condition.evaluate(item, ctx)) continue;
                result.add(item);
            }
        }
        return result;
    }
}

