/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OPhysicalPosition
implements OSerializableStream,
Externalizable {
    public static final int binarySize = 17;
    public long clusterPosition;
    public byte recordType;
    public int recordVersion = 0;
    public int recordSize;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(long iClusterPosition) {
        this.clusterPosition = iClusterPosition;
    }

    public OPhysicalPosition(byte iRecordType) {
        this.recordType = iRecordType;
    }

    public OPhysicalPosition(long iClusterPosition, int iVersion) {
        this.clusterPosition = iClusterPosition;
        this.recordVersion = iVersion;
    }

    public static int binarySize() {
        return 17;
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.clusterPosition = this.clusterPosition;
        iDest.recordType = this.recordType;
        iDest.recordVersion = this.recordVersion;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "rid(?:" + this.clusterPosition + ") record(type:" + this.recordType + " size:" + this.recordSize + " v:" + this.recordVersion + ")";
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.clusterPosition = OBinaryProtocol.bytes2long(iStream);
        this.recordType = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.recordVersion = OBinaryProtocol.bytes2int(iStream, pos += 4);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[OPhysicalPosition.binarySize()];
        int pos = 0;
        OBinaryProtocol.long2bytes(this.clusterPosition, buffer, pos);
        buffer[pos += 8] = this.recordType;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        OBinaryProtocol.int2bytes(this.recordVersion, buffer, pos += 4);
        return buffer;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OPhysicalPosition)) {
            return false;
        }
        OPhysicalPosition other = (OPhysicalPosition)obj;
        return this.clusterPosition == other.clusterPosition && this.recordType == other.recordType && this.recordVersion == other.recordVersion && this.recordSize == other.recordSize;
    }

    public int hashCode() {
        int result = (int)(31L * this.clusterPosition);
        result = 31 * result + this.recordType;
        result = 31 * result + this.recordVersion;
        result = 31 * result + this.recordSize;
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.clusterPosition);
        out.writeByte(this.recordType);
        out.writeInt(this.recordSize);
        out.writeInt(this.recordVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterPosition = in.readLong();
        this.recordType = in.readByte();
        this.recordSize = in.readInt();
        this.recordVersion = in.readInt();
    }
}

