/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.util.OBackupable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public interface OStorage
extends OBackupable,
OSharedContainer {
    public static final String CLUSTER_DEFAULT_NAME = "default";
    public static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public void open(String var1, String var2, Map<String, Object> var3);

    public void create(Map<String, Object> var1);

    public boolean exists();

    public void reload();

    public void delete();

    public void close();

    public void close(boolean var1, boolean var2);

    public boolean isClosed();

    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId var1, byte[] var2, int var3, byte var4, int var5, ORecordCallback<Long> var6);

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId var1, String var2, boolean var3, boolean var4, ORecordCallback<ORawBuffer> var5);

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId var1, String var2, boolean var3, int var4) throws ORecordNotFoundException;

    public OStorageOperationResult<Integer> updateRecord(ORecordId var1, boolean var2, byte[] var3, int var4, byte var5, int var6, ORecordCallback<Integer> var7);

    public void recyclePosition(ORecordId var1, byte[] var2, int var3, byte var4);

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId var1, int var2, int var3, ORecordCallback<Boolean> var4);

    public ORecordMetadata getRecordMetadata(ORID var1);

    public boolean cleanOutRecord(ORecordId var1, int var2, int var3, ORecordCallback<Boolean> var4);

    public List<ORecordOperation> commit(OTransaction var1, Runnable var2);

    public void rollback(OTransaction var1);

    public OStorageConfiguration getConfiguration();

    public int getClusters();

    public Set<String> getClusterNames();

    public OCluster getClusterById(int var1);

    public Collection<? extends OCluster> getClusterInstances();

    public int addCluster(String var1, boolean var2, Object ... var3);

    public int addCluster(String var1, int var2, boolean var3, Object ... var4);

    public boolean dropCluster(String var1, boolean var2);

    public boolean dropCluster(int var1, boolean var2);

    public long count(int var1);

    public long count(int var1, boolean var2);

    public long count(int[] var1);

    public long count(int[] var1, boolean var2);

    public long getSize();

    public long countRecords();

    public int getDefaultClusterId();

    public void setDefaultClusterId(int var1);

    public int getClusterIdByName(String var1);

    public String getPhysicalClusterNameById(int var1);

    public boolean checkForRecordValidity(OPhysicalPosition var1);

    public String getName();

    public String getURL();

    public long getVersion();

    public void synch();

    public Object command(OCommandRequestText var1);

    public long[] getClusterDataRange(int var1);

    public <V> V callInLock(Callable<V> var1, boolean var2);

    public OPhysicalPosition[] higherPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] lowerPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] ceilingPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] floorPhysicalPositions(int var1, OPhysicalPosition var2);

    public STATUS getStatus();

    public String getType();

    public void checkForClusterPermissions(String var1);

    public OStorage getUnderlying();

    public boolean isRemote();

    public boolean isDistributed();

    public boolean isAssigningClusterIds();

    public OSBTreeCollectionManager getSBtreeCollectionManager();

    public OCurrentStorageComponentsFactory getComponentsFactory();

    public OStorageOperationResult<Boolean> hideRecord(ORecordId var1, int var2, ORecordCallback<Boolean> var3);

    public OCluster getClusterByName(String var1);

    public ORecordConflictStrategy getConflictStrategy();

    public void setConflictStrategy(ORecordConflictStrategy var1);

    public String incrementalBackup(String var1);

    public void restoreFromIncrementalBackup(String var1);

    public void shutdown();

    public static final class LOCKING_STRATEGY
    extends Enum<LOCKING_STRATEGY> {
        public static final /* enum */ LOCKING_STRATEGY NONE;
        public static final /* enum */ LOCKING_STRATEGY DEFAULT;
        public static final /* enum */ LOCKING_STRATEGY SHARED_LOCK;
        public static final /* enum */ LOCKING_STRATEGY EXCLUSIVE_LOCK;
        @Deprecated
        public static final /* enum */ LOCKING_STRATEGY KEEP_SHARED_LOCK;
        @Deprecated
        public static final /* enum */ LOCKING_STRATEGY KEEP_EXCLUSIVE_LOCK;
        private static final /* synthetic */ LOCKING_STRATEGY[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static LOCKING_STRATEGY[] values() {
            return (LOCKING_STRATEGY[])$VALUES.clone();
        }

        public static LOCKING_STRATEGY valueOf(String name) {
            return Enum.valueOf(LOCKING_STRATEGY.class, name);
        }

        static {
            try {
                try {
                    NONE = new LOCKING_STRATEGY();
                    DEFAULT = new LOCKING_STRATEGY();
                    SHARED_LOCK = new LOCKING_STRATEGY();
                    EXCLUSIVE_LOCK = new LOCKING_STRATEGY();
                    KEEP_SHARED_LOCK = new LOCKING_STRATEGY();
                    KEEP_EXCLUSIVE_LOCK = new LOCKING_STRATEGY();
                    $VALUES = new LOCKING_STRATEGY[]{NONE, DEFAULT, SHARED_LOCK, EXCLUSIVE_LOCK, KEEP_SHARED_LOCK, KEEP_EXCLUSIVE_LOCK};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    public static final class STATUS
    extends Enum<STATUS> {
        public static final /* enum */ STATUS CLOSED;
        public static final /* enum */ STATUS OPEN;
        public static final /* enum */ STATUS CLOSING;
        @Deprecated
        public static final /* enum */ STATUS OPENING;
        private static final /* synthetic */ STATUS[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static STATUS[] values() {
            return (STATUS[])$VALUES.clone();
        }

        public static STATUS valueOf(String name) {
            return Enum.valueOf(STATUS.class, name);
        }

        static {
            try {
                try {
                    CLOSED = new STATUS();
                    OPEN = new STATUS();
                    CLOSING = new STATUS();
                    OPENING = new STATUS();
                    $VALUES = new STATUS[]{CLOSED, OPEN, CLOSING, OPENING};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    public static final class SIZE
    extends Enum<SIZE> {
        public static final /* enum */ SIZE TINY;
        public static final /* enum */ SIZE MEDIUM;
        public static final /* enum */ SIZE LARGE;
        public static final /* enum */ SIZE HUGE;
        private static final /* synthetic */ SIZE[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static SIZE[] values() {
            return (SIZE[])$VALUES.clone();
        }

        public static SIZE valueOf(String name) {
            return Enum.valueOf(SIZE.class, name);
        }

        static {
            try {
                try {
                    TINY = new SIZE();
                    MEDIUM = new SIZE();
                    LARGE = new SIZE();
                    HUGE = new SIZE();
                    $VALUES = new SIZE[]{TINY, MEDIUM, LARGE, HUGE};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

