/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.lock.OReadWriteLock;
import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OStorageAbstract
implements OStorage,
OSharedContainer {
    public static final ThreadGroup storageThreadGroup;
    protected final String url;
    protected final String mode;
    protected final OReadWriteLock stateLock;
    protected volatile OStorageConfiguration configuration;
    protected volatile OCurrentStorageComponentsFactory componentsFactory;
    protected String name;
    protected AtomicLong version = new AtomicLong();
    protected volatile OStorage.STATUS status = OStorage.STATUS.CLOSED;
    protected final OSharedContainerImpl sharedContainer = new OSharedContainerImpl();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OStorageAbstract(String name, String iURL, String mode, OReadWriteLock stateLock) {
        this.name = this.normalizeName(name);
        if (OStringSerializerHelper.contains(this.name, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.url = iURL;
        this.mode = mode;
        this.stateLock = stateLock;
    }

    protected String normalizeName(String name) {
        return OUtils.getDatabaseNameFromURL(name);
    }

    @Override
    public abstract OCluster getClusterByName(String var1);

    @Override
    public OStorage getUnderlying() {
        return this;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isClosed() {
        return this.status == OStorage.STATUS.CLOSED;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ORecordVersionHelper.isTombstone(ppos.recordVersion);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void close() {
        this.close(false, false);
    }

    @Override
    public void close(boolean iForce, boolean onDelete) {
        this.sharedContainer.clearResources();
    }

    @Override
    public boolean existsResource(String iName) {
        return this.sharedContainer.existsResource(iName);
    }

    @Override
    public <T> T removeResource(String iName) {
        return this.sharedContainer.removeResource(iName);
    }

    @Override
    public <T> T getResource(String iName, Callable<T> iCallback) {
        return this.sharedContainer.getResource(iName, iCallback);
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.dropCluster(this.getClusterIdByName(iClusterName), iTruncate);
    }

    @Override
    public long countRecords() {
        long tot = 0L;
        for (OCluster oCluster : this.getClusterInstances()) {
            if (oCluster == null) continue;
            tot += oCluster.getEntries() - oCluster.getTombstonesCount();
        }
        return tot;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        this.stateLock.acquireReadLock();
        try {
            V v = iCallable.call();
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new OStorageException("Error on nested call in lock"), e);
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    @Override
    public OStorage.STATUS getStatus() {
        return this.status;
    }

    @Override
    public void checkForClusterPermissions(String iClusterName) {
        OMetadataInternal metaData = ODatabaseRecordThreadLocal.instance().get().getMetadata();
        if (metaData != null) {
            Set<OClass> classes = metaData.getImmutableSchemaSnapshot().getClassesRelyOnCluster(iClusterName);
            for (OClass c : classes) {
                if (!c.isSubClassOf("ORestricted")) continue;
                throw new OSecurityException("Class '" + c.getName() + "' cannot be truncated because has record level security enabled (extends '" + "ORestricted" + "')");
            }
        }
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isAssigningClusterIds() {
        return true;
    }

    @Override
    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.componentsFactory;
    }

    @Override
    public void shutdown() {
        this.close(true, false);
    }

    static {
        try {
            try {
                ThreadGroup parentThreadGroup;
                ThreadGroup parentThreadGroupBackup = parentThreadGroup = Thread.currentThread().getThreadGroup();
                boolean found = false;
                while (parentThreadGroup.getParent() != null) {
                    if (parentThreadGroup.equals(Orient.instance().getThreadGroup())) {
                        parentThreadGroup = parentThreadGroup.getParent();
                        found = true;
                        break;
                    }
                    parentThreadGroup = parentThreadGroup.getParent();
                }
                if (!found) {
                    parentThreadGroup = parentThreadGroupBackup;
                }
                storageThreadGroup = new ThreadGroup(parentThreadGroup, "OrientDB Storage");
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

