/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;
import java.util.ArrayDeque;
import java.util.Deque;

public class ORecordSerializationContext {
    private static volatile ThreadLocal<Deque<ORecordSerializationContext>> SERIALIZATION_CONTEXT_STACK;
    private final Deque<ORecordSerializationOperation> operations = new ArrayDeque<ORecordSerializationOperation>();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static int getDepth() {
        return SERIALIZATION_CONTEXT_STACK.get().size();
    }

    public static ORecordSerializationContext pushContext() {
        Deque<ORecordSerializationContext> stack = SERIALIZATION_CONTEXT_STACK.get();
        ORecordSerializationContext context = new ORecordSerializationContext();
        stack.push(context);
        return context;
    }

    public static ORecordSerializationContext getContext() {
        Deque<ORecordSerializationContext> stack = SERIALIZATION_CONTEXT_STACK.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public static ORecordSerializationContext pullContext() {
        Deque<ORecordSerializationContext> stack = SERIALIZATION_CONTEXT_STACK.get();
        if (stack.isEmpty()) {
            throw new IllegalStateException("Cannot find current serialization context");
        }
        return stack.poll();
    }

    public void push(ORecordSerializationOperation operation) {
        this.operations.push(operation);
    }

    public void executeOperations(OAbstractPaginatedStorage storage) {
        for (ORecordSerializationOperation operation : this.operations) {
            operation.execute(storage);
        }
    }

    static {
        try {
            try {
                SERIALIZATION_CONTEXT_STACK = new SerializationContextThreadLocal();
                Orient.instance().registerListener(new OOrientListenerAbstract(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void onStartup() {
                        if (SERIALIZATION_CONTEXT_STACK == null) {
                            SERIALIZATION_CONTEXT_STACK = new SerializationContextThreadLocal();
                        }
                    }

                    @Override
                    public void onShutdown() {
                        SERIALIZATION_CONTEXT_STACK = null;
                    }
                });
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private static class SerializationContextThreadLocal
    extends ThreadLocal<Deque<ORecordSerializationContext>> {
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private SerializationContextThreadLocal() {
        }

        @Override
        protected Deque<ORecordSerializationContext> initialValue() {
            return new ArrayDeque<ORecordSerializationContext>();
        }
    }
}

