/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.util;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ODateHelper {
    public static final String DEF_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEF_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static Calendar getDatabaseCalendar() {
        return Calendar.getInstance(ODateHelper.getDatabaseTimeZone());
    }

    public static TimeZone getDatabaseTimeZone() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public static DateFormat getDateFormatInstance() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateFormatInstance();
        }
        return new SimpleDateFormat(DEF_DATE_FORMAT);
    }

    public static String getDateFormat() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateFormat();
        }
        return DEF_DATE_FORMAT;
    }

    public static DateFormat getDateTimeFormatInstance() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateTimeFormatInstance();
        }
        return new SimpleDateFormat(DEF_DATETIME_FORMAT);
    }

    public static String getDateTimeFormat() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateTimeFormat();
        }
        return DEF_DATETIME_FORMAT;
    }

    public static Date now() {
        return ODateHelper.getDatabaseCalendar().getTime();
    }
}

