/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel;

import com.orientechnologies.common.concur.lock.OAdaptiveLock;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocket;

public abstract class OChannel
extends OListenerManger<OChannelListener> {
    private static final OProfiler PROFILER;
    private static final AtomicLong metricGlobalTransmittedBytes;
    private static final AtomicLong metricGlobalReceivedBytes;
    private static final AtomicLong metricGlobalFlushes;
    private final OAdaptiveLock lockRead = new OAdaptiveLock();
    private final OAdaptiveLock lockWrite = new OAdaptiveLock();
    public volatile Socket socket;
    public InputStream inStream;
    public OutputStream outStream;
    public int socketBufferSize;
    protected long timeout;
    private long metricTransmittedBytes = 0L;
    private long metricReceivedBytes = 0L;
    private long metricFlushes = 0L;
    private String profilerMetric;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OChannel(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(true);
        this.socketBufferSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_BUFFER_SIZE);
        this.socket = iSocket;
        this.socket.setTcpNoDelay(true);
        if (this.socketBufferSize > 0) {
            this.socket.setSendBufferSize(this.socketBufferSize);
            this.socket.setReceiveBufferSize(this.socketBufferSize);
        }
    }

    public static String getLocalIpAddress(boolean iFavoriteIp4) throws SocketException {
        String bestAddress = null;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress current_addr = addresses.nextElement();
                if (current_addr.isLoopbackAddress() || bestAddress != null && (!iFavoriteIp4 || !(current_addr instanceof Inet4Address))) continue;
                bestAddress = current_addr.getHostAddress();
            }
        }
        return bestAddress;
    }

    public void acquireWriteLock() {
        this.lockWrite.lock();
    }

    public boolean tryAcquireWriteLock(long iTimeout) {
        return this.lockWrite.tryAcquireLock(iTimeout, TimeUnit.MILLISECONDS);
    }

    public void releaseWriteLock() {
        this.lockWrite.unlock();
    }

    public void acquireReadLock() {
        this.lockRead.lock();
    }

    public void releaseReadLock() {
        this.lockRead.unlock();
    }

    public void flush() throws IOException {
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }

    public OAdaptiveLock getLockRead() {
        return this.lockRead;
    }

    public OAdaptiveLock getLockWrite() {
        return this.lockWrite;
    }

    public synchronized void close() {
        PROFILER.unregisterHookValue(this.profilerMetric + ".transmittedBytes");
        PROFILER.unregisterHookValue(this.profilerMetric + ".receivedBytes");
        PROFILER.unregisterHookValue(this.profilerMetric + ".flushes");
        try {
            if (this.socket != null) {
                if (!(this.socket.isClosed() || this.socket.isInputShutdown() || this.socket instanceof SSLSocket)) {
                    this.socket.shutdownInput();
                }
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error during socket close", e, new Object[0]);
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error during closing of input stream", e, new Object[0]);
        }
        try {
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error during closing of output stream", e, new Object[0]);
        }
        for (OChannelListener l : this.getListenersCopy()) {
            try {
                l.onChannelClose(this);
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error during closing of channel close listener", e, new Object[0]);
            }
        }
        this.lockRead.close();
        this.lockWrite.close();
        this.resetListeners();
    }

    public void connected() {
        String dictProfilerMetric = PROFILER.getProcessMetric("network.channel.binary.*");
        this.profilerMetric = PROFILER.getProcessMetric("network.channel.binary." + this.socket.getRemoteSocketAddress().toString() + ":" + this.socket.getLocalPort() + "".replace('.', '_'));
        PROFILER.registerHookValue(this.profilerMetric + ".transmittedBytes", "Bytes transmitted to a network channel", OProfiler.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object getValue() {
                return OChannel.this.metricTransmittedBytes;
            }
        }, dictProfilerMetric + ".transmittedBytes");
        PROFILER.registerHookValue(this.profilerMetric + ".receivedBytes", "Bytes received from a network channel", OProfiler.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object getValue() {
                return OChannel.this.metricReceivedBytes;
            }
        }, dictProfilerMetric + ".receivedBytes");
        PROFILER.registerHookValue(this.profilerMetric + ".flushes", "Number of times the network channel has been flushed", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object getValue() {
                return OChannel.this.metricFlushes;
            }
        }, dictProfilerMetric + ".flushes");
    }

    public String toString() {
        return this.socket != null ? this.socket.getRemoteSocketAddress().toString() : "Not connected";
    }

    public String getLocalSocketAddress() {
        return this.socket != null ? this.socket.getLocalSocketAddress().toString() : "?";
    }

    protected void updateMetricTransmittedBytes(int iDelta) {
        metricGlobalTransmittedBytes.addAndGet(iDelta);
        this.metricTransmittedBytes += (long)iDelta;
    }

    protected void updateMetricReceivedBytes(int iDelta) {
        metricGlobalReceivedBytes.addAndGet(iDelta);
        this.metricReceivedBytes += (long)iDelta;
    }

    protected void updateMetricFlushes() {
        metricGlobalFlushes.incrementAndGet();
        ++this.metricFlushes;
    }

    static {
        try {
            try {
                PROFILER = Orient.instance().getProfiler();
                metricGlobalTransmittedBytes = new AtomicLong();
                metricGlobalReceivedBytes = new AtomicLong();
                metricGlobalFlushes = new AtomicLong();
                String profilerMetric = PROFILER.getProcessMetric("network.channel.binary");
                PROFILER.registerHookValue(profilerMetric + ".transmittedBytes", "Bytes transmitted to all the network channels", OProfiler.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public Object getValue() {
                        return metricGlobalTransmittedBytes.get();
                    }
                });
                PROFILER.registerHookValue(profilerMetric + ".receivedBytes", "Bytes received from all the network channels", OProfiler.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public Object getValue() {
                        return metricGlobalReceivedBytes.get();
                    }
                });
                PROFILER.registerHookValue(profilerMetric + ".flushes", "Number of times the network channels have been flushed", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public Object getValue() {
                        return metricGlobalFlushes.get();
                    }
                });
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

