/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedMessageService;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public interface ODistributedServerManager {
    public static final String FILE_DISTRIBUTED_DB_CONFIG = "distributed-config.json";

    public boolean isNodeAvailable(String var1);

    public Set<String> getAvailableNodeNames(String var1);

    public void waitUntilNodeOnline() throws InterruptedException;

    public void waitUntilNodeOnline(String var1, String var2) throws InterruptedException;

    public OServer getServerInstance();

    public boolean isEnabled();

    public ODistributedServerManager registerLifecycleListener(ODistributedLifecycleListener var1);

    public ODistributedServerManager unregisterLifecycleListener(ODistributedLifecycleListener var1);

    public Serializable executeOnLocalNode(ODistributedRequestId var1, ORemoteTask var2, ODatabaseDocumentTx var3);

    public ORemoteServerController getRemoteServer(String var1) throws IOException;

    public Map<String, Object> getConfigurationMap();

    public long getLastClusterChangeOn();

    public NODE_STATUS getNodeStatus();

    public void setNodeStatus(NODE_STATUS var1);

    public boolean checkNodeStatus(NODE_STATUS var1);

    public DB_STATUS getDatabaseStatus(String var1, String var2);

    public void setDatabaseStatus(String var1, String var2, DB_STATUS var3);

    public ODistributedMessageService getMessageService();

    public void updateCachedDatabaseConfiguration(String var1, ODocument var2, boolean var3, boolean var4);

    public long getNextMessageIdCounter();

    public void updateLastClusterChange();

    public boolean isNodeAvailable(String var1, String var2);

    public boolean isNodeOnline(String var1, String var2);

    public int getAvailableNodes(String var1);

    public int getAvailableNodes(Collection<String> var1, String var2);

    public boolean isOffline();

    public int getLocalNodeId();

    public String getLocalNodeName();

    public ODocument getClusterConfiguration();

    public String getNodeNameById(int var1);

    public int getNodeIdByName(String var1);

    public ODocument getNodeConfigurationByUuid(String var1);

    public ODocument getLocalNodeConfiguration();

    public void propagateSchemaChanges(ODatabaseInternal var1);

    public Lock getLock(String var1);

    public ODistributedConfiguration getDatabaseConfiguration(String var1);

    public ODistributedResponse sendRequest(String var1, Collection<String> var2, Collection<String> var3, ORemoteTask var4, long var5, ODistributedRequest.EXECUTION_MODE var7, Object var8, OCallable<Void, ODistributedRequestId> var9);

    public ODocument getStats();

    public Throwable convertException(Throwable var1);

    public ORemoteTaskFactory getTaskFactory();

    public static enum DB_STATUS {
        OFFLINE,
        SYNCHRONIZING,
        ONLINE,
        BACKUP;

    }

    public static enum NODE_STATUS {
        OFFLINE,
        STARTING,
        ONLINE,
        SHUTTINGDOWN;

    }
}

