/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODistributedConfiguration {
    public static final String NEW_NODE_TAG = "<NEW_NODE>";
    public static final String ALL_WILDCARD = "*";
    private static final String SERVERS = "servers";
    private static final String DCS = "dataCenters";
    private static final String OWNER = "owner";
    private static final String CLUSTERS = "clusters";
    private static final String VERSION = "version";
    private static final String READ_QUORUM = "readQuorum";
    private static final String WRITE_QUORUM = "writeQuorum";
    public static final String QUORUM_MAJORITY = "majority";
    public static final String QUORUM_ALL = "all";
    public static final String QUORUM_LOCAL_DC = "localDataCenter";
    public static final Integer DEFAULT_READ_QUORUM = 1;
    public static final String DEFAULT_WRITE_QUORUM = "majority";
    private static final String READ_YOUR_WRITES = "readYourWrites";
    private static final String EXECUTION_MODE = "executionMode";
    private static final String EXECUTION_MODE_SYNCHRONOUS = "synchronous";
    private final ODocument configuration;
    private static final List<String> DEFAULT_CLUSTER_NAME = Collections.singletonList("*");

    public ODistributedConfiguration(ODocument iConfiguration) {
        this.configuration = iConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicationActive(String iClusterName, String iLocalNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Collection servers = (Collection)this.getClusterConfiguration(iClusterName).field(SERVERS);
            return servers != null && !servers.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDataCenterConfiguration() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return this.configuration.field(DCS) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isExecutionModeSynchronous(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field(EXECUTION_MODE);
            if (value == null && (value = this.configuration.field(EXECUTION_MODE)) == null) {
                return null;
            }
            if (value.toString().equalsIgnoreCase("undefined")) {
                return null;
            }
            return value.toString().equalsIgnoreCase(EXECUTION_MODE_SYNCHRONOUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isReadYourWrites(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field(READ_YOUR_WRITES);
            if (value == null && (value = this.configuration.field(READ_YOUR_WRITES)) == null) {
                OLogManager.instance().warn((Object)this, "%s setting not found for cluster=%s in distributed-config.json", new Object[]{READ_YOUR_WRITES, iClusterName});
                return true;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<String>> getServerClusterMap(Collection<String> iClusterNames, String iLocalNode, boolean optimizeForLocalOnly) {
        if (iClusterNames == null || iClusterNames.isEmpty()) {
            iClusterNames = DEFAULT_CLUSTER_NAME;
        }
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            HashMap<String, Collection<String>> servers = new HashMap<String, Collection<String>>(iClusterNames.size());
            boolean canUseLocalNode = true;
            for (String string : iClusterNames) {
                List serverList = (List)this.getClusterConfiguration(string).field(SERVERS);
                if (serverList == null || serverList.contains(iLocalNode)) continue;
                canUseLocalNode = false;
                break;
            }
            if (optimizeForLocalOnly && canUseLocalNode) {
                servers.put(iLocalNode, iClusterNames);
                return servers;
            }
            if (iClusterNames.size() == 1) {
                List serverList = (List)this.getClusterConfiguration(iClusterNames.iterator().next()).field(SERVERS);
                for (String s : serverList) {
                    if (NEW_NODE_TAG.equalsIgnoreCase(s)) continue;
                    servers.put(s, iClusterNames);
                }
                return servers;
            }
            final HashMap<String, Collection<String>> serverMap = new HashMap<String, Collection<String>>();
            for (String p : iClusterNames) {
                List serverList = (List)this.getClusterConfiguration(p).field(SERVERS);
                for (String s : serverList) {
                    if (NEW_NODE_TAG.equalsIgnoreCase(s)) continue;
                    HashSet<String> clustersInServer = (HashSet<String>)serverMap.get(s);
                    if (clustersInServer == null) {
                        clustersInServer = new HashSet<String>();
                        serverMap.put(s, clustersInServer);
                    }
                    clustersInServer.add(p);
                }
            }
            if (serverMap.size() == 1) {
                return serverMap;
            }
            if (!optimizeForLocalOnly) {
                return serverMap;
            }
            ArrayList arrayList = new ArrayList(serverMap.keySet());
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.valueOf(((Collection)serverMap.get(o2)).size()).compareTo(((Collection)serverMap.get(o1)).size());
                }
            });
            HashSet<String> remainingClusters = new HashSet<String>(iClusterNames);
            HashSet includedClusters = new HashSet(iClusterNames.size());
            for (String s : arrayList) {
                Collection clusters = (Collection)serverMap.get(s);
                if (!servers.isEmpty()) {
                    clusters.removeAll(includedClusters);
                }
                servers.put(s, clusters);
                remainingClusters.removeAll(clusters);
                includedClusters.addAll(clusters);
                if (!remainingClusters.isEmpty()) continue;
                break;
            }
            return servers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getOwnedClustersByServer(Collection<String> iClusterNames, String iNode) {
        if (iClusterNames == null || iClusterNames.isEmpty()) {
            iClusterNames = DEFAULT_CLUSTER_NAME;
        }
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> notDefinedClusters = new ArrayList<String>(5);
            ArrayList<String> candidates = new ArrayList<String>(5);
            for (String p : iClusterNames) {
                if (p == null) continue;
                String masterServer = this.getClusterOwner(p);
                if (masterServer == null) {
                    notDefinedClusters.add(p);
                    continue;
                }
                if (!iNode.equals(masterServer)) continue;
                candidates.add(p);
            }
            if (!candidates.isEmpty()) {
                return candidates;
            }
            String masterServer = this.getClusterOwner(ALL_WILDCARD);
            if (iNode.equals(masterServer)) {
                return notDefinedClusters;
            }
            return candidates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getServers(Collection<String> iClusterNames) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (iClusterNames == null || iClusterNames.isEmpty()) {
                return this.getAllConfiguredServers();
            }
            HashSet<String> partitions = new HashSet<String>(iClusterNames.size());
            for (String p : iClusterNames) {
                List serverList = (List)this.getClusterConfiguration(p).field(SERVERS);
                if (serverList == null) continue;
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG)) continue;
                    partitions.add(s);
                }
            }
            return partitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerContainingAllClusters(String server, Collection<String> clusters) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (clusters == null || clusters.isEmpty()) {
                clusters = DEFAULT_CLUSTER_NAME;
            }
            for (String cluster : clusters) {
                List serverList = (List)this.getClusterConfiguration(cluster).field(SERVERS);
                if (serverList == null || serverList.contains(server)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerContainingCluster(String server, String cluster) {
        if (cluster == null) {
            cluster = ALL_WILDCARD;
        }
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            List serverList = (List)this.getClusterConfiguration(cluster).field(SERVERS);
            if (serverList != null) {
                return serverList.contains(server);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServers(String iClusterName, String iExclude) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            List serverList = (List)this.getClusterConfiguration(iClusterName).field(SERVERS);
            if (serverList != null) {
                ArrayList<String> filteredServerList = new ArrayList<String>(serverList.size());
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG) || iExclude != null && iExclude.equals(s)) continue;
                    filteredServerList.add(s);
                }
                return filteredServerList;
            }
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllConfiguredServers() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            HashSet<String> servers = new HashSet<String>();
            for (String p : this.getClusterNames()) {
                List serverList = (List)this.getClusterConfiguration(p).field(SERVERS);
                if (serverList == null) continue;
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG)) continue;
                    servers.add(s);
                }
            }
            return servers;
        }
    }

    public Set<String> getClustersOnServer(String iNodeName) {
        HashSet<String> clusters = new HashSet<String>();
        for (String cl : this.getClusterNames()) {
            List<String> servers = this.getServers(cl, null);
            if (!servers.contains(iNodeName)) continue;
            clusters.add(cl);
        }
        return clusters;
    }

    public Set<String> getClustersOwnedByServer(String iNodeName) {
        HashSet<String> clusters = new HashSet<String>();
        for (String cl : this.getClusterNames()) {
            if (!iNodeName.equals(this.getClusterOwner(cl))) continue;
            clusters.add(cl);
        }
        return clusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterOwner(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            String owner;
            ODocument cfg;
            ODocument clusters = this.getConfiguredClusters();
            ODocument oDocument2 = cfg = iClusterName != null ? (ODocument)clusters.field(iClusterName) : null;
            if (cfg != null) {
                owner = (String)cfg.field(OWNER);
                if (owner != null) {
                    return owner;
                }
                List serverList = (List)cfg.field(SERVERS);
                if (serverList != null && !serverList.isEmpty() && NEW_NODE_TAG.equals(owner = (String)serverList.get(0)) && serverList.size() > 1) {
                    owner = (String)serverList.get(1);
                }
            } else {
                return this.getClusterOwner(ALL_WILDCARD);
            }
            return owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfiguredClusterOwner(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            String owner = null;
            ODocument clusters = this.getConfiguredClusters();
            ODocument cfg = (ODocument)clusters.field(iClusterName);
            if (cfg != null) {
                owner = (String)cfg.field(OWNER);
            }
            return owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServers(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Collection list = (Collection)this.getClusterConfiguration(iClusterName).field(SERVERS);
            return list != null ? new ArrayList<String>(list) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClusterNames() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field(CLUSTERS);
            return clusters.fieldNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROLES getDefaultServerRole() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument servers = (ODocument)this.configuration.field(SERVERS);
            if (servers == null) {
                return ROLES.MASTER;
            }
            String role = (String)servers.field(ALL_WILDCARD);
            if (role == null) {
                return ROLES.MASTER;
            }
            return ROLES.valueOf(role.toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROLES getServerRole(String iServerName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument servers = (ODocument)this.configuration.field(SERVERS);
            if (servers == null) {
                return ROLES.MASTER;
            }
            String role = (String)servers.field(iServerName);
            if (role == null && (role = (String)servers.field(ALL_WILDCARD)) == null) {
                return ROLES.MASTER;
            }
            return ROLES.valueOf(role.toUpperCase());
        }
    }

    public ODocument getDocument() {
        return this.configuration.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> addNewNodeInServerList(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> changedPartitions = new ArrayList<String>();
            for (String clusterName : this.getClusterNames()) {
                int newNodePos;
                List partitions = (List)this.getClusterConfiguration(clusterName).field(SERVERS);
                if (partitions == null || (newNodePos = partitions.indexOf(NEW_NODE_TAG)) <= -1 || partitions.contains(iNode)) continue;
                partitions.add(newNodePos, iNode);
                changedPartitions.add(clusterName);
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerOwner(String iClusterName, String iServerName) {
        if (iClusterName == null) {
            throw new IllegalArgumentException("cluster name cannot be null");
        }
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field(CLUSTERS);
            ODocument cluster = (ODocument)clusters.field(iClusterName);
            if (cluster == null) {
                cluster = this.createCluster(iClusterName);
            } else {
                String owner = (String)cluster.field(OWNER);
                if (owner != null && !iServerName.equalsIgnoreCase(owner)) {
                    throw new ODistributedException("Cannot overwrite ownership of cluster '" + iClusterName + "' to the server '" + iServerName + "', because server '" + owner + "' was already configured as owner");
                }
            }
            List<String> serverList = (List<String>)this.getClusterConfiguration(iClusterName).field(SERVERS);
            if (serverList == null) {
                serverList = this.initClusterServers(cluster);
            }
            if (!serverList.isEmpty() && serverList.get(0).equals(iServerName)) {
                return;
            }
            Iterator<String> it = serverList.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(iServerName)) continue;
                it.remove();
                break;
            }
            serverList.add(0, iServerName);
            this.incrementVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> removeServer(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> changedPartitions = new ArrayList<String>();
            block3: for (String clusterName : this.getClusterNames()) {
                Collection nodes = (Collection)this.getClusterConfiguration(clusterName).field(SERVERS);
                if (nodes == null) continue;
                for (String node : nodes) {
                    if (!node.equals(iNode)) continue;
                    nodes.remove(node);
                    changedPartitions.add(clusterName);
                    continue block3;
                }
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDataCenters() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument dcs = (ODocument)this.configuration.field(DCS);
            if (dcs == null) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> result = new HashSet<String>();
            for (String dc : dcs.fieldNames()) {
                result.add(dc);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataCenterWriteQuorum(String dataCenter) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument dc = this.getDataCenterConfiguration(dataCenter);
            Object wq = dc.field(WRITE_QUORUM);
            if (wq instanceof String) {
                if (wq.toString().equalsIgnoreCase("majority")) {
                    List servers = (List)dc.field(SERVERS);
                    wq = servers.size() / 2 + 1;
                } else if (wq.toString().equalsIgnoreCase(QUORUM_ALL)) {
                    List servers = (List)dc.field(SERVERS);
                    wq = servers.size();
                }
            }
            return (Integer)wq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharded() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            List allServers;
            ODocument allCluster = this.getClusterConfiguration(ALL_WILDCARD);
            if (allCluster != null && (allServers = (List)allCluster.field(SERVERS)) != null && !allServers.isEmpty()) {
                for (String cl : this.getClusterNames()) {
                    List<String> servers = this.getServers(cl);
                    if (servers == null || servers.isEmpty() || allServers.containsAll(servers)) continue;
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataCenterServers(String dataCenter) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument dc = this.getDataCenterConfiguration(dataCenter);
            List servers = (List)dc.field(SERVERS);
            if (servers == null || servers.isEmpty()) {
                throw new OConfigurationException("Data center '" + dataCenter + "' does not contain any server in distributed database configuration");
            }
            return new ArrayList<String>(servers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataCenterOfServer(String server) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument dcs = (ODocument)this.configuration.field(DCS);
            if (dcs != null) {
                for (String dc : dcs.fieldNames()) {
                    List dcServers;
                    ODocument dcConfig = (ODocument)dcs.field(dc);
                    if (dcConfig == null || (dcServers = (List)dcConfig.field(SERVERS)) == null || dcServers.isEmpty() || !dcServers.contains(server)) continue;
                    return dc;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> setServerOffline(String iNode, String newServerCoordinator) {
        ArrayList<String> changedPartitions = new ArrayList<String>();
        String[] clusters = this.getClusterNames();
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            block3: for (String clusterName : clusters) {
                List nodes = (List)this.getClusterConfiguration(clusterName).field(SERVERS);
                if (nodes == null || nodes.size() <= 1) continue;
                for (String node : nodes) {
                    if (!node.equals(iNode)) continue;
                    nodes.remove(node);
                    boolean newNodeRemoved = nodes.remove(NEW_NODE_TAG);
                    nodes.add(node);
                    if (newNodeRemoved) {
                        nodes.add(NEW_NODE_TAG);
                    }
                    if (newServerCoordinator != null && nodes.remove(newServerCoordinator)) {
                        nodes.add(0, newServerCoordinator);
                    }
                    changedPartitions.add(clusterName);
                    continue block3;
                }
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    public int getVersion() {
        Integer v = (Integer)this.configuration.field(VERSION);
        if (v == null) {
            return 0;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalDataCenterWriteQuorum() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return QUORUM_LOCAL_DC.equals(this.configuration.field(WRITE_QUORUM));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGlobalReadQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field(READ_QUORUM);
            if (value == null) {
                value = this.configuration.field(READ_QUORUM);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadQuorum(String clusterName, int availableNodes, String server) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return this.getQuorum(READ_QUORUM, clusterName, availableNodes, DEFAULT_READ_QUORUM, server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteQuorum(String clusterName, int availableNodes, String server) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return this.getQuorum(WRITE_QUORUM, clusterName, availableNodes, "majority", server);
        }
    }

    private ODocument getConfiguredClusters() {
        ODocument clusters = (ODocument)this.configuration.field(CLUSTERS);
        if (clusters == null) {
            throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
        }
        return clusters;
    }

    private ODocument getClusterConfiguration(String iClusterName) {
        ODocument cfg;
        ODocument clusters = this.getConfiguredClusters();
        if (iClusterName == null) {
            iClusterName = ALL_WILDCARD;
        }
        if ((cfg = !clusters.containsField(iClusterName) ? (ODocument)clusters.field(ALL_WILDCARD) : (ODocument)clusters.field(iClusterName)) == null) {
            return new ODocument();
        }
        return cfg;
    }

    private ODocument getDataCenterConfiguration(String dataCenter) {
        ODocument dcs = (ODocument)this.configuration.field(DCS);
        if (dcs != null) {
            return (ODocument)dcs.field(dataCenter);
        }
        throw new OConfigurationException("Cannot find the data center '" + dataCenter + "' in distributed database configuration");
    }

    private int getQuorum(String quorumSetting, String iClusterName, int iAvailableNodes, Object defaultValue, String server) {
        Object value = this.getClusterConfiguration(iClusterName).field(quorumSetting);
        if (value == null && (value = this.configuration.field(quorumSetting)) == null) {
            OLogManager.instance().warn((Object)this, "%s setting not found for cluster=%s in distributed-config.json", new Object[]{quorumSetting, iClusterName});
            value = defaultValue;
        }
        if (value instanceof String) {
            if (value.toString().equalsIgnoreCase("majority")) {
                value = iAvailableNodes / 2 + 1;
            } else if (value.toString().equalsIgnoreCase(QUORUM_ALL)) {
                value = iAvailableNodes;
            } else if (value.toString().equalsIgnoreCase(QUORUM_LOCAL_DC)) {
                String dc = this.getDataCenterOfServer(server);
                if (dc == null) {
                    throw new OConfigurationException("Data center not specified for server '" + server + "' in distributed configuration");
                }
                value = this.getDataCenterWriteQuorum(dc);
            } else {
                throw new OConfigurationException("The value '" + value + "' is not supported for " + quorumSetting + " in distributed configuration");
            }
        }
        return (Integer)value;
    }

    private void incrementVersion() {
        Integer oldVersion = (Integer)this.configuration.field(VERSION);
        if (oldVersion == null) {
            oldVersion = 0;
        }
        this.configuration.field(VERSION, (Object)(oldVersion + 1));
    }

    private List<String> initClusterServers(ODocument cluster) {
        ODocument any = this.getClusterConfiguration(ALL_WILDCARD);
        List anyServers = (List)any.field(SERVERS);
        ArrayList<String> servers = new ArrayList<String>(anyServers);
        cluster.field(SERVERS, servers);
        return servers;
    }

    private ODocument createCluster(String iClusterName) {
        ODocument clusters = (ODocument)this.configuration.field(CLUSTERS);
        ODocument cluster = (ODocument)clusters.field(iClusterName);
        if (cluster != null) {
            return clusters;
        }
        cluster = new ODocument();
        ODocumentInternal.addOwner((ODocument)cluster, (ORecordElement)clusters);
        clusters.field(iClusterName, (Object)cluster, new OType[]{OType.EMBEDDED});
        List<String> servers = this.initClusterServers(cluster);
        return cluster;
    }

    public static enum ROLES {
        MASTER,
        REPLICA;

    }
}

