/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ODistributedResponseManager {
    public static final int ADDITIONAL_TIMEOUT_CLUSTER_SHAPE = 10000;
    private static final String NO_RESPONSE = "waiting-for-response";
    private final ODistributedServerManager dManager;
    private final ODistributedRequest request;
    private final long sentOn;
    private final Set<String> nodesConcurInQuorum;
    private final HashMap<String, Object> responses = new HashMap();
    private final boolean groupResponsesByResult;
    private final List<List<ODistributedResponse>> responseGroups = new ArrayList<List<ODistributedResponse>>();
    private int totalExpectedResponses;
    private final long synchTimeout;
    private final long totalTimeout;
    private final Lock synchronousResponsesLock = new ReentrantLock();
    private final Condition synchronousResponsesArrived = this.synchronousResponsesLock.newCondition();
    private final int quorum;
    private final boolean waitForLocalNode;
    private ODistributedResponse localResponse;
    private volatile int receivedResponses = 0;
    private volatile boolean receivedCurrentNode;

    public ODistributedResponseManager(ODistributedServerManager iManager, ODistributedRequest iRequest, Collection<String> expectedResponses, Set<String> iNodesConcurInQuorum, int iTotalExpectedResponses, int iQuorum, boolean iWaitForLocalNode, long iSynchTimeout, long iTotalTimeout, boolean iGroupResponsesByResult) {
        this.dManager = iManager;
        this.request = iRequest;
        this.sentOn = System.nanoTime();
        this.totalExpectedResponses = iTotalExpectedResponses;
        this.quorum = iQuorum;
        this.waitForLocalNode = iWaitForLocalNode;
        this.synchTimeout = iSynchTimeout;
        this.totalTimeout = iTotalTimeout;
        this.groupResponsesByResult = iGroupResponsesByResult;
        this.nodesConcurInQuorum = iNodesConcurInQuorum;
        for (String node : expectedResponses) {
            this.responses.put(node, NO_RESPONSE);
        }
        if (this.groupResponsesByResult) {
            this.responseGroups.add(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectResponse(ODistributedResponse response) {
        String executorNode = response.getExecutorNodeName();
        String senderNode = response.getSenderNodeName();
        this.synchronousResponsesLock.lock();
        try {
            boolean completed;
            if (!executorNode.equals(this.dManager.getLocalNodeName()) && !this.responses.containsKey(executorNode)) {
                ODistributedServerLog.warn((Object)this, senderNode, executorNode, ODistributedServerLog.DIRECTION.IN, "Received response for request (%s) from unexpected node. Expected are: %s", this.request, this.getExpectedNodes());
                Orient.instance().getProfiler().updateCounter("distributed.node.unexpectedNodeResponse", "Number of responses from unexpected nodes", 1L);
                boolean bl = false;
                return bl;
            }
            this.dManager.getMessageService().updateLatency(executorNode, this.sentOn);
            this.responses.put(executorNode, response);
            ++this.receivedResponses;
            if (this.waitForLocalNode && executorNode.equals(senderNode)) {
                this.receivedCurrentNode = true;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, senderNode, executorNode, ODistributedServerLog.DIRECTION.IN, "Received response '%s' for request (%s) (receivedCurrentNode=%s receivedResponses=%d totalExpectedResponses=%d quorum=%d)", response, this.request, this.receivedCurrentNode, this.receivedResponses, this.totalExpectedResponses, this.quorum);
            }
            if (this.groupResponsesByResult) {
                Object responsePayload = response.getPayload();
                boolean foundBucket = false;
                for (int i = 0; i < this.responseGroups.size(); ++i) {
                    List<ODistributedResponse> responseGroup = this.responseGroups.get(i);
                    if (responseGroup.isEmpty()) {
                        foundBucket = true;
                    } else {
                        Object rgPayload = responseGroup.get(0).getPayload();
                        if (rgPayload == null && responsePayload == null) {
                            foundBucket = true;
                        } else if (rgPayload != null) {
                            if (rgPayload instanceof ODocument && responsePayload instanceof ODocument && !((ODocument)rgPayload).getIdentity().isValid() && ((ODocument)rgPayload).hasSameContentOf((ODocument)responsePayload)) {
                                foundBucket = true;
                            } else if (rgPayload.equals(responsePayload)) {
                                foundBucket = true;
                            } else if (rgPayload instanceof Collection && responsePayload instanceof Collection && OMultiValue.equals((Collection)((Collection)rgPayload), (Collection)((Collection)responsePayload))) {
                                foundBucket = true;
                            }
                        }
                    }
                    if (!foundBucket) continue;
                    responseGroup.add(response);
                    break;
                }
                if (!foundBucket) {
                    ArrayList<ODistributedResponse> newBucket = new ArrayList<ODistributedResponse>();
                    this.responseGroups.add(newBucket);
                    newBucket.add(response);
                }
            }
            boolean bl = completed = this.getExpectedResponses() == this.receivedResponses;
            if (completed || this.isMinimumQuorumReached()) {
                this.notifyWaiters();
            }
            boolean bl2 = completed;
            return bl2;
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public void notifyWaiters() {
        this.synchronousResponsesLock.lock();
        try {
            this.synchronousResponsesArrived.signalAll();
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public ODistributedRequestId getMessageId() {
        return this.request.getId();
    }

    public long getSentOn() {
        return this.sentOn;
    }

    public void setLocalResult(String localNodeName, Object localResult) {
        this.synchronousResponsesLock.lock();
        try {
            this.localResponse = new ODistributedResponse(this.request.getId(), localNodeName, localNodeName, localResult);
            this.collectResponse(this.localResponse);
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public void removeServerBecauseUnreachable(String node) {
        this.synchronousResponsesLock.lock();
        try {
            if (this.responses.remove(node) != null) {
                --this.totalExpectedResponses;
                this.nodesConcurInQuorum.remove(node);
            }
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public int getQuorum() {
        return this.quorum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSynchronousResponses() throws InterruptedException {
        long beginTime = System.currentTimeMillis();
        this.synchronousResponsesLock.lock();
        try {
            long currentTimeout = this.synchTimeout;
            while (currentTimeout > 0L && this.receivedResponses < this.totalExpectedResponses && !this.isMinimumQuorumReached()) {
                if (currentTimeout > 10000L) {
                    currentTimeout = 10000L;
                }
                this.synchronousResponsesArrived.await(currentTimeout, TimeUnit.MILLISECONDS);
                if (this.isMinimumQuorumReached() || this.receivedResponses >= this.totalExpectedResponses) {
                    boolean bl = true;
                    return bl;
                }
                if (Thread.currentThread().isInterrupted()) {
                    ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Thread has been interrupted wait for request (%s)", this.request);
                    Thread.currentThread().interrupt();
                    break;
                }
                long now = System.currentTimeMillis();
                long elapsed = now - beginTime;
                currentTimeout = this.synchTimeout - elapsed;
                int synchronizingNodes = 0;
                int missingActiveNodes = 0;
                for (Map.Entry<String, Object> curr : this.responses.entrySet()) {
                    if (curr.getValue() != NO_RESPONSE) continue;
                    ODistributedServerManager.DB_STATUS dbStatus = this.dManager.getDatabaseStatus(curr.getKey(), this.getDatabaseName());
                    switch (dbStatus) {
                        case BACKUP: 
                        case SYNCHRONIZING: {
                            ++synchronizingNodes;
                            ++missingActiveNodes;
                            break;
                        }
                        case ONLINE: {
                            ++missingActiveNodes;
                        }
                    }
                }
                if (missingActiveNodes == 0) {
                    ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "No more active nodes to wait for request (%s): anticipate timeout (saved %d ms)", this.request, currentTimeout);
                    break;
                }
                long lastClusterChange = this.dManager.getLastClusterChangeOn();
                if (lastClusterChange > 0L && now - lastClusterChange < this.synchTimeout + 10000L) {
                    currentTimeout = this.synchTimeout;
                    ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Cluster shape changed during request (%s): enlarge timeout +%dms, wait again for %dms", this.request, this.synchTimeout, currentTimeout);
                    continue;
                }
                if (synchronizingNodes <= 0) continue;
            }
            boolean bl = this.isMinimumQuorumReached() || this.receivedResponses >= this.totalExpectedResponses;
            return bl;
        }
        finally {
            this.synchronousResponsesLock.unlock();
            Orient.instance().getProfiler().stopChrono("distributed.synchResponses", "Time to collect all the synchronous responses from distributed nodes", beginTime);
        }
    }

    public boolean isWaitForLocalNode() {
        return this.waitForLocalNode;
    }

    public boolean isReceivedCurrentNode() {
        return this.receivedCurrentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedResponse getFinalResponse() {
        this.synchronousResponsesLock.lock();
        try {
            RuntimeException failure = this.manageConflicts();
            if (failure != null) {
                ODistributedResponse oDistributedResponse = new ODistributedResponse(this.request.getId(), this.dManager.getLocalNodeName(), this.dManager.getLocalNodeName(), failure);
                return oDistributedResponse;
            }
            if (this.receivedResponses == 0) {
                if (this.quorum > 0 && !this.request.getTask().isIdempotent()) {
                    throw new ODistributedOperationException("No response received from any of nodes " + this.getExpectedNodes() + " for request " + this.request + " after " + (System.nanoTime() - this.sentOn) / 1000000L + "ms");
                }
                ODistributedResponse oDistributedResponse = null;
                return oDistributedResponse;
            }
            switch (this.request.getTask().getResultStrategy()) {
                case ANY: {
                    break;
                }
                case UNION: {
                    HashMap<String, Object> payloads = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                        if (entry.getValue() == NO_RESPONSE) continue;
                        payloads.put(entry.getKey(), ((ODistributedResponse)entry.getValue()).getPayload());
                    }
                    if (payloads.isEmpty()) {
                        Iterator<Map.Entry<String, Object>> iterator = null;
                        return iterator;
                    }
                    ODistributedResponse response = this.getReceivedResponses().iterator().next();
                    response.setExecutorNodeName(this.responses.keySet().toString());
                    response.setPayload(payloads);
                    ODistributedResponse oDistributedResponse = response;
                    return oDistributedResponse;
                }
            }
            int bestResponsesGroupIndex = this.getBestResponsesGroup();
            List<ODistributedResponse> bestResponsesGroup = this.responseGroups.get(bestResponsesGroupIndex);
            ODistributedResponse oDistributedResponse = bestResponsesGroup.get(0);
            return oDistributedResponse;
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public String getDatabaseName() {
        return this.request.getDatabaseName();
    }

    public long getSynchTimeout() {
        return this.synchTimeout;
    }

    public void timeout() {
        this.synchronousResponsesLock.lock();
        try {
            this.manageConflicts();
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMissingNodes() {
        this.synchronousResponsesLock.lock();
        try {
            ArrayList<String> missingNodes = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                if (entry.getValue() != NO_RESPONSE) continue;
                missingNodes.add(entry.getKey());
            }
            ArrayList<String> arrayList = missingNodes;
            return arrayList;
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public Set<String> getExpectedNodes() {
        this.synchronousResponsesLock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.responses.keySet());
            return hashSet;
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRespondingNodes() {
        ArrayList<String> respondedNodes = new ArrayList<String>();
        this.synchronousResponsesLock.lock();
        try {
            for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                if (entry.getValue() == NO_RESPONSE) continue;
                respondedNodes.add(entry.getKey());
            }
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
        return respondedNodes;
    }

    protected List<ODistributedResponse> getConflictResponses() {
        ArrayList<ODistributedResponse> servers = new ArrayList<ODistributedResponse>();
        int bestGroupSoFar = this.getBestResponsesGroup();
        for (int i = 0; i < this.responseGroups.size(); ++i) {
            if (i == bestGroupSoFar) continue;
            for (ODistributedResponse r : this.responseGroups.get(i)) {
                servers.add(r);
            }
        }
        return servers;
    }

    protected int getExpectedResponses() {
        return this.responses.size();
    }

    protected int getMissingResponses() {
        return this.getExpectedResponses() - this.receivedResponses;
    }

    protected int getReceivedResponsesCount() {
        return this.receivedResponses;
    }

    protected long getTotalTimeout() {
        return this.totalTimeout;
    }

    protected int getBestResponsesGroup() {
        int maxCoherentResponses = 0;
        int bestGroupSoFar = 0;
        for (int i = 0; i < this.responseGroups.size(); ++i) {
            int currentGroupSize = this.responseGroups.get(i).size();
            if (currentGroupSize <= maxCoherentResponses) continue;
            maxCoherentResponses = currentGroupSize;
            bestGroupSoFar = i;
        }
        return bestGroupSoFar;
    }

    protected boolean isMinimumQuorumReached() {
        if (this.isWaitForLocalNode() && !this.isReceivedCurrentNode()) {
            return false;
        }
        if (this.quorum == 0) {
            return true;
        }
        if (this.groupResponsesByResult) {
            for (List<ODistributedResponse> group : this.responseGroups) {
                if (group.size() < this.quorum) continue;
                int responsesForQuorum = 0;
                for (ODistributedResponse r : group) {
                    if (!this.nodesConcurInQuorum.contains(r.getExecutorNodeName())) continue;
                    Object payload = r.getPayload();
                    if (payload instanceof Throwable) {
                        if (payload instanceof ODistributedRecordLockedException) {
                            return false;
                        }
                        if (!(payload instanceof OConcurrentCreateException)) continue;
                        return false;
                    }
                    if (++responsesForQuorum < this.quorum) continue;
                    break;
                }
                return responsesForQuorum >= this.quorum;
            }
            if (this.responseGroups.size() == 1 && OGlobalConfiguration.DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS.getValueAsLong() == 0L) {
                List<String> missingNodes = this.getMissingNodes();
                int expectingNodes = missingNodes.size();
                this.dManager.getAvailableNodes(missingNodes, this.getDatabaseName());
                int unreacheableServersDuringRequest = expectingNodes - missingNodes.size();
                if (this.responseGroups.get(0).size() + unreacheableServersDuringRequest >= this.quorum) {
                    ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "%d server(s) became unreachable during the request, decreasing the quorum (%d) and accept the request: %s", unreacheableServersDuringRequest, this.quorum, this.request);
                    return true;
                }
            }
        } else {
            if (this.receivedResponses >= this.quorum) {
                int responsesForQuorum = 0;
                for (Map.Entry<String, Object> response : this.responses.entrySet()) {
                    if (response.getValue() != NO_RESPONSE && this.nodesConcurInQuorum.contains(response.getKey()) && ++responsesForQuorum >= this.quorum) break;
                }
                return responsesForQuorum >= this.quorum;
            }
            return this.receivedResponses >= this.quorum;
        }
        return false;
    }

    protected List<ODistributedResponse> getReceivedResponses() {
        ArrayList<ODistributedResponse> parsed = new ArrayList<ODistributedResponse>();
        for (Object r : this.responses.values()) {
            if (r == NO_RESPONSE) continue;
            parsed.add((ODistributedResponse)r);
        }
        return parsed;
    }

    protected RuntimeException manageConflicts() {
        Object goodResponsePayload;
        if (!this.groupResponsesByResult || this.request.getTask().getQuorumType() == OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE) {
            return null;
        }
        if (this.dManager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return null;
        }
        int bestResponsesGroupIndex = this.getBestResponsesGroup();
        List<ODistributedResponse> bestResponsesGroup = this.responseGroups.get(bestResponsesGroupIndex);
        int maxCoherentResponses = bestResponsesGroup.size();
        int conflicts = this.getExpectedResponses() - maxCoherentResponses;
        if (this.isMinimumQuorumReached()) {
            if (this.responseGroups.size() == 1) {
                return null;
            }
            if (this.checkNoWinnerCase(bestResponsesGroup)) {
                return null;
            }
            if (this.fixNodesInConflict(bestResponsesGroup, conflicts)) {
                return null;
            }
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Detected %d node(s) in timeout or in conflict and quorum (%d) has not been reached, rolling back changes for request (%s)", conflicts, this.quorum, this.request);
            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, this.composeConflictMessage(), new Object[0]);
        }
        if (!this.undoRequest()) {
            return null;
        }
        for (Object r : this.responses.values()) {
            if (r instanceof ODistributedRecordLockedException) {
                throw (ODistributedRecordLockedException)((Object)r);
            }
            if (!(r instanceof OConcurrentCreateException)) continue;
            throw (OConcurrentCreateException)r;
        }
        Object object = goodResponsePayload = bestResponsesGroup.isEmpty() ? null : bestResponsesGroup.get(0).getPayload();
        if (goodResponsePayload instanceof RuntimeException) {
            return (RuntimeException)goodResponsePayload;
        }
        if (goodResponsePayload instanceof Throwable) {
            return OException.wrapException((OException)((Object)new ODistributedException(this.composeConflictMessage())), (Throwable)((Throwable)goodResponsePayload));
        }
        if (this.responseGroups.size() <= 2) {
            for (int i = 0; i < this.responseGroups.size(); ++i) {
                List<ODistributedResponse> badResponses;
                if (i == bestResponsesGroupIndex || !((badResponses = this.responseGroups.get(i)).get(0).getPayload() instanceof RuntimeException)) continue;
                return (RuntimeException)badResponses.get(0).getPayload();
            }
        }
        return new ODistributedOperationException(this.composeConflictMessage());
    }

    private String composeConflictMessage() {
        StringBuilder msg = new StringBuilder(256);
        msg.append("Quorum " + this.getQuorum() + " not reached for request (" + this.request + "). Elapsed=" + (System.nanoTime() - this.getSentOn()) / 1000000L + "ms");
        List<ODistributedResponse> res = this.getConflictResponses();
        if (res.isEmpty()) {
            msg.append(" No server in conflict. ");
        } else {
            msg.append(" Servers in timeout/conflict are:");
            for (ODistributedResponse oDistributedResponse : res) {
                msg.append("\n - ");
                msg.append(oDistributedResponse.getExecutorNodeName());
                msg.append(": ");
                msg.append(oDistributedResponse.getPayload());
            }
            msg.append("\n");
        }
        msg.append("Received: ");
        for (Map.Entry entry : this.responses.entrySet()) {
            msg.append("\n - ");
            msg.append((String)entry.getKey());
            msg.append(": ");
            msg.append(entry.getValue());
        }
        return msg.toString();
    }

    protected boolean undoRequest() {
        ORemoteTask task = this.request.getTask();
        if (task.isIdempotent()) {
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "No undo because the task (%s) is idempotent", task);
            return false;
        }
        for (ODistributedResponse r : this.getReceivedResponses()) {
            ORemoteTask undoTask;
            String targetNode;
            if (r.getPayload() instanceof Throwable || r == this.localResponse || (targetNode = r.getExecutorNodeName()).equals(this.dManager.getLocalNodeName()) || !(task instanceof OAbstractReplicatedTask) || (undoTask = ((OAbstractReplicatedTask)task).getUndoTask(this.request.getId())) == null) continue;
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), targetNode, ODistributedServerLog.DIRECTION.OUT, "Sending undo message (%s) for request (%s) to server %s", undoTask, this.request, targetNode);
            ODistributedResponse result = this.dManager.sendRequest(this.request.getDatabaseName(), null, OMultiValue.getSingletonList((Object)targetNode), undoTask, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), targetNode, ODistributedServerLog.DIRECTION.OUT, "Received response from undo message (%s) for request (%s) to server %s: result", undoTask, this.request, targetNode, result);
        }
        return true;
    }

    protected boolean fixNodesInConflict(List<ODistributedResponse> bestResponsesGroup, int conflicts) {
        ODistributedResponse goodResponse = bestResponsesGroup.get(0);
        if (goodResponse.getPayload() instanceof Throwable) {
            return false;
        }
        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Detected %d conflicts, but the quorum (%d) has been reached. Fixing remote records. Request (%s)", conflicts, this.quorum, this.request);
        for (List<ODistributedResponse> responseGroup : this.responseGroups) {
            if (responseGroup == bestResponsesGroup) continue;
            for (ODistributedResponse r : responseGroup) {
                if (r.getPayload() instanceof ODistributedRecordLockedException) {
                    return false;
                }
                ORemoteTask fixTask = ((OAbstractReplicatedTask)this.request.getTask()).getFixTask(this.request, this.request.getTask(), r.getPayload(), goodResponse.getPayload(), r.getExecutorNodeName(), this.dManager);
                if (fixTask == null) {
                    return false;
                }
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), r.getExecutorNodeName(), ODistributedServerLog.DIRECTION.OUT, "Sending fix message (%s) for response (%s) on request (%s) to be: %s", fixTask, r, this.request, goodResponse);
                this.dManager.sendRequest(this.request.getDatabaseName(), null, OMultiValue.getSingletonList((Object)r.getExecutorNodeName()), fixTask, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, null, null);
            }
        }
        return true;
    }

    protected boolean checkNoWinnerCase(List<ODistributedResponse> bestResponsesGroup) {
        int maxCoherentResponses = bestResponsesGroup.size();
        if (maxCoherentResponses < this.quorum) {
            return false;
        }
        for (List<ODistributedResponse> responseGroup : this.responseGroups) {
            if (responseGroup == bestResponsesGroup || responseGroup.size() != maxCoherentResponses) continue;
            ArrayList<String> a = new ArrayList<String>();
            Object aResponse = null;
            for (ODistributedResponse r : bestResponsesGroup) {
                a.add(r.getExecutorNodeName());
                aResponse = r.getPayload();
            }
            ArrayList<String> b = new ArrayList<String>();
            Object bResponse = null;
            for (ODistributedResponse r : responseGroup) {
                b.add(r.getExecutorNodeName());
                bResponse = r.getPayload();
            }
            StringBuilder details = new StringBuilder();
            details.append(" A=").append(aResponse);
            details.append(", B=").append(bResponse);
            ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Detected possible split brain network where 2 groups of servers A%s and B%s have different contents. Cannot decide who is the winner even if the quorum (%d) has been reached. Request (%s) responses:%s", a, b, this.quorum, this.request, details);
            return true;
        }
        return false;
    }
}

