/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.HashMap;
import java.util.List;

public class OServerCommandGetQuery
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|query/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: query/<database>/sql/<query-text>[/<limit>][/<fetchPlan>].<br>Limit is optional and is set to 20 by default. Set to 0 to have no limits.");
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4]) : 20;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        String text = urlParts[3];
        String accept = iRequest.getHeader("accept");
        iRequest.data.commandInfo = "Query";
        iRequest.data.commandDetail = text;
        ODatabaseDocumentInternal db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OQueryAbstract command = new OSQLSynchQuery(text, limit).setFetchPlan(fetchPlan);
            command.setCacheableResult(true);
            List response = db.query((OQuery)command, new Object[0]);
            fetchPlan = command.getFetchPlan();
            HashMap<String, Object> additionalContent = null;
            List tips = (List)command.getContext().getVariable("tips");
            if (tips != null) {
                additionalContent = new HashMap<String, Object>(1);
                additionalContent.put("warnings", tips);
            }
            iResponse.writeRecords(response, fetchPlan, null, accept, additionalContent);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

