/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.OMajorityDistributedConflictResolver;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ODCDistributedConflictResolver
extends OMajorityDistributedConflictResolver {
    public static final String NAME = "dc";

    @Override
    public ODistributedConflictResolver.OConflictResult onConflict(String databaseName, String clusterName, ORecordId rid, ODistributedServerManager dManager, Map<Object, List<String>> candidates, ODocument config) {
        ODistributedConfiguration dCfg = dManager.getDatabaseConfiguration(databaseName);
        String winnerDC = (String)config.field("winner");
        for (Map.Entry<Object, List<String>> entry : candidates.entrySet()) {
            List<String> servers = entry.getValue();
            Iterator<String> it = servers.iterator();
            while (it.hasNext()) {
                String server = it.next();
                if (winnerDC.equals(dCfg.getDataCenterOfServer(server))) continue;
                it.remove();
            }
        }
        return super.onConflict(databaseName, clusterName, rid, dManager, candidates, config);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

