/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OAbstractDistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OMajorityDistributedConflictResolver
extends OAbstractDistributedConflictResolver {
    public static final String NAME = "majority";

    @Override
    public ODistributedConflictResolver.OConflictResult onConflict(String databaseName, String clusterName, ORecordId rid, ODistributedServerManager dManager, Map<Object, List<String>> candidates, ODocument config) {
        ODistributedConflictResolver.OConflictResult result = new ODistributedConflictResolver.OConflictResult();
        Object bestResult = this.getBestResult(candidates, null);
        if (bestResult == NOT_FOUND) {
            return result;
        }
        ODistributedConfiguration dCfg = dManager.getDatabaseConfiguration(databaseName);
        int writeQuorum = dCfg.getWriteQuorum(clusterName, dManager.getAvailableNodes(databaseName), dManager.getLocalNodeName());
        int bestResultServerCount = candidates.get(bestResult).size();
        if (bestResultServerCount >= writeQuorum) {
            OLogManager.instance().debug((Object)this, "Majority Conflict Resolver decided the value '%s' is the winner for record %s, because satisfies the configured writeQuorum (%d). Servers ok=%s", new Object[]{bestResult, rid, writeQuorum, candidates.get(result.winner)});
            result.winner = bestResult;
        } else {
            ArrayList<Object> exclude = new ArrayList<Object>();
            exclude.add(bestResult);
            Object secondBestResult = this.getBestResult(candidates, exclude);
            if (secondBestResult != NOT_FOUND && bestResultServerCount > candidates.get(secondBestResult).size()) {
                result.winner = bestResult;
                OLogManager.instance().debug((Object)this, "Majority Conflict Resolver decided the value '%s' is the winner for the record %s because it is the majority even if under the configured writeQuorum (%d). Servers ok=%s", new Object[]{bestResult, rid, writeQuorum, candidates.get(result.winner)});
            } else {
                OLogManager.instance().debug((Object)this, "Majority Conflict Resolver could not find a winner for the record %s (candidates=%s)", new Object[]{rid, candidates});
                result.candidates.put(bestResult, candidates.get(bestResult));
                result.candidates.put(secondBestResult, candidates.get(secondBestResult));
                exclude.add(secondBestResult);
                Object lastBestResult = this.getBestResult(candidates, exclude);
                int resultCount = candidates.get(secondBestResult).size();
                while (lastBestResult != NOT_FOUND && resultCount == bestResultServerCount && exclude.size() < candidates.size()) {
                    result.candidates.put(lastBestResult, candidates.get(lastBestResult));
                    exclude.add(lastBestResult);
                    lastBestResult = this.getBestResult(candidates, exclude);
                    if (lastBestResult == NOT_FOUND) break;
                    resultCount = candidates.get(lastBestResult).size();
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

