/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandGetDictionary
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|dictionary/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        iRequest.data.commandInfo = "Dictionary lookup";
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: dictionary/<database>/<key>");
        ODatabaseDocumentInternal db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            ORecord record = (ORecord)db.getDictionary().get(urlParts[2]);
            if (record == null) {
                throw new ORecordNotFoundException(null, "Key '" + urlParts[2] + "' was not found in the database dictionary");
            }
            iResponse.writeRecord(record);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

