/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest.workload;

import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.ODatabaseUtils;
import com.orientechnologies.orient.stresstest.workload.OBaseWorkload;

public abstract class OBaseDocumentWorkload
extends OBaseWorkload {
    @Override
    protected OBaseWorkload.OBaseWorkLoadContext getContext() {
        return new OWorkLoadContext();
    }

    protected ODatabase getDocumentDatabase(ODatabaseIdentifier databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY connectionStrategy) {
        ODatabase database = ODatabaseUtils.openDatabase(databaseIdentifier, connectionStrategy);
        if (database == null) {
            throw new IllegalArgumentException("Error on opening database " + databaseIdentifier.getName());
        }
        return database;
    }

    @Override
    protected void beginTransaction(OBaseWorkload.OBaseWorkLoadContext context) {
        ((OWorkLoadContext)context).db.begin();
    }

    @Override
    protected void commitTransaction(OBaseWorkload.OBaseWorkLoadContext context) {
        ((OWorkLoadContext)context).db.commit();
    }

    public class OWorkLoadContext
    extends OBaseWorkload.OBaseWorkLoadContext {
        private ODatabase db;

        @Override
        public void init(ODatabaseIdentifier dbIdentifier, int operationsPerTransaction) {
            this.db = OBaseDocumentWorkload.this.getDocumentDatabase(dbIdentifier, OBaseDocumentWorkload.this.connectionStrategy);
        }

        @Override
        public void close() {
            if (this.getDb() != null) {
                this.getDb().close();
            }
        }

        public ODatabase getDb() {
            return this.db;
        }
    }
}

