/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerContextTask;
import com.sun.grizzly.ContextTask;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainContextTask;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements AttributeHolder,
Copyable {
    private OpType currentOpType;
    private ProtocolChain protocolChain;
    public static final String THROWABLE = "throwable";
    private Map<String, Object> attributes = null;
    private SelectionKey key;
    private SelectorHandler selectorHandler;
    private Controller controller;
    private KeyRegistrationState keyRegistrationState = KeyRegistrationState.REGISTER;
    private Pipeline pipeline;
    private IOEvent<Context> ioEvent;
    private AsyncQueueReader asyncQueueReader;
    private AsyncQueueWriter asyncQueueWriter;
    private AsyncQueueReadable asyncQueueReadable;
    private AsyncQueueWritable asyncQueueWritable;

    @Override
    public void copyTo(Copyable copy) {
        Context copyContext = (Context)copy;
        copyContext.currentOpType = this.currentOpType;
        copyContext.protocolChain = this.protocolChain;
        if (this.attributes != null) {
            copyContext.attributes = new HashMap<String, Object>(this.attributes);
        }
        copyContext.key = this.key;
        copyContext.selectorHandler = this.selectorHandler;
        copyContext.controller = this.controller;
        copyContext.keyRegistrationState = this.keyRegistrationState;
        copyContext.pipeline = this.pipeline;
        copyContext.ioEvent = this.ioEvent;
        copyContext.asyncQueueReader = this.asyncQueueReader;
        copyContext.asyncQueueWriter = this.asyncQueueWriter;
        copyContext.asyncQueueReadable = this.asyncQueueReadable;
        copyContext.asyncQueueWritable = this.asyncQueueWritable;
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public AttributeHolder getAttributeHolderByScope(AttributeScope scope) {
        AttributeHolder holder = null;
        switch (scope) {
            case REQUEST: {
                holder = this;
                break;
            }
            case CONNECTION: {
                Object attachment = this.getSelectionKey().attachment();
                if (!(attachment instanceof AttributeHolder)) break;
                holder = (AttributeHolder)attachment;
                break;
            }
            case SELECTOR: {
                holder = this.selectorHandler;
                break;
            }
            case CONTROLLER: {
                holder = this.controller;
            }
        }
        return holder;
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void recycle() {
        this.getProtocolChainInstanceHandler().offer(this.protocolChain);
        this.key = null;
        this.keyRegistrationState = KeyRegistrationState.REGISTER;
        this.currentOpType = null;
        this.protocolChain = null;
        this.ioEvent = null;
        this.asyncQueueReader = null;
        this.asyncQueueWriter = null;
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public KeyRegistrationState getKeyRegistrationState() {
        return this.keyRegistrationState;
    }

    public void setKeyRegistrationState(KeyRegistrationState keyRegistrationState) {
        this.keyRegistrationState = keyRegistrationState;
    }

    public ProtocolChain getProtocolChain() {
        return this.protocolChain;
    }

    public void setProtocolChain(ProtocolChain protocolChain) {
        this.protocolChain = protocolChain;
    }

    public OpType getCurrentOpType() {
        return this.currentOpType;
    }

    public void setCurrentOpType(OpType currentOpType) {
        this.currentOpType = currentOpType;
    }

    protected void configureOpType(SelectionKey key) {
        int readyOps = key.readyOps();
        switch (readyOps) {
            case 8: {
                this.currentOpType = OpType.OP_CONNECT;
                break;
            }
            case 1: {
                this.currentOpType = OpType.OP_READ;
                break;
            }
            case 4: {
                this.currentOpType = OpType.OP_WRITE;
                break;
            }
            case 5: {
                this.currentOpType = OpType.OP_READ_WRITE;
                break;
            }
            case 16: {
                this.currentOpType = OpType.OP_ACCEPT;
                break;
            }
            default: {
                this.currentOpType = OpType.OP_CONNECT;
            }
        }
    }

    public void execute() throws PipelineFullException {
        Object attachment = SelectionKeyAttachment.getAttachment(this.key);
        if (this.ioEvent != null && attachment instanceof CallbackHandler) {
            CallbackHandlerContextTask task = CallbackHandlerContextTask.poll();
            task.setCallBackHandler((CallbackHandler)attachment);
            this.execute(task);
        } else {
            this.execute(ProtocolChainContextTask.poll());
        }
    }

    public void execute(ContextTask contextTask) throws PipelineFullException {
        this.execute(contextTask, true);
    }

    public void execute(ContextTask contextTask, boolean runInSeparateThread) throws PipelineFullException {
        if (this.protocolChain == null) {
            ProtocolChainInstanceHandler pciHandler = this.getProtocolChainInstanceHandler();
            this.protocolChain = pciHandler.poll();
        }
        if (contextTask != null) {
            contextTask.setContext(this);
            if (runInSeparateThread) {
                this.getPipeline().execute(contextTask);
            } else {
                try {
                    contextTask.call();
                }
                catch (Exception e) {
                    Controller.logger().log(Level.SEVERE, "Unexpected exception occured, when executing task: " + contextTask, e);
                }
            }
        }
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        ProtocolChainInstanceHandler protocolChainInstanceHandler = this.selectorHandler.getProtocolChainInstanceHandler();
        return protocolChainInstanceHandler != null ? protocolChainInstanceHandler : this.controller.getProtocolChainInstanceHandler();
    }

    public Pipeline getPipeline() {
        if (this.pipeline == null && this.controller != null) {
            this.pipeline = this.controller.getPipeline();
        }
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected void setIOEvent(IOEvent<Context> ioEvent) {
        this.ioEvent = ioEvent;
    }

    protected IOEvent getIOEvent() {
        return this.ioEvent;
    }

    public Controller.Protocol getProtocol() {
        return this.selectorHandler.protocol();
    }

    public void setProtocol(Controller.Protocol protocol) {
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    public AsyncQueueReadable getAsyncQueueReadable() {
        if (this.asyncQueueReadable == null) {
            this.asyncQueueReadable = new AsyncQueueReadableContextWrapper();
        }
        return this.asyncQueueReadable;
    }

    public AsyncQueueWritable getAsyncQueueWritable() {
        if (this.asyncQueueWritable == null) {
            this.asyncQueueWritable = new AsyncQueueWritableContextWrapper();
        }
        return this.asyncQueueWritable;
    }

    protected AsyncQueueReader getAsyncQueueReader() {
        return this.asyncQueueReader;
    }

    protected void setAsyncQueueReader(AsyncQueueReader asyncQueueReader) {
        this.asyncQueueReader = asyncQueueReader;
    }

    protected AsyncQueueWriter getAsyncQueueWriter() {
        return this.asyncQueueWriter;
    }

    protected void setAsyncQueueWriter(AsyncQueueWriter asyncQueueWriter) {
        this.asyncQueueWriter = asyncQueueWriter;
    }

    private class AsyncQueueReadableContextWrapper
    implements AsyncQueueReadable {
        private AsyncQueueReadableContextWrapper() {
        }

        public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
            Context.this.asyncQueueReader.read(Context.this.key, buffer, callbackHandler);
        }

        public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
            Context.this.asyncQueueReader.read(Context.this.key, buffer, callbackHandler, condition);
        }

        public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
            Context.this.asyncQueueReader.read(Context.this.key, buffer, callbackHandler, condition, readPostProcessor);
        }
    }

    private class AsyncQueueWritableContextWrapper
    implements AsyncQueueWritable {
        private AsyncQueueWritableContextWrapper() {
        }

        public void writeToAsyncQueue(ByteBuffer buffer) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, buffer);
        }

        public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, buffer, callbackHandler);
        }

        public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, buffer, callbackHandler, writePreProcessor);
        }

        public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, buffer, callbackHandler, writePreProcessor, isCloneByteBuffer);
        }

        public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, dstAddress, buffer);
        }

        public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, dstAddress, buffer, callbackHandler);
        }

        public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, dstAddress, buffer, callbackHandler, writePreProcessor);
        }

        public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
            Context.this.asyncQueueWriter.write(Context.this.key, dstAddress, buffer, callbackHandler, writePreProcessor, isCloneByteBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        OP_READ,
        OP_WRITE,
        OP_CONNECT,
        OP_READ_WRITE,
        OP_ACCEPT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyRegistrationState {
        CANCEL,
        REGISTER,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeScope {
        REQUEST,
        CONNECTION,
        SELECTOR,
        CONTROLLER;

    }
}

