/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLEchoAsyncWriteQueueFilter
implements ProtocolFilter {
    private static final String SSL_WRITE_PREPROCESSOR = "SSL_WRITE_PREPROCESSOR";

    public boolean execute(Context ctx) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer buffer = workerThread.getByteBuffer();
        buffer.flip();
        if (buffer.hasRemaining()) {
            byte[] data = new byte[buffer.remaining()];
            int position = buffer.position();
            buffer.get(data);
            buffer.position(position);
            SSLEngine sslEngine = workerThread.getSSLEngine();
            AttributeHolder attributes = ctx.getAttributeHolderByScope(Context.AttributeScope.CONNECTION);
            SSLWritePreProcessor preProcessor = (SSLWritePreProcessor)attributes.getAttribute(SSL_WRITE_PREPROCESSOR);
            if (preProcessor == null) {
                preProcessor = new SSLWritePreProcessor(sslEngine, workerThread.getOutputBB());
                workerThread.setOutputBB(null);
                attributes.setAttribute(SSL_WRITE_PREPROCESSOR, preProcessor);
            }
            ctx.getAsyncQueueWritable().writeToAsyncQueue(buffer, null, preProcessor, true);
        }
        buffer.clear();
        return false;
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    private static class SSLWritePreProcessor
    implements AsyncQueueDataProcessor {
        private SSLEngine sslEngine;
        private ByteBuffer securedOutputBuffer;

        public SSLWritePreProcessor(SSLEngine sslEngine, ByteBuffer securedOutputBuffer) {
            this.sslEngine = sslEngine;
            this.securedOutputBuffer = securedOutputBuffer;
        }

        public ByteBuffer getInternalByteBuffer() {
            return this.securedOutputBuffer;
        }

        public void process(ByteBuffer byteBuffer) throws IOException {
            if (!byteBuffer.hasRemaining() || this.securedOutputBuffer.hasRemaining()) {
                return;
            }
            this.securedOutputBuffer.clear();
            try {
                SSLEngineResult result = this.sslEngine.wrap(byteBuffer, this.securedOutputBuffer);
                this.securedOutputBuffer.flip();
            }
            catch (Exception e) {
                this.securedOutputBuffer.position(this.securedOutputBuffer.limit());
                throw new IOException(e.getMessage());
            }
        }
    }
}

