/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.SelectorFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public class OutputWriter {
    private static int defaultWriteTimeout = 30000;

    public static long flushChannel(SelectableChannel channel, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(channel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long flushChannel(SelectableChannel channel, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (channel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesProduced = 0;
        try {
            WritableByteChannel writableChannel = (WritableByteChannel)((Object)channel);
            while (bb.hasRemaining()) {
                int len = writableChannel.write(bb);
                if (len > 0) {
                    attempts = 0;
                    bytesProduced += len;
                    continue;
                }
                ++attempts;
                if (writeSelector == null) {
                    writeSelector = SelectorFactory.getSelector();
                    if (writeSelector == null) continue;
                    key = channel.register(writeSelector, 4);
                }
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
            Object var11_9 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) return bytesProduced;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) throw throwable;
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
            throw throwable;
        }
        SelectorFactory.selectNowAndReturnSelector(writeSelector);
        return bytesProduced;
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (socketChannel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        long totalBytes = 0L;
        for (ByteBuffer aBb : bb) {
            totalBytes += (long)aBb.remaining();
        }
        long bytesProduced = 0L;
        try {
            while (bytesProduced < totalBytes) {
                long len = socketChannel.write(bb);
                if (len > 0L) {
                    attempts = 0;
                    bytesProduced += len;
                    continue;
                }
                if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                key = socketChannel.register(writeSelector, 4);
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
            Object var14_13 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) return bytesProduced;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) throw throwable;
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
            throw throwable;
        }
        SelectorFactory.selectNowAndReturnSelector(writeSelector);
        return bytesProduced;
    }

    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(datagramChannel, socketAddress, bb, defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (datagramChannel == null) {
            throw new IllegalStateException("Invalid Response State. DatagramChannel cannot be null.");
        }
        if (socketAddress == null) {
            throw new IllegalStateException("Invalid Response State. SocketAddress cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesProduced = 0;
        try {
            while (bb.hasRemaining()) {
                int len = datagramChannel.send(bb, socketAddress);
                if (len > 0) {
                    attempts = 0;
                    bytesProduced += len;
                    continue;
                }
                if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                key = datagramChannel.register(writeSelector, 4);
                if (writeSelector.select(writeTimeout) == 0) {
                    if (attempts <= 2) continue;
                    throw new IOException("Client disconnected");
                }
                --attempts;
            }
            Object var11_9 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) return bytesProduced;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) throw throwable;
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
            throw throwable;
        }
        SelectorFactory.selectNowAndReturnSelector(writeSelector);
        return bytesProduced;
    }

    public static int getDefaultWriteTimeout() {
        return defaultWriteTimeout;
    }

    public static void setDefaultWriteTimeout(int aDefaultWriteTimeout) {
        defaultWriteTimeout = aDefaultWriteTimeout;
    }
}

