/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone.servlet;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.standalone.StandaloneMainUtil;
import com.sun.grizzly.tcp.Adapter;
import javax.servlet.Servlet;

public class ServletLauncher
extends StandaloneMainUtil {
    protected String applicationLoc;
    private String servletClassName;

    public static void main(String[] args) throws Exception {
        ServletLauncher sl = new ServletLauncher();
        sl.start(args);
    }

    public void printHelpAndExit() {
        System.err.println("Usage: " + ServletLauncher.class.getCanonicalName() + " [options] Servlet_Classname");
        System.err.println();
        System.err.println("    -p, --port=port                  Runs Servlet on the specified port.");
        System.err.println("                                     Default: 8080");
        System.err.println("    -a, --apps=application path      The Servlet folder or jar or war location.");
        System.err.println("                                     Default: .");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                this.applicationLoc = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                this.applicationLoc = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            this.setPort(num);
        }
        if (this.applicationLoc == null) {
            System.err.println("Illegal War file.");
            this.printHelpAndExit();
        }
        this.servletClassName = args[args.length - 1];
        if (this.servletClassName == null) {
            System.err.println("Illegal Servlet name.");
            this.printHelpAndExit();
        }
        return true;
    }

    public Adapter configureAdapter(SelectorThread st) {
        ServletAdapter adapter = new ServletAdapter();
        adapter.setRootFolder(SelectorThread.getWebAppRootPath());
        st.setAdapter((Adapter)adapter);
        adapter.setHandleStaticResources(true);
        Servlet servlet = (Servlet)ServletLauncher.loadClass((String)this.servletClassName);
        if (servlet == null) {
            throw new IllegalStateException("Invalid Servlet ClassName");
        }
        System.out.println("Launching Servlet: " + servlet.getClass().getName());
        adapter.setServletInstance(servlet);
        return adapter;
    }

    public String parseApplicationLocation(String[] args) {
        return this.applicationLoc;
    }
}

