/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.rcm;

import com.sun.grizzly.Context;
import com.sun.grizzly.ContextTask;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChainContextTask;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.filter.ParserProtocolFilter;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.WorkerThread;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class ResourceAllocationFilter
extends ParserProtocolFilter {
    public static final String BYTE_BUFFER = "byteBuffer";
    protected static final String RESERVE = "reserve";
    protected static final String CEILING = "ceiling";
    protected static final String ALLOCATION_MODE = "com.sun.grizzly.rcm.policyMethod";
    protected static final String RULE_TOKENS = "com.sun.grizzly.rcm.policyMetric";
    private static final String DELAY_VALUE = "com.sun.grizzly.rcm.delay";
    protected static final String QUERY_STRING = "?";
    protected static final String PATH_STRING = "/";
    public static final String BYTEBUFFER_INPUTSTREAM = "bbInputStream";
    public static final String INVOKE_NEXT = "invokeNextFilter";
    protected static final ConcurrentHashMap<String, Pipeline> pipelines = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<String, Double> privilegedTokens = new ConcurrentHashMap();
    protected static double leftRatio = 1.0;
    protected static String allocationPolicy = "reserve";
    private static long delayValue = 5000L;
    private ConcurrentLinkedQueue<ProtocolParser> protocolParserCache = new ConcurrentLinkedQueue();

    public boolean invokeProtocolParser(Context ctx, ProtocolParser protocolParser) {
        Pipeline pipeline;
        if (ctx.getAttribute(INVOKE_NEXT) != null) {
            return true;
        }
        super.invokeProtocolParser(ctx, protocolParser);
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        Controller.Protocol protocol = ctx.getProtocol();
        ByteBufferInputStream inputStream = (ByteBufferInputStream)ctx.getAttribute(BYTEBUFFER_INPUTSTREAM);
        if (inputStream == null) {
            inputStream = new ByteBufferInputStream();
            ctx.setAttribute(BYTEBUFFER_INPUTSTREAM, (Object)inputStream);
        }
        if (protocol == Controller.Protocol.TLS) {
            inputStream.setSecure(true);
        }
        String token = this.getContextRoot(byteBuffer);
        int delayCount = 0;
        while (leftRatio == 0.0 && privilegedTokens.get(token) == null) {
            if (allocationPolicy.equals(RESERVE)) {
                this.delay(ctx);
                ++delayCount;
            } else if (allocationPolicy.equals(CEILING)) {
                if (!this.isPipelineInUse()) break;
                this.delay(ctx);
                ++delayCount;
            }
            if (delayCount <= 5) continue;
            this.closeConnection(ctx);
            return false;
        }
        if ((pipeline = pipelines.get(token)) == null) {
            pipeline = this.filterRequest(token, ctx.getPipeline());
            pipelines.put(token, pipeline);
        }
        ctx.setPipeline(pipeline);
        ByteBuffer nBuf = (ByteBuffer)ctx.getAttribute(BYTE_BUFFER);
        if (nBuf != null) {
            nBuf.clear();
            workerThread.setByteBuffer(nBuf);
        } else {
            workerThread.setByteBuffer(ByteBufferFactory.allocateView((boolean)false));
        }
        protocolParser.releaseBuffer();
        ctx.setAttribute(BYTE_BUFFER, (Object)byteBuffer);
        ctx.setAttribute(INVOKE_NEXT, (Object)"true");
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        try {
            Context copyContext = (Context)Cloner.clone((Copyable)ctx);
            copyContext.execute((ContextTask)ProtocolChainContextTask.poll());
        }
        catch (Throwable t) {
            ctx.setAttribute("throwable", (Object)t);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        }
        return false;
    }

    private void delay(Context ctx) {
        try {
            Thread.sleep(delayValue);
        }
        catch (InterruptedException ex) {
            Controller.logger().log(Level.SEVERE, "Delay exception", ex);
        }
    }

    public Pipeline filterRequest(String token, Pipeline p) {
        int maxThreads = p.getMaxThreads();
        Double threadRatio = privilegedTokens.get(token);
        if (threadRatio == null) {
            threadRatio = leftRatio == 0.0 ? 0.5 : leftRatio;
        }
        int privilegedCount = threadRatio == 1.0 ? maxThreads : (int)((double)maxThreads * threadRatio) + 1;
        return this.newPipeline(privilegedCount, p);
    }

    protected Pipeline newPipeline(int threadCount, Pipeline p) {
        if (threadCount == 0) {
            return null;
        }
        DefaultPipeline pipeline = new DefaultPipeline();
        pipeline.setMinThreads(1);
        pipeline.setMaxThreads(threadCount);
        pipeline.setName("RCM_" + threadCount);
        pipeline.initPipeline();
        pipeline.startPipeline();
        return pipeline;
    }

    protected boolean isPipelineInUse() {
        Collection<Pipeline> collection = pipelines.values();
        for (Pipeline pipeline : collection) {
            if (pipeline.size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected String getContextRoot(ByteBuffer byteBuffer) {
        boolean slash;
        byte[] chars = new byte[byteBuffer.limit() - byteBuffer.position()];
        byteBuffer.get(chars);
        String token = new String(chars);
        int index = token.indexOf(QUERY_STRING);
        if (index != -1) {
            token = token.substring(0, index);
        }
        if (slash = token.endsWith(PATH_STRING)) {
            token = token.substring(0, token.length() - 1);
        }
        return token;
    }

    public void closeConnection(Context ctx) {
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
    }

    public ProtocolParser newProtocolParser() {
        ProtocolParser protocolParser = this.protocolParserCache.poll();
        if (protocolParser == null) {
            protocolParser = new ProtocolParser(){
                private ByteBuffer byteBuffer;
                private boolean isExpectingMoreData = false;
                private int nextStartPosition;
                private int nextEndPosition;

                public boolean hasMoreBytesToParse() {
                    return false;
                }

                public boolean isExpectingMoreData() {
                    return this.isExpectingMoreData;
                }

                public Object getNextMessage() {
                    return null;
                }

                public boolean hasNextMessage() {
                    if (!this.byteBuffer.hasRemaining()) {
                        this.isExpectingMoreData = true;
                        return false;
                    }
                    int state = 0;
                    int start = 0;
                    int end = 0;
                    try {
                        block6: while (this.byteBuffer.hasRemaining()) {
                            byte c = this.byteBuffer.get();
                            switch (state) {
                                case 0: {
                                    if (c != 32) continue block6;
                                    state = 1;
                                    start = this.byteBuffer.position() + 1;
                                    continue block6;
                                }
                                case 1: {
                                    if (c != 32) continue block6;
                                    end = this.byteBuffer.position() - 1;
                                    this.byteBuffer.position(start);
                                    this.byteBuffer.limit(end);
                                    this.isExpectingMoreData = false;
                                    return true;
                                }
                            }
                            throw new IllegalArgumentException("Unexpected state");
                        }
                        this.isExpectingMoreData = true;
                    }
                    catch (BufferUnderflowException bue) {
                        this.isExpectingMoreData = true;
                    }
                    return false;
                }

                public void startBuffer(ByteBuffer bb) {
                    this.nextStartPosition = bb.position();
                    this.nextEndPosition = bb.limit();
                    bb.flip();
                    this.byteBuffer = bb;
                }

                public boolean releaseBuffer() {
                    this.byteBuffer.limit(this.nextEndPosition);
                    this.byteBuffer.position(this.nextStartPosition);
                    return false;
                }
            };
        }
        return protocolParser;
    }

    static {
        try {
            if (System.getProperty(RULE_TOKENS) != null) {
                StringTokenizer privList = new StringTokenizer(System.getProperty(RULE_TOKENS), ",");
                double countRatio = 0.0;
                while (privList.hasMoreElements()) {
                    StringTokenizer privElement = new StringTokenizer(privList.nextToken());
                    while (privElement.hasMoreElements()) {
                        String tokens = privElement.nextToken();
                        int index = tokens.indexOf("|");
                        double tokenValue = Double.valueOf(tokens.substring(index + 1));
                        privilegedTokens.put(tokens.substring(0, index), tokenValue);
                        countRatio += tokenValue;
                    }
                }
                if (countRatio > 1.0) {
                    System.out.println("Thread ratio too high. The total must be lower or equal to 1");
                } else {
                    leftRatio = 1.0 - countRatio;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to parse thread ratio");
        }
        if (System.getProperty(ALLOCATION_MODE) != null && !(allocationPolicy = System.getProperty(ALLOCATION_MODE)).equals(RESERVE) && !allocationPolicy.equals(CEILING)) {
            System.out.println("Invalid allocation policy");
            allocationPolicy = RESERVE;
        }
    }
}

