/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public abstract class ParserProtocolFilter
extends ReadFilter {
    protected boolean isSkipRead;

    public boolean execute(Context ctx) throws IOException {
        boolean isExpectingMoreData;
        ProtocolParser parser = null;
        AttributeHolder connectionAttrs = ctx.getAttributeHolderByScope(Context.AttributeScope.CONNECTION);
        if (connectionAttrs != null) {
            parser = (ProtocolParser)connectionAttrs.removeAttribute("ProtocolParser");
        }
        if (parser == null) {
            parser = (ProtocolParser)ctx.getAttribute("ProtocolParser");
            if (parser == null) {
                parser = this.newProtocolParser();
                ctx.setAttribute("ProtocolParser", parser);
            }
        } else {
            ctx.setAttribute("ProtocolParser", parser);
        }
        if ((isExpectingMoreData = parser.isExpectingMoreData()) || !parser.hasMoreBytesToParse()) {
            if (isExpectingMoreData) {
                ((WorkerThread)Thread.currentThread()).updateAttachment(ThreadAttachment.Mode.ATTRIBUTES_ONLY);
            }
            boolean continueExecution = this.isSkipRead || super.execute(ctx);
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            ByteBuffer byteBuffer = workerThread.getByteBuffer();
            parser.startBuffer(byteBuffer);
            if (!continueExecution) {
                return continueExecution;
            }
        }
        if (!parser.hasNextMessage()) {
            return false;
        }
        return this.invokeProtocolParser(ctx, parser);
    }

    protected boolean invokeProtocolParser(Context ctx, ProtocolParser parser) {
        if (parser == null) {
            throw new IllegalStateException("ProcotolParser cannot be null");
        }
        Object o = parser.getNextMessage();
        ctx.setAttribute("ProtocolMessage", o);
        return true;
    }

    public boolean postExecute(Context context) throws IOException {
        ProtocolParser parser = (ProtocolParser)context.getAttribute("ProtocolParser");
        if (parser == null) {
            return true;
        }
        if (parser != null && parser.hasMoreBytesToParse()) {
            context.setAttribute("succes_read", Boolean.TRUE);
            return true;
        }
        SelectionKey key = context.getSelectionKey();
        if (parser.isExpectingMoreData()) {
            if (parser.releaseBuffer()) {
                this.saveParser(key, parser);
            }
            this.saveByteBuffer(key);
            context.getSelectorHandler().register(key, 1);
            return false;
        }
        if (parser.releaseBuffer()) {
            this.saveParser(key, parser);
        }
        return super.postExecute(context);
    }

    public abstract ProtocolParser newProtocolParser();

    private void saveByteBuffer(SelectionKey key) {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ThreadAttachment threadAttachment = workerThread.updateAttachment(ThreadAttachment.Mode.BYTE_BUFFER);
        key.attach(threadAttachment);
    }

    private void saveParser(SelectionKey key, ProtocolParser parser) {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ThreadAttachment threadAttachment = workerThread.getAttachment();
        threadAttachment.setAttribute("ProtocolParser", parser);
        key.attach(threadAttachment);
    }

    protected boolean isSkipRead() {
        return this.isSkipRead;
    }

    protected void setSkipRead(boolean isSkipRead) {
        this.isSkipRead = isSkipRead;
    }
}

