/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.arp.AsyncProtocolFilter;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.FileCacheFactory;
import com.sun.grizzly.http.KeepAliveCountManager;
import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.LinkedListPipeline;
import com.sun.grizzly.http.Management;
import com.sun.grizzly.http.PipelineStatistic;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThreadConfig;
import com.sun.grizzly.http.SelectorThreadHandler;
import com.sun.grizzly.http.SelectorThreadKeyHandler;
import com.sun.grizzly.http.Task;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUReadFilter;
import com.sun.grizzly.portunif.ProtocolFinder;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.rcm.ResourceAllocationFilter;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.RequestGroupInfo;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.WorkerThread;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThread
extends Thread
implements MBeanRegistration {
    public static final String SERVER_NAME = System.getProperty("product.name") != null ? System.getProperty("product.name") : "grizzly";
    private Object[] lock = new Object[0];
    protected int serverTimeout = 0;
    protected InetAddress inet;
    protected int port;
    protected boolean initialized = false;
    protected volatile boolean running = false;
    protected String domain;
    protected ObjectName oname;
    protected ObjectName globalRequestProcessorName;
    private ObjectName keepAliveMbeanName;
    private ObjectName connectionQueueMbeanName;
    private ObjectName fileCacheMbeanName;
    protected MBeanServer mserver;
    protected ObjectName processorWorkerThreadName;
    protected boolean tcpNoDelay = false;
    protected int linger = 100;
    protected int socketTimeout = -1;
    protected int maxKeepAliveRequests = 256;
    protected int keepAliveThreadCount = 1;
    protected String compression = "off";
    protected String noCompressionUserAgents = null;
    protected String restrictedUserAgents = null;
    protected String compressableMimeTypes = "text/html,text/xml,text/plain";
    private volatile String[] parsedCompressableMimeTypes = null;
    private volatile int parsedComressableMimeTypesHash = -1;
    protected int compressionMinSize = 2048;
    private boolean reuseAddress = true;
    protected boolean bufferResponse = false;
    protected int maxHttpHeaderSize = 8192;
    protected int maxPostSize = 0x200000;
    protected Selector selector;
    protected TCPSelectorHandler selectorHandler;
    protected Adapter adapter = null;
    protected LinkedListPipeline processorPipeline;
    protected PipelineStatistic pipelineStat;
    protected String pipelineClassName = LinkedListPipeline.class.getName();
    protected int maxThreads = 5;
    protected int minWorkerThreads = 5;
    protected int threadsIncrement = 1;
    protected int threadsTimeout = 30;
    protected boolean useDirectByteBuffer = false;
    protected RequestGroupInfo globalRequestProcessor = new RequestGroupInfo();
    private KeepAliveStats keepAliveStats = new KeepAliveStats();
    protected boolean displayConfiguration = false;
    protected boolean isMonitoringEnabled = false;
    protected int requestBufferSize = 8192;
    protected boolean useByteBufferView = false;
    protected int keepAliveTimeoutInSeconds = 30;
    protected boolean recycleTasks = true;
    protected static int selectorTimeout = 1000;
    protected int maxQueueSizeInBytes = 4096;
    protected Class algorithmClass;
    protected String algorithmClassName = DEFAULT_ALGORITHM;
    public static final String DEFAULT_ALGORITHM = NoParsingAlgorithm.class.getName();
    protected int ssBackLog = 4096;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected static String rootFolder = "";
    protected Controller controller;
    protected boolean rcmSupport = false;
    protected PUReadFilter portUnificationFilter;
    protected boolean oOBInline = false;
    protected HashMap<String, Object> properties = new HashMap();
    protected ConcurrentLinkedQueue<ProcessorTask> processorTasks = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<ProcessorTask> activeProcessorTasks = new ConcurrentLinkedQueue();
    protected int readThreadsCount = 0;
    protected static Logger logger = Logger.getLogger("GRIZZLY");
    protected boolean disableUploadTimeout = true;
    protected int uploadTimeout = 30000;
    protected KeepAliveCountManager keepAliveCounter;
    protected FileCacheFactory fileCacheFactory;
    protected int secondsMaxAge = -1;
    protected int maxCacheEntries = 1024;
    protected long minEntrySize = 2048L;
    protected long maxEntrySize = 537600L;
    protected long maxLargeFileCacheSize = 0xA00000L;
    protected long maxSmallFileCacheSize = 0x100000L;
    protected boolean isFileCacheEnabled = true;
    protected boolean isLargeFileCacheEnabled = true;
    protected boolean asyncExecution = false;
    protected AsyncHandler asyncHandler;
    protected static boolean defaultAlgorithmInstalled = true;
    private Management jmxManagement = null;
    private ClassLoader classLoader;
    protected boolean enableNioLogging = false;
    private static final ConcurrentHashMap<Integer, SelectorThread> selectorThreads = new ConcurrentHashMap();
    private SelectorThreadKeyHandler keyHandler;

    public static final SelectorThread getSelector(int port) {
        return selectorThreads.get(port);
    }

    public static final Enumeration<SelectorThread> getSelectors() {
        return selectorThreads.elements();
    }

    public void registerKey(SelectionKey key) {
        this.selectorHandler.register(key, 1);
    }

    protected void initController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        LoggerUtils.setLogger(logger);
        Controller.setLogger(logger);
        this.selectorHandler = this.createSelectorHandler();
        this.configureSelectorHandler(this.selectorHandler);
        this.controller.setSelectorHandler(this.selectorHandler);
        this.keyHandler = new SelectorThreadKeyHandler(this);
        this.keyHandler.setLogger(logger);
        this.keyHandler.setTimeout(this.keepAliveTimeoutInSeconds * 1000);
        this.selectorHandler.setSelectionKeyHandler(this.keyHandler);
        final DefaultProtocolChain protocolChain = new DefaultProtocolChain(){

            public void execute(Context ctx) throws Exception {
                if (SelectorThread.this.rcmSupport) {
                    ByteBuffer byteBuffer = (ByteBuffer)ctx.getAttribute("byteBuffer");
                    if (byteBuffer != null) {
                        ((WorkerThread)Thread.currentThread()).setByteBuffer(byteBuffer);
                    }
                    if (this.protocolFilters.size() != 0) {
                        int currentPosition = super.executeProtocolFilter(ctx);
                        super.postExecuteProtocolFilter(currentPosition, ctx);
                    }
                } else {
                    super.execute(ctx);
                }
            }
        };
        this.configureFilters(protocolChain);
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return true;
            }
        };
        this.controller.setProtocolChainInstanceHandler(instanceHandler);
        this.controller.setPipeline(this.processorPipeline);
        this.controller.setReadThreadsCount(this.readThreadsCount);
    }

    protected TCPSelectorHandler createSelectorHandler() {
        return new SelectorThreadHandler(this);
    }

    protected void configureSelectorHandler(TCPSelectorHandler selectorHandler) {
        selectorHandler.setSelector(this.selector);
        selectorHandler.setPort(this.port);
        selectorHandler.setInet(this.inet);
        selectorHandler.setLinger(this.linger);
        selectorHandler.setLogger(logger);
        selectorHandler.setReuseAddress(this.reuseAddress);
        selectorHandler.setSelectTimeout(selectorTimeout);
        selectorHandler.setServerTimeout(this.serverTimeout);
        selectorHandler.setSocketTimeout(this.keepAliveTimeoutInSeconds * 1000);
        selectorHandler.setSsBackLog(this.ssBackLog);
        selectorHandler.setTcpNoDelay(this.tcpNoDelay);
    }

    protected ProtocolFilter createRaFilter() {
        return new ResourceAllocationFilter(){

            protected Pipeline newPipeline(int threadCount, Pipeline p) {
                if (threadCount == 0) {
                    return null;
                }
                LinkedListPipeline pipeline = new LinkedListPipeline();
                pipeline.setMinThreads(1);
                pipeline.setMaxThreads(threadCount);
                pipeline.setName("RCM_" + threadCount);
                pipeline.initPipeline();
                pipeline.startPipeline();
                return pipeline;
            }
        };
    }

    protected ProtocolFilter createHttpParserFilter() {
        if (this.asyncExecution) {
            return new AsyncProtocolFilter(this.algorithmClass, this.port);
        }
        return new DefaultProtocolFilter(this.algorithmClass, this.port);
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            protocolChain.addFilter(this.portUnificationFilter);
        } else {
            ReadFilter readFilter = new ReadFilter();
            protocolChain.addFilter(readFilter);
        }
        if (this.rcmSupport) {
            protocolChain.addFilter(this.createRaFilter());
        }
        protocolChain.addFilter(this.createHttpParserFilter());
    }

    public void configurePortUnification(Properties props) {
        if (props == null) {
            props = System.getProperties();
        }
        this.portUnificationFilter = new PUReadFilter();
        this.portUnificationFilter.configure(props);
    }

    public void configurePortUnification(List<ProtocolFinder> protocolFinders, List<ProtocolHandler> protocolHandlers, List<PUPreProcessor> preProcessors) {
        this.portUnificationFilter = new PUReadFilter();
        this.portUnificationFilter.configure(protocolFinders, protocolHandlers, preProcessors);
    }

    protected LinkedListPipeline newPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        Class<?> className = null;
        LinkedListPipeline pipeline = null;
        try {
            className = this.classLoader == null ? Class.forName(this.pipelineClassName) : this.classLoader.loadClass(this.pipelineClassName);
            pipeline = (LinkedListPipeline)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to load Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        catch (InstantiationException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "http-listener " + port + " uses pipeline: " + pipeline.getClass().getName());
        }
        pipeline.setMaxThreads(maxThreads);
        pipeline.setMinThreads(minThreads);
        pipeline.setName(name);
        pipeline.setPort(port);
        pipeline.setPriority(priority);
        pipeline.setMaxQueueSize(this.maxQueueSizeInBytes);
        pipeline.setThreadsIncrement(this.threadsIncrement);
        return pipeline;
    }

    protected void initFileCacheFactory() {
        if (this.asyncExecution) {
            this.isFileCacheEnabled = false;
            this.isLargeFileCacheEnabled = false;
        }
        this.fileCacheFactory = FileCacheFactory.getFactory(this.port);
        FileCacheFactory.setIsEnabled(this.isFileCacheEnabled);
        this.fileCacheFactory.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCacheFactory.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCacheFactory.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCacheFactory.setMinEntrySize(this.minEntrySize);
        this.fileCacheFactory.setMaxEntrySize(this.maxEntrySize);
        this.fileCacheFactory.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCacheFactory.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
        this.fileCacheFactory.setHeaderBBSize(this.requestBufferSize);
    }

    protected void enablePipelineStats() {
        this.pipelineStat.start();
        this.processorPipeline.setPipelineStatistic(this.pipelineStat);
        this.pipelineStat.setProcessorPipeline(this.processorPipeline);
        if (this.keepAliveCounter != null) {
            this.keepAliveCounter.setKeepAliveStats(this.keepAliveStats);
        }
    }

    protected void disablePipelineStats() {
        this.pipelineStat.stop();
        this.processorPipeline.setPipelineStatistic(null);
        this.pipelineStat.setProcessorPipeline(null);
        if (this.keepAliveCounter != null) {
            this.keepAliveCounter.setKeepAliveStats(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAlgorithm() {
        try {
            this.algorithmClass = this.classLoader == null ? Class.forName(this.algorithmClassName) : this.classLoader.loadClass(this.algorithmClassName);
            logger.log(Level.FINE, "Using Algorithm: " + this.algorithmClassName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "Unable to load Algorithm: " + this.algorithmClassName);
        }
        finally {
            if (this.algorithmClass == null) {
                this.algorithmClass = NoParsingAlgorithm.class;
            }
        }
        defaultAlgorithmInstalled = this.algorithmClassName.equals(DEFAULT_ALGORITHM);
    }

    protected void initKeepAliveCounter() {
        this.keepAliveCounter = new KeepAliveCountManager();
        this.keepAliveCounter.setMaxKeepAliveRequests(this.maxKeepAliveRequests);
        this.keepAliveCounter.setKeepAliveTimeoutInSeconds(this.keepAliveTimeoutInSeconds);
        this.keepAliveCounter.setPort(this.port);
        this.keepAliveCounter.setThreadsTimeout(this.threadsTimeout);
        this.keepAliveCounter.setMaxThreads(this.keepAliveThreadCount);
        this.keepAliveStats.setMaxConnections(this.maxKeepAliveRequests);
        this.keepAliveStats.setSecondsTimeouts(this.keepAliveTimeoutInSeconds);
    }

    protected void initPipeline() {
        selectorThreads.put(this.port, this);
        this.processorPipeline = this.newPipeline(this.maxThreads, this.minWorkerThreads, "http", this.port, 10);
    }

    protected void initProcessorTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.processorTasks.offer(this.newProcessorTask(false));
        }
    }

    protected void rampUpProcessorTask() {
        Iterator<ProcessorTask> iterator = this.processorTasks.iterator();
        while (iterator.hasNext()) {
            iterator.next().initialize();
        }
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        DefaultProcessorTask task = new DefaultProcessorTask(initialize, this.bufferResponse);
        return this.configureProcessorTask(task);
    }

    protected ProcessorTask configureProcessorTask(DefaultProcessorTask task) {
        task.setAdapter(this.adapter);
        task.setMaxHttpHeaderSize(this.maxHttpHeaderSize);
        task.setBufferSize(this.requestBufferSize);
        task.setSelectorThread(this);
        task.setRecycle(this.recycleTasks);
        task.setDefaultResponseType(this.defaultResponseType);
        task.setForcedRequestType(this.forcedRequestType);
        task.setMaxPostSize(this.maxPostSize);
        task.setTimeout(this.uploadTimeout);
        task.setDisableUploadTimeout(this.disableUploadTimeout);
        if (this.keepAliveCounter.dropConnection()) {
            task.setDropConnection(true);
        }
        if (this.asyncExecution) {
            task.setEnableAsyncExecution(this.asyncExecution);
            task.setAsyncHandler(this.asyncHandler);
        }
        task.setPipeline(this.processorPipeline);
        this.configureCompression(task);
        return task;
    }

    protected void reconfigureAsyncExecution() {
        for (ProcessorTask task : this.processorTasks) {
            if (!(task instanceof DefaultProcessorTask)) continue;
            ((DefaultProcessorTask)task).setEnableAsyncExecution(this.asyncExecution);
            ((DefaultProcessorTask)task).setAsyncHandler(this.asyncHandler);
        }
    }

    public ProcessorTask getProcessorTask() {
        ProcessorTask processorTask = null;
        if (this.recycleTasks) {
            processorTask = this.processorTasks.poll();
        }
        if (processorTask == null) {
            processorTask = this.newProcessorTask(false);
        }
        if (this.isMonitoringEnabled()) {
            this.activeProcessorTasks.offer(processorTask);
        }
        return processorTask;
    }

    @Override
    public void run() {
        try {
            this.running = true;
            this.rampUpProcessorTask();
            this.registerComponents();
            this.displayConfiguration();
            this.startListener();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "selectorThread.errorOnRequest", ex);
        }
    }

    public void initEndpoint() throws IOException, InstantiationException {
        SelectorThreadConfig.configure(this);
        this.configureProperties();
        this.initAlgorithm();
        this.initKeepAliveCounter();
        this.initPipeline();
        this.initController();
        this.initFileCacheFactory();
        this.initMonitoringLevel();
        this.setName("SelectorThread-" + this.port);
        this.initProcessorTask(this.maxThreads);
        SelectorFactory.setMaxSelectors(this.maxThreads);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpoint() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.controller.stop();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "stopException", ex);
        }
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.clearTasks();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    private void configureProperties() {
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name).toString();
            IntrospectionUtils.setProperty(this, name, value);
        }
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.run();
    }

    public void listen() throws IOException, InstantiationException {
        this.initEndpoint();
        final CountDownLatch latch = new CountDownLatch(1);
        this.controller.addStateListener(new ControllerStateListenerAdapter(){

            public void onReady() {
                latch.countDown();
            }

            public void onException(Throwable e) {
                if (latch.getCount() > 0L) {
                    SelectorThread.logger().log(Level.SEVERE, "Exception during starting the controller", e);
                    latch.countDown();
                } else {
                    SelectorThread.logger().log(Level.SEVERE, "Exception during controller processing", e);
                }
            }
        });
        super.start();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.controller.isStarted()) {
            throw new IllegalStateException("Controller is not started!");
        }
    }

    protected void startPipelines() {
        this.processorPipeline.startPipeline();
    }

    protected void stopPipelines() {
        if (this.keepAliveCounter != null) {
            this.keepAliveCounter.stopPipeline();
        }
        this.processorPipeline.stopPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startListener() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            try {
                this.controller.start();
                this.stopPipelines();
                this.unregisterComponents();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "selectorThread.stopException", t);
            }
            return;
        }
    }

    public void cancelKey(SelectionKey key) {
        this.selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    public void returnTask(Task task) {
        if (task != null && task.getType() == 2) {
            if (this.isMonitoringEnabled()) {
                this.activeProcessorTasks.remove((DefaultProcessorTask)task);
            }
            this.processorTasks.offer((DefaultProcessorTask)task);
        }
    }

    protected void clearTasks() {
        this.processorTasks.clear();
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads == 1) {
            maxThreads = 5;
        } else {
            this.maxThreads = maxThreads;
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getPortLowLevel() {
        return this.selectorHandler.getPortLowLevel();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getCurrentBusyProcessorThreads() {
        int busy = this.processorPipeline.getCurrentThreadsBusy();
        return busy;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int i) {
        this.linger = i;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        if (this.keepAliveStats != null) {
            this.keepAliveStats.setSecondsTimeouts(timeout);
        }
        if (this.keepAliveCounter != null) {
            this.keepAliveCounter.setKeepAliveTimeoutInSeconds(timeout);
        }
        if (this.keyHandler != null) {
            this.keyHandler.setTimeout(timeout * 1000);
        }
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public int getKeepAliveThreadCount() {
        return this.keepAliveThreadCount;
    }

    public void setKeepAliveThreadCount(int threadCount) {
        if (this.keepAliveCounter != null) {
            this.keepAliveCounter.setMaxThreads(threadCount);
        }
        this.keepAliveThreadCount = threadCount;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void setSocketOptions(Socket socket) {
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setSoLinger exception ", ex);
        }
        try {
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setTcpNoDelay exception ", ex);
        }
        try {
            socket.setReuseAddress(this.reuseAddress);
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setReuseAddress exception ", ex);
        }
        try {
            if (this.oOBInline) {
                socket.setOOBInline(this.oOBInline);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setOOBInline exception ", ex);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    protected void registerComponents() {
        if (this.domain != null && this.jmxManagement != null) {
            try {
                this.globalRequestProcessorName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=http" + this.port);
                this.jmxManagement.registerComponent(this.globalRequestProcessor, this.globalRequestProcessorName, null);
                this.keepAliveMbeanName = new ObjectName(this.domain + ":type=KeepAlive,name=http" + this.port);
                this.jmxManagement.registerComponent(this.keepAliveStats, this.keepAliveMbeanName, null);
                this.connectionQueueMbeanName = new ObjectName(this.domain + ":type=ConnectionQueue,name=http" + this.port);
                this.jmxManagement.registerComponent(this.pipelineStat, this.connectionQueueMbeanName, null);
                this.fileCacheMbeanName = new ObjectName(this.domain + ":type=FileCache,name=http" + this.port);
                this.jmxManagement.registerComponent(this.fileCacheFactory, this.fileCacheMbeanName, null);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "selectorThread.mbeanRegistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    protected void unregisterComponents() {
        if (this.domain != null && this.jmxManagement != null) {
            try {
                if (this.globalRequestProcessorName != null) {
                    this.jmxManagement.unregisterComponent(this.globalRequestProcessorName);
                }
                if (this.keepAliveMbeanName != null) {
                    this.jmxManagement.unregisterComponent(this.keepAliveMbeanName);
                }
                if (this.connectionQueueMbeanName != null) {
                    this.jmxManagement.unregisterComponent(this.connectionQueueMbeanName);
                }
                if (this.fileCacheMbeanName != null) {
                    this.jmxManagement.unregisterComponent(this.fileCacheMbeanName);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "mbeanDeregistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    public Management getManagement() {
        return this.jmxManagement;
    }

    public void setManagement(Management jmxManagement) {
        this.jmxManagement = jmxManagement;
    }

    public void enableMonitoring() {
        this.isMonitoringEnabled = true;
        this.enablePipelineStats();
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public void disableMonitoring() {
        this.disablePipelineStats();
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public RequestGroupInfo getRequestGroupInfo() {
        return this.globalRequestProcessor;
    }

    public KeepAliveStats getKeepAliveStats() {
        return this.keepAliveStats;
    }

    protected void initMonitoringLevel() {
        this.pipelineStat = new PipelineStatistic(this.port);
        this.pipelineStat.setQueueSizeInBytes(this.maxQueueSizeInBytes);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setMinThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public Selector getSelector() {
        if (this.selector != null) {
            return this.selector;
        }
        this.selectorHandler.getSelector();
        return null;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void removeCacheEntry(String contextPath) {
        ConcurrentHashMap<String, FileCache.FileCacheEntry> cachedEntries = this.fileCacheFactory.getCache();
        if (cachedEntries == null) {
            return;
        }
        for (String cachedPath : cachedEntries.keySet()) {
            if (!cachedPath.startsWith(contextPath)) continue;
            cachedEntries.remove(cachedPath).run();
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.isFileCacheEnabled;
    }

    public void setFileCacheIsEnabled(boolean isFileCacheEnabled) {
        this.isFileCacheEnabled = isFileCacheEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        if (this.running) {
            this.reconfigureAsyncExecution();
        }
    }

    public boolean getEnableAsyncExecution() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public static void setLogger(Logger l) {
        if (l != null) {
            logger = l;
        }
    }

    public static Logger logger() {
        return logger;
    }

    public static void setWebAppRootPath(String rf) {
        rootFolder = rf;
    }

    public static String getWebAppRootPath() {
        return rootFolder;
    }

    private void displayConfiguration() {
        if (this.displayConfiguration) {
            logger.log(Level.INFO, "\n Grizzly configuration for port " + this.port + "\n\t maxThreads: " + this.maxThreads + "\n\t minThreads: " + this.minWorkerThreads + "\n\t ByteBuffer size: " + this.requestBufferSize + "\n\t maxHttpHeaderSize: " + this.maxHttpHeaderSize + "\n\t maxKeepAliveRequests: " + this.maxKeepAliveRequests + "\n\t keepAliveTimeoutInSeconds: " + this.keepAliveTimeoutInSeconds + "\n\t Static File Cache enabled: " + this.isFileCacheEnabled + "\n\t Static resources directory: " + new File(rootFolder).getAbsolutePath() + "\n\t Adapter : " + (this.adapter == null ? null : this.adapter.getClass().getName()) + "\n\t Thread Pool (Pipeline): " + this.pipelineClassName + "\n\t Asynchronous Request Processing enabled: " + this.asyncExecution);
        }
    }

    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    public void setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
    }

    public void enableRcmSupport(boolean rcmSupport) {
        this.rcmSupport = rcmSupport;
    }

    public boolean isRcmSupported() {
        return this.rcmSupport;
    }

    public KeepAliveCountManager getKeepAliveCounter() {
        return this.keepAliveCounter;
    }

    protected void configureCompression(DefaultProcessorTask processorTask) {
        processorTask.setCompression(this.compression);
        processorTask.addNoCompressionUserAgent(this.noCompressionUserAgents);
        this.parseComressableMimeTypes();
        processorTask.setCompressableMimeTypes(this.parsedCompressableMimeTypes);
        processorTask.setCompressionMinSize(this.compressionMinSize);
        processorTask.addRestrictedUserAgent(this.restrictedUserAgents);
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String getCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    private void parseComressableMimeTypes() {
        if (this.compressableMimeTypes == null) {
            this.parsedCompressableMimeTypes = new String[0];
            return;
        }
        int hash = -1;
        hash = this.compressableMimeTypes.hashCode();
        if (hash == this.parsedComressableMimeTypesHash) {
            return;
        }
        ArrayList<String> compressableMimeTypeList = new ArrayList<String>(4);
        StringTokenizer st = new StringTokenizer(this.compressableMimeTypes, ",");
        while (st.hasMoreTokens()) {
            compressableMimeTypeList.add(st.nextToken().trim());
        }
        String[] tmpParsedCompressableMimeTypes = new String[compressableMimeTypeList.size()];
        compressableMimeTypeList.toArray(tmpParsedCompressableMimeTypes);
        this.parsedCompressableMimeTypes = tmpParsedCompressableMimeTypes;
        this.parsedComressableMimeTypesHash = hash;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public int getSelectorReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setSelectorReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public Pipeline getProcessorPipeline() {
        return this.processorPipeline;
    }

    public String getPipelineClassName() {
        return this.pipelineClassName;
    }

    public void setPipelineClassName(String pipelineClassName) {
        this.pipelineClassName = pipelineClassName;
    }

    public int getMinWorkerThreads() {
        return this.minWorkerThreads;
    }

    public void setMinWorkerThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }

    public int getThreadsIncrement() {
        return this.threadsIncrement;
    }

    public void setThreadsIncrement(int threadsIncrement) {
        this.threadsIncrement = threadsIncrement;
    }

    public boolean isUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
    }

    public RequestGroupInfo getGlobalRequestProcessor() {
        return this.globalRequestProcessor;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    public boolean isUseByteBufferView() {
        return this.useByteBufferView;
    }

    public void setUseByteBufferView(boolean useByteBufferView) {
        this.useByteBufferView = useByteBufferView;
    }

    public static int getSelectorTimeout() {
        return selectorTimeout;
    }

    public static void setSelectorTimeout(int aSelectorTimeout) {
        selectorTimeout = aSelectorTimeout;
    }

    public int getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setMaxQueueSizeInBytes(int maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }

    public void setAlgorithmClassName(String algorithmClassName) {
        this.algorithmClassName = algorithmClassName;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public ConcurrentLinkedQueue<ProcessorTask> getActiveProcessorTasks() {
        return this.activeProcessorTasks;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isEnableNioLogging() {
        return this.enableNioLogging;
    }

    public void setEnableNioLogging(boolean enableNioLogging) {
        this.enableNioLogging = enableNioLogging;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public SelectorThreadKeyHandler getSelectorThreadKeyHandler() {
        return this.keyHandler;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setUploadTimeout(int uploadTimeout) {
        this.uploadTimeout = uploadTimeout;
    }

    public int getUploadTimeout() {
        return this.uploadTimeout;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }
}

