/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterChainImpl;
import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.IntrospectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;

public class ServletAdapter
extends GrizzlyAdapter {
    public static final int REQUEST_RESPONSE_NOTES = 12;
    public static final int SERVLETCONFIG_NOTES = 13;
    private Servlet servletInstance = null;
    private FilterChainImpl filterChain = new FilterChainImpl();
    private String servletPath = "";
    private String contextPath = "";
    private String basePath = "";
    private HashMap<String, String> parameters = new HashMap();
    private boolean isInitialized = false;
    private ReentrantLock initializedLock = new ReentrantLock();
    protected HashMap<String, Object> properties = new HashMap();

    public ServletAdapter() {
    }

    public ServletAdapter(String publicDirectory) {
        super(publicDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            Request req = request.getRequest();
            Response res = response.getResponse();
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(12);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(12);
            ServletConfigImpl servletConfig = (ServletConfigImpl)req.getNote(13);
            if (httpRequest == null) {
                httpRequest = new HttpServletRequestImpl(request);
                httpResponse = new HttpServletResponseImpl(response);
                ServletContextImpl servletCtx = new ServletContextImpl();
                servletCtx.setInitParameter(this.parameters);
                servletCtx.setServletPath(this.servletPath);
                servletCtx.setContextPath(this.contextPath);
                servletCtx.setBasePath(this.basePath);
                this.configureProperties(servletCtx);
                servletConfig = new ServletConfigImpl(servletCtx);
                httpRequest.setContextImpl(servletCtx);
                req.setNote(12, httpRequest);
                req.setNote(13, servletConfig);
                res.setNote(12, httpResponse);
            }
            if (!this.isInitialized) {
                this.initializedLock.lock();
                try {
                    if (this.servletInstance == null) {
                        String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                        if (servletClassName != null) {
                            this.servletInstance = ServletAdapter.loadServletInstance(servletClassName);
                        }
                        if (this.servletInstance == null) {
                            throw new RuntimeException("Invalid Servlet defined");
                        }
                    }
                    if (!this.isInitialized) {
                        this.servletInstance.init(servletConfig);
                        this.isInitialized = true;
                        this.filterChain.setServlet(servletConfig, this.servletInstance);
                    }
                }
                finally {
                    this.initializedLock.unlock();
                }
            }
            httpResponse.addHeader("server", "grizzly/1.7");
            this.filterChain.doFilter(httpRequest, httpResponse);
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.SEVERE, "service exception:", ex);
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        this.filterChain.recycle();
        Request req = request.getRequest();
        Response res = response.getResponse();
        HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(12);
        HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(12);
        httpRequest.recycle();
        httpResponse.recycle();
    }

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    private static Servlet loadServletInstance(String servletClass) {
        Class<?> className = null;
        try {
            className = Class.forName(servletClass, true, Thread.currentThread().getContextClassLoader());
            return (Servlet)className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl();
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setinitParameters(initParameters);
        this.filterChain.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private void configureProperties(Object object) {
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name).toString();
            IntrospectionUtils.setProperty(object, name, value);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }
}

