/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.zip;

import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.apache.commons.compress.zip.UnixStat;
import org.apache.commons.compress.zip.ZipExtraField;
import org.apache.commons.compress.zip.ZipLong;
import org.apache.commons.compress.zip.ZipShort;

public class AsiExtraField
implements ZipExtraField,
UnixStat,
Cloneable {
    private static final ZipShort HEADER_ID = new ZipShort(30062);
    private int m_mode;
    private int m_uid;
    private int m_gid;
    private String m_link = "";
    private boolean m_dirFlag;
    private CRC32 m_crc = new CRC32();

    public void setDirectory(boolean dirFlag) {
        this.m_dirFlag = dirFlag;
        this.m_mode = this.getMode(this.m_mode);
    }

    public void setGroupId(int gid) {
        this.m_gid = gid;
    }

    public void setLinkedFile(String name) {
        this.m_link = name;
        this.m_mode = this.getMode(this.m_mode);
    }

    public void setMode(int mode) {
        this.m_mode = this.getMode(mode);
    }

    public void setUserId(int uid) {
        this.m_uid = uid;
    }

    public void setUserID(int uid) {
        this.m_uid = uid;
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public int getGroupID() {
        return this.m_gid;
    }

    public int getGroupId() {
        return this.m_gid;
    }

    public ZipShort getHeaderID() {
        return HEADER_ID;
    }

    public String getLinkedFile() {
        return this.m_link;
    }

    public byte[] getLocalFileDataData() {
        byte[] data = new byte[this.getLocalFileDataLength().getValue() - 4];
        System.arraycopy(new ZipShort(this.getMode()).getBytes(), 0, data, 0, 2);
        byte[] linkArray = this.getLinkedFile().getBytes();
        System.arraycopy(new ZipLong(linkArray.length).getBytes(), 0, data, 2, 4);
        System.arraycopy(new ZipShort(this.getUserID()).getBytes(), 0, data, 6, 2);
        System.arraycopy(new ZipShort(this.getGroupID()).getBytes(), 0, data, 8, 2);
        System.arraycopy(linkArray, 0, data, 10, linkArray.length);
        this.m_crc.reset();
        this.m_crc.update(data);
        long checksum = this.m_crc.getValue();
        byte[] result = new byte[data.length + 4];
        System.arraycopy(new ZipLong(checksum).getBytes(), 0, result, 0, 4);
        System.arraycopy(data, 0, result, 4, data.length);
        return result;
    }

    public ZipShort getLocalFileDataLength() {
        return new ZipShort(14 + this.getLinkedFile().getBytes().length);
    }

    public int getMode() {
        return this.m_mode;
    }

    public int getUserId() {
        return this.m_uid;
    }

    public int getUserID() {
        return this.m_uid;
    }

    public boolean isDirectory() {
        return this.m_dirFlag && !this.isLink();
    }

    public boolean isLink() {
        return this.getLinkedFile().length() != 0;
    }

    public void parseFromLocalFileData(byte[] buffer, int offset, int length) throws ZipException {
        long givenChecksum = new ZipLong(buffer, offset).getValue();
        byte[] tmp = new byte[length - 4];
        System.arraycopy(buffer, offset + 4, tmp, 0, length - 4);
        this.m_crc.reset();
        this.m_crc.update(tmp);
        long realChecksum = this.m_crc.getValue();
        if (givenChecksum != realChecksum) {
            throw new ZipException("bad CRC checksum " + Long.toHexString(givenChecksum) + " instead of " + Long.toHexString(realChecksum));
        }
        int newMode = new ZipShort(tmp, 0).getValue();
        byte[] linkArray = new byte[(int)new ZipLong(tmp, 2).getValue()];
        this.m_uid = new ZipShort(tmp, 6).getValue();
        this.m_gid = new ZipShort(tmp, 8).getValue();
        if (linkArray.length == 0) {
            this.m_link = "";
        } else {
            System.arraycopy(tmp, 10, linkArray, 0, linkArray.length);
            this.m_link = new String(linkArray);
        }
        this.setDirectory((newMode & 0x4000) != 0);
        this.setMode(newMode);
    }

    protected int getMode(int mode) {
        int type = 32768;
        if (this.isLink()) {
            type = 40960;
        } else if (this.isDirectory()) {
            type = 16384;
        }
        return type | mode & 0xFFF;
    }
}

