/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan;

import eu.trentorise.opendata.commons.TodUtils;
import eu.trentorise.opendata.commons.validation.Preconditions;
import eu.trentorise.opendata.jackan.CkanClient;
import eu.trentorise.opendata.jackan.exceptions.CkanNotFoundException;
import eu.trentorise.opendata.jackan.exceptions.CkanValidationException;
import eu.trentorise.opendata.jackan.model.CkanDataset;
import eu.trentorise.opendata.jackan.model.CkanDatasetBase;
import eu.trentorise.opendata.jackan.model.CkanGroup;
import eu.trentorise.opendata.jackan.model.CkanLicense;
import eu.trentorise.opendata.jackan.model.CkanOrganization;
import eu.trentorise.opendata.jackan.model.CkanResource;
import eu.trentorise.opendata.jackan.model.CkanResourceBase;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class CheckedCkanClient
extends CkanClient {
    protected CheckedCkanClient() {
    }

    protected CheckedCkanClient(String url) {
        super(url);
    }

    public CheckedCkanClient(String catalogUrl, @Nullable String ckanToken) {
        super(catalogUrl, ckanToken);
    }

    public static CkanClient.Builder builder() {
        return CkanClient.newBuilder(new CheckedCkanClient());
    }

    private void checkUrl(String url, String prependedErrorMessage) {
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new CkanValidationException(String.valueOf(prependedErrorMessage) + " -- Ill-formed url:" + url, this, ex);
        }
    }

    private void checkUuid(String uuid, String prependedErrorMessage) {
        try {
            UUID.fromString(uuid);
        }
        catch (Exception ex) {
            throw new CkanValidationException(String.valueOf(prependedErrorMessage) + " -- Ill-formed uuid:" + uuid, this, ex);
        }
    }

    @Override
    public synchronized CkanOrganization createOrganization(CkanOrganization org) {
        if (org.getId() != null) {
            this.checkUuid(org.getId(), "Jackan validation failed! Tried to create organization with invalid id:" + org.getId());
            try {
                this.getOrganization(org.getId());
                throw new CkanValidationException("Jackan validation failed! Tried to create organization with existing id! " + org.getId(), this);
            }
            catch (CkanNotFoundException ckanNotFoundException) {
                // empty catch block
            }
        }
        return super.createOrganization(org);
    }

    @Override
    public synchronized CkanResource createResource(CkanResourceBase resource) {
        if (resource.getId() != null) {
            this.checkUuid(resource.getId(), "Jackan validation failed! Tried to create resource with invalid id:" + resource.getId());
            try {
                this.getResource(resource.getId());
                throw new CkanValidationException("Jackan validation failed! Tried to create resource with existing id! " + resource.getId(), this);
            }
            catch (CkanNotFoundException ckanNotFoundException) {
                // empty catch block
            }
        }
        this.checkUrl(resource.getUrl(), "Jackan validation error! Tried to create resource " + resource.getId() + " with wrong url!");
        return super.createResource(resource);
    }

    @Override
    public synchronized CkanResource updateResource(CkanResourceBase resource) {
        this.checkUrl(resource.getUrl(), "Jackan validation error! Tried to update resource " + resource.getId() + " with wrong url!");
        return super.updateResource(resource);
    }

    @Override
    public synchronized CkanResource patchUpdateResource(CkanResourceBase resource) {
        this.checkUrl(resource.getUrl(), "Jackan validation error! Tried to patch update resource " + resource.getId() + " with wrong url!");
        return super.patchUpdateResource(resource);
    }

    @Override
    public synchronized CkanGroup createGroup(CkanGroup group) {
        if (group.getId() != null) {
            this.checkUuid(group.getId(), "Jackan validation failed! Tried to create group with invalid id:" + group.getId());
            try {
                this.getGroup(group.getId());
                throw new CkanValidationException("Jackan validation failed! Tried to create group with existing id! " + group.getId(), this);
            }
            catch (CkanNotFoundException ckanNotFoundException) {
                // empty catch block
            }
        }
        return super.createGroup(group);
    }

    private void checkGroupsExist(Iterable<CkanGroup> groups, String prependedErrorMessage) {
        if (groups != null) {
            for (CkanGroup group : groups) {
                com.google.common.base.Preconditions.checkNotNull((Object)group, (Object)(String.valueOf(prependedErrorMessage) + " -- Found null group! "));
                Preconditions.checkNotEmpty((String)group.idOrName(), (Object)(String.valueOf(prependedErrorMessage) + " -- Found group with both id and name invalid!"));
                try {
                    this.getGroup(group.idOrName());
                }
                catch (CkanNotFoundException ex) {
                    throw new CkanValidationException(prependedErrorMessage + " -- Tried to refer to non existing group " + group.idOrName(), this, ex);
                }
            }
        }
    }

    private void checkLicenseExist(@Nullable String licenseId, String prependedErrorMessage) {
        if (TodUtils.isNotEmpty((String)licenseId)) {
            List<CkanLicense> licenseList = this.getLicenseList();
            boolean found = false;
            for (CkanLicense lic : licenseList) {
                if (!licenseId.equals(lic.getId())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new CkanValidationException(String.valueOf(prependedErrorMessage) + " -- licenseId '" + licenseId + "' doesn't belong to allowed licenses: " + licenseList.toString(), this);
            }
        }
    }

    @Override
    public synchronized CkanDataset createDataset(CkanDatasetBase dataset) {
        this.checkGroupsExist(dataset.getGroups(), "Jackan validation error when creating dataset " + dataset.getName());
        this.checkLicenseExist(dataset.getLicenseId(), "Jackan validation error when creating dataset " + dataset.getName());
        return super.createDataset(dataset);
    }

    @Override
    public synchronized CkanDataset updateDataset(CkanDatasetBase dataset) {
        this.checkGroupsExist(dataset.getGroups(), "Jackan validation error when updating dataset " + dataset.getName());
        this.checkLicenseExist(dataset.getLicenseId(), "Jackan validation error updating dataset " + dataset.getName());
        return super.updateDataset(dataset);
    }

    @Override
    public synchronized CkanDataset patchUpdateDataset(CkanDatasetBase dataset) {
        this.checkGroupsExist(dataset.getGroups(), "Jackan validation error when patch updating dataset " + dataset.getName());
        this.checkLicenseExist(dataset.getLicenseId(), "Jackan validation error when patch updating dataset " + dataset.getName());
        return super.patchUpdateDataset(dataset);
    }
}

