/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import eu.trentorise.opendata.commons.TodUtils;
import eu.trentorise.opendata.commons.validation.Preconditions;
import eu.trentorise.opendata.jackan.ApiVersionResponse;
import eu.trentorise.opendata.jackan.CkanQuery;
import eu.trentorise.opendata.jackan.DatasetListResponse;
import eu.trentorise.opendata.jackan.DatasetResponse;
import eu.trentorise.opendata.jackan.DatasetSearchResponse;
import eu.trentorise.opendata.jackan.FormatListResponse;
import eu.trentorise.opendata.jackan.GroupListResponse;
import eu.trentorise.opendata.jackan.GroupNamesResponse;
import eu.trentorise.opendata.jackan.GroupResponse;
import eu.trentorise.opendata.jackan.JackanModule;
import eu.trentorise.opendata.jackan.LicenseListResponse;
import eu.trentorise.opendata.jackan.OrganizationListResponse;
import eu.trentorise.opendata.jackan.OrganizationResponse;
import eu.trentorise.opendata.jackan.ResourceResponse;
import eu.trentorise.opendata.jackan.SearchResults;
import eu.trentorise.opendata.jackan.TagListResponse;
import eu.trentorise.opendata.jackan.TagNamesResponse;
import eu.trentorise.opendata.jackan.TagResponse;
import eu.trentorise.opendata.jackan.UserListResponse;
import eu.trentorise.opendata.jackan.UserResponse;
import eu.trentorise.opendata.jackan.VocabularyResponse;
import eu.trentorise.opendata.jackan.exceptions.CkanException;
import eu.trentorise.opendata.jackan.exceptions.CkanNotFoundException;
import eu.trentorise.opendata.jackan.exceptions.CkanValidationException;
import eu.trentorise.opendata.jackan.exceptions.JackanException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpHost;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.fluent.Request;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.fluent.Response;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.utils.URIUtils;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.ContentType;
import eu.trentorise.opendata.jackan.model.CkanDataset;
import eu.trentorise.opendata.jackan.model.CkanDatasetBase;
import eu.trentorise.opendata.jackan.model.CkanDatasetRelationship;
import eu.trentorise.opendata.jackan.model.CkanGroup;
import eu.trentorise.opendata.jackan.model.CkanGroupOrgBase;
import eu.trentorise.opendata.jackan.model.CkanLicense;
import eu.trentorise.opendata.jackan.model.CkanOrganization;
import eu.trentorise.opendata.jackan.model.CkanPair;
import eu.trentorise.opendata.jackan.model.CkanResource;
import eu.trentorise.opendata.jackan.model.CkanResourceBase;
import eu.trentorise.opendata.jackan.model.CkanResponse;
import eu.trentorise.opendata.jackan.model.CkanTag;
import eu.trentorise.opendata.jackan.model.CkanTagBase;
import eu.trentorise.opendata.jackan.model.CkanUser;
import eu.trentorise.opendata.jackan.model.CkanUserBase;
import eu.trentorise.opendata.jackan.model.CkanVocabulary;
import eu.trentorise.opendata.jackan.model.CkanVocabularyBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class CkanClient {
    public static final String CKAN_TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
    public static final String CKAN_NO_MILLISECS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final ImmutableList<Integer> SUPPORTED_API_VERSIONS = ImmutableList.of((Object)3);
    public static final int DEFAULT_TIMEOUT = 15000;
    public static final String NONE = "None";
    private static final Logger LOG = Logger.getLogger(CkanClient.class.getName());
    private static final String COULDNT_JSONIZE = "Couldn't jsonize the provided ";
    @Nullable
    private static ObjectMapper objectMapper;
    private static final Map<String, ObjectMapper> OBJECT_MAPPERS_FOR_POSTING;
    private String catalogUrl = "";
    @Nullable
    private String ckanToken;
    @Nullable
    private HttpHost proxy;
    private int timeout = 15000;

    public static void configureObjectMapper(ObjectMapper om) {
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.registerModule((Module)new JackanModule());
    }

    public static void configureObjectMapperForPosting(ObjectMapper om, Class clazz) {
        CkanClient.configureObjectMapper(om);
        om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        om.addMixInAnnotations(CkanResource.class, CkanResourceForPosting.class);
        om.addMixInAnnotations(CkanDataset.class, CkanDatasetForPosting.class);
        om.addMixInAnnotations(CkanOrganization.class, CkanGroupOrgForPosting.class);
        if (CkanDatasetBase.class.isAssignableFrom(clazz)) {
            om.addMixInAnnotations(CkanGroup.class, GroupForDatasetPosting.class);
        } else {
            om.addMixInAnnotations(CkanGroup.class, CkanGroupOrgForPosting.class);
        }
        om.addMixInAnnotations(CkanUser.class, CkanUserForPosting.class);
        om.addMixInAnnotations(CkanTag.class, CkanTagForPosting.class);
    }

    static ObjectMapper getObjectMapperForPosting(Class clazz) {
        com.google.common.base.Preconditions.checkNotNull((Object)clazz, (Object)"Invalid class! If you don't know the class just use Object.class");
        if (OBJECT_MAPPERS_FOR_POSTING.get(clazz.getName()) == null) {
            LOG.log(Level.FINE, "Generating ObjectMapper for posting class {0}", clazz);
            ObjectMapper om = new ObjectMapper();
            CkanClient.configureObjectMapperForPosting(om, clazz);
            OBJECT_MAPPERS_FOR_POSTING.put(clazz.getName(), om);
        }
        return OBJECT_MAPPERS_FOR_POSTING.get(clazz.getName());
    }

    static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            CkanClient.configureObjectMapper(objectMapper);
        }
        return objectMapper;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected CkanClient() {
    }

    public CkanClient(String catalogUrl) {
        this();
        Preconditions.checkNotEmpty((String)catalogUrl, (Object)"invalid ckan catalog url");
        this.catalogUrl = TodUtils.removeTrailingSlash((String)catalogUrl);
    }

    public CkanClient(String catalogUrl, @Nullable String ckanToken) {
        this(catalogUrl);
        this.ckanToken = ckanToken;
    }

    public static Builder builder() {
        return new Builder(new CkanClient());
    }

    public String toString() {
        String maskedToken = this.ckanToken == null ? null : "*****MASKED_TOKEN*******";
        return "CkanClient{catalogURL=" + this.catalogUrl + ", ckanToken=" + maskedToken + '}';
    }

    private String calcFullUrl(String path, Object[] params) {
        com.google.common.base.Preconditions.checkNotNull((Object)path);
        try {
            StringBuilder sb = new StringBuilder().append(this.catalogUrl).append(path);
            for (int i = 0; i < params.length; i += 2) {
                sb.append(i == 0 ? "?" : "&").append(URLEncoder.encode(params[i].toString(), "UTF-8")).append("=").append(URLEncoder.encode(params[i + 1].toString(), "UTF-8"));
            }
            return sb.toString();
        }
        catch (Exception ex) {
            throw new JackanException("Error while building url to perform GET! \n path: " + path + " \n params: " + Arrays.toString(params), ex);
        }
    }

    protected Request configureRequest(Request request) {
        if (this.ckanToken != null) {
            request.addHeader("Authorization", this.ckanToken);
        }
        if (this.proxy != null) {
            request.viaProxy(this.proxy);
        }
        request.socketTimeout(this.timeout).connectTimeout(this.timeout);
        return request;
    }

    private <T extends CkanResponse> T getHttp(Class<T> responseType, String path, Object ... params) {
        CkanResponse ckanResponse;
        String returnedText;
        com.google.common.base.Preconditions.checkNotNull(responseType);
        com.google.common.base.Preconditions.checkNotNull((Object)path);
        String fullUrl = this.calcFullUrl(path, params);
        try {
            LOG.log(Level.FINE, "getting {0}", fullUrl);
            Request request = Request.Get(fullUrl);
            this.configureRequest(request);
            Response response = request.execute();
            InputStream stream = response.returnResponse().getEntity().getContent();
            try (InputStreamReader reader = new InputStreamReader(stream, Charsets.UTF_8);){
                returnedText = CharStreams.toString((Readable)reader);
            }
        }
        catch (Exception ex) {
            throw new CkanException("Error while performing GET. Request url was: " + fullUrl, this, ex);
        }
        try {
            ckanResponse = (CkanResponse)CkanClient.getObjectMapper().readValue(returnedText, responseType);
        }
        catch (Exception ex) {
            throw new CkanException("Couldn't interpret json returned by the server! Returned text was: " + returnedText, this, ex);
        }
        if (!ckanResponse.isSuccess()) {
            this.throwCkanException("Error while performing GET. Request url was: " + fullUrl, ckanResponse);
        }
        return (T)ckanResponse;
    }

    protected <T extends CkanResponse> void throwCkanException(String msg, T ckanResponse) {
        if (ckanResponse.getError() != null && ckanResponse.getError().getType() != null) {
            switch (ckanResponse.getError().getType()) {
                case "Not Found Error": {
                    throw new CkanNotFoundException(msg, ckanResponse, this);
                }
                case "Validation Error": {
                    throw new CkanValidationException(msg, ckanResponse, this);
                }
            }
        }
        throw new CkanException(msg, ckanResponse, this);
    }

    private <T extends CkanResponse> T postHttp(Class<T> responseType, String path, String body, ContentType contentType, Object ... params) {
        CkanResponse ckanResponse;
        String returnedText;
        com.google.common.base.Preconditions.checkNotNull(responseType);
        com.google.common.base.Preconditions.checkNotNull((Object)path);
        com.google.common.base.Preconditions.checkNotNull((Object)body);
        com.google.common.base.Preconditions.checkNotNull((Object)contentType);
        String fullUrl = this.calcFullUrl(path, params);
        try {
            LOG.log(Level.FINE, "Posting to url {0}", fullUrl);
            LOG.log(Level.FINE, "Sending body:{0}", body);
            Request request = Request.Post(fullUrl);
            this.configureRequest(request);
            Response response = request.bodyString(body, contentType).execute();
            InputStream stream = response.returnResponse().getEntity().getContent();
            try (InputStreamReader reader = new InputStreamReader(stream, Charsets.UTF_8);){
                returnedText = CharStreams.toString((Readable)reader);
            }
        }
        catch (Exception ex) {
            throw new CkanException("Error while performing a POST! Request url is:" + fullUrl, this, ex);
        }
        try {
            ckanResponse = (CkanResponse)CkanClient.getObjectMapper().readValue(returnedText, responseType);
        }
        catch (Exception ex) {
            throw new CkanException("Couldn't interpret json returned by the server! Returned text was: " + returnedText, this, ex);
        }
        if (!ckanResponse.isSuccess()) {
            this.throwCkanException("Error while performing a POST! Request url is:" + fullUrl, ckanResponse);
        }
        return (T)ckanResponse;
    }

    public String getCatalogUrl() {
        return this.catalogUrl;
    }

    public String getCkanToken() {
        return this.ckanToken;
    }

    private static void checkCatalogUrl(String catalogUrl) {
        Preconditions.checkNotEmpty((String)catalogUrl, (Object)"invalid catalog url");
    }

    public static String makeDatasetUrl(String catalogUrl, String datasetIdOrName) {
        CkanClient.checkCatalogUrl(catalogUrl);
        Preconditions.checkNotEmpty((String)datasetIdOrName, (Object)"invalid dataset identifier");
        return TodUtils.removeTrailingSlash((String)catalogUrl) + "/dataset/" + datasetIdOrName;
    }

    public static String makeResourceUrl(String catalogUrl, String datasetIdOrName, String resourceId) {
        CkanClient.checkCatalogUrl(catalogUrl);
        Preconditions.checkNotEmpty((String)datasetIdOrName, (Object)"invalid dataset identifier");
        Preconditions.checkNotEmpty((String)resourceId, (Object)"invalid resource id");
        return TodUtils.removeTrailingSlash((String)catalogUrl) + "/" + datasetIdOrName + "/resource/" + resourceId;
    }

    public static String makeGroupUrl(String catalogUrl, String groupNameOrId) {
        CkanClient.checkCatalogUrl(catalogUrl);
        Preconditions.checkNotEmpty((String)groupNameOrId, (Object)"invalid group identifier");
        return TodUtils.removeTrailingSlash((String)catalogUrl) + "/group/" + groupNameOrId;
    }

    public static String makeOrganizationUrl(String catalogUrl, String orgNameOrId) {
        CkanClient.checkCatalogUrl(catalogUrl);
        Preconditions.checkNotEmpty((String)orgNameOrId, (Object)"invalid organization identifier");
        return TodUtils.removeTrailingSlash((String)catalogUrl) + "/organization/" + orgNameOrId;
    }

    public synchronized List<String> getDatasetList() {
        return this.getHttp(DatasetListResponse.class, (String)"/api/3/action/package_list", (Object[])new Object[0]).result;
    }

    public synchronized List<String> getDatasetList(int limit, int offset) {
        return this.getHttp(DatasetListResponse.class, (String)"/api/3/action/package_list", (Object[])new Object[]{"limit", Integer.valueOf((int)limit), "offset", Integer.valueOf((int)offset)}).result;
    }

    public synchronized List<CkanLicense> getLicenseList() {
        return this.getHttp(LicenseListResponse.class, (String)"/api/3/action/license_list", (Object[])new Object[0]).result;
    }

    public synchronized int getApiVersion() {
        for (int i = 5; i >= 1; --i) {
            try {
                return this.getApiVersion(i);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new CkanException("Error while getting api version!", this);
    }

    private synchronized int getApiVersion(int number) {
        String fullUrl = this.catalogUrl + "/api/" + number;
        LOG.log(Level.FINE, "getting {0}", fullUrl);
        try {
            Request request = Request.Get(fullUrl);
            this.configureRequest(request);
            String json = request.execute().returnContent().asString();
            return ((ApiVersionResponse)CkanClient.getObjectMapper().readValue((String)json, ApiVersionResponse.class)).version;
        }
        catch (Exception ex) {
            throw new CkanException("Error while fetching api version!", this, ex);
        }
    }

    public synchronized CkanDataset getDataset(String idOrName) {
        com.google.common.base.Preconditions.checkNotNull((Object)idOrName, (Object)"Need a valid id or name!");
        CkanDataset cd = this.getHttp(DatasetResponse.class, (String)"/api/3/action/package_show", (Object[])new Object[]{"id", idOrName}).result;
        for (CkanResource cr : cd.getResources()) {
            cr.setPackageId(cd.getId());
        }
        return cd;
    }

    public synchronized List<CkanUser> getUserList() {
        return this.getHttp(UserListResponse.class, (String)"/api/3/action/user_list", (Object[])new Object[0]).result;
    }

    public synchronized CkanUser getUser(String id) {
        com.google.common.base.Preconditions.checkNotNull((Object)id, (Object)"Need a valid id!");
        return this.getHttp(UserResponse.class, (String)"/api/3/action/user_show", (Object[])new Object[]{"id", id}).result;
    }

    public synchronized CkanUser createUser(CkanUserBase user) {
        com.google.common.base.Preconditions.checkNotNull((Object)user, (Object)"Need a valid user!");
        this.checkToken("Tried to create user" + user.getName());
        ObjectMapper om = CkanClient.getObjectMapperForPosting(CkanUserBase.class);
        String json = null;
        try {
            json = om.writeValueAsString((Object)user);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + user.getClass().getSimpleName(), this, e);
        }
        return this.postHttp(UserResponse.class, (String)"/api/3/action/user_create", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public synchronized CkanResource getResource(String id) {
        com.google.common.base.Preconditions.checkNotNull((Object)id, (Object)"Need a valid id!");
        return this.getHttp(ResourceResponse.class, (String)"/api/3/action/resource_show", (Object[])new Object[]{"id", id}).result;
    }

    public synchronized CkanResource createResource(CkanResourceBase resource) {
        com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Need a valid resource!");
        this.checkToken("Tried to create resource " + resource.getName());
        ObjectMapper om = CkanClient.getObjectMapperForPosting(CkanResourceBase.class);
        String json = null;
        try {
            json = om.writeValueAsString((Object)resource);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + resource.getClass().getSimpleName(), this, e);
        }
        return this.postHttp(ResourceResponse.class, (String)"/api/3/action/resource_create", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public synchronized CkanResource updateResource(CkanResourceBase resource) {
        com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Need a valid resource!");
        this.checkToken("Tried to update resource" + resource.getName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanResourceBase.class).writeValueAsString((Object)resource);
        }
        catch (IOException ex) {
            throw new CkanException(COULDNT_JSONIZE + resource.getClass().getSimpleName(), this, ex);
        }
        return this.postHttp(ResourceResponse.class, (String)"/api/3/action/resource_update", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public synchronized CkanResource patchUpdateResource(CkanResourceBase resource) {
        com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Need a valid resource!");
        this.checkToken("Tried to update resource" + resource.getName());
        CkanResource origResource = this.getResource(resource.getId());
        HashMap<String, Object> newOthers = new HashMap<String, Object>();
        if (origResource.getOthers() != null) {
            newOthers.putAll(origResource.getOthers());
        }
        if (resource.getOthers() != null) {
            newOthers.putAll(resource.getOthers());
        }
        resource.setOthers(newOthers);
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanResourceBase.class).writeValueAsString((Object)resource);
        }
        catch (IOException ex) {
            throw new CkanException(COULDNT_JSONIZE + resource.getClass().getSimpleName(), this, ex);
        }
        return this.postHttp(ResourceResponse.class, (String)"/api/3/action/resource_update", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public synchronized void deleteResource(String id) {
        com.google.common.base.Preconditions.checkNotNull((Object)id, (Object)"Need a valid id!");
        this.checkToken("Tried to delete resource with id " + id);
        String json = "{\"id\":\"" + id + "\"}";
        this.postHttp(ResourceResponse.class, "/api/3/action/resource_delete", json, ContentType.APPLICATION_JSON, new Object[0]);
    }

    public synchronized List<CkanGroup> getGroupList() {
        return this.getHttp(GroupListResponse.class, (String)"/api/3/action/group_list", (Object[])new Object[]{"all_fields", "True"}).result;
    }

    public synchronized List<String> getGroupNames() {
        return this.getHttp(GroupNamesResponse.class, (String)"/api/3/action/group_list", (Object[])new Object[0]).result;
    }

    public synchronized CkanGroup getGroup(String idOrName) {
        com.google.common.base.Preconditions.checkNotNull((Object)idOrName, (Object)"Need a valid id or name!");
        return this.getHttp(GroupResponse.class, (String)"/api/3/action/group_show", (Object[])new Object[]{"id", idOrName, "include_datasets", "false"}).result;
    }

    public synchronized List<CkanOrganization> getOrganizationList() {
        return this.getHttp(OrganizationListResponse.class, (String)"/api/3/action/organization_list", (Object[])new Object[]{"all_fields", "True"}).result;
    }

    public synchronized Set<String> getFormats() {
        return this.getHttp(FormatListResponse.class, (String)"/api/3/action/format_autocomplete", (Object[])new Object[]{"q", "", "limit", "1000"}).result;
    }

    public synchronized List<String> getOrganizationNames() {
        return this.getHttp(GroupNamesResponse.class, (String)"/api/3/action/organization_list", (Object[])new Object[0]).result;
    }

    public synchronized CkanOrganization getOrganization(String idOrName) {
        com.google.common.base.Preconditions.checkNotNull((Object)idOrName, (Object)"Need a valid id or name!");
        return this.getHttp(OrganizationResponse.class, (String)"/api/3/action/organization_show", (Object[])new Object[]{"id", idOrName, "include_datasets", "false"}).result;
    }

    public synchronized CkanTag createTag(CkanTagBase tag) {
        com.google.common.base.Preconditions.checkNotNull((Object)tag, (Object)"Need a valid tag!");
        this.checkToken("Tried to create tag" + tag.getName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanTagBase.class).writeValueAsString((Object)tag);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + tag.getClass().getSimpleName(), this, e);
        }
        TagResponse response = this.postHttp(TagResponse.class, "/api/3/action/tag_create", json, ContentType.APPLICATION_JSON, new Object[0]);
        return response.result;
    }

    public synchronized List<CkanTag> getTagList() {
        return this.getHttp(TagListResponse.class, (String)"/api/3/action/tag_list", (Object[])new Object[]{"all_fields", "True"}).result;
    }

    public synchronized List<String> getTagNamesList(String query) {
        com.google.common.base.Preconditions.checkNotNull((Object)query, (Object)"Need a valid query!");
        return this.getHttp(TagNamesResponse.class, (String)"/api/3/action/tag_list", (Object[])new Object[]{"query", query}).result;
    }

    public synchronized List<String> getTagNamesList() {
        return this.getHttp(TagNamesResponse.class, (String)"/api/3/action/tag_list", (Object[])new Object[0]).result;
    }

    public synchronized CkanVocabulary createVocabulary(CkanVocabularyBase vocabulary) {
        com.google.common.base.Preconditions.checkNotNull((Object)vocabulary, (Object)"Need a valid vocabulary!");
        this.checkToken("Tried to create vocabulary" + vocabulary.getName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanVocabularyBase.class).writeValueAsString((Object)vocabulary);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + vocabulary.getClass().getSimpleName(), this, e);
        }
        VocabularyResponse response = this.postHttp(VocabularyResponse.class, "/api/3/action/vocabulary_create", json, ContentType.APPLICATION_JSON, new Object[0]);
        return response.result;
    }

    public synchronized SearchResults<CkanDataset> searchDatasets(String text, int limit, int offset) {
        return this.searchDatasets(CkanQuery.filter().byText(text), limit, offset);
    }

    private static String appendNamesList(String fqPrefix, String key, List<String> list, StringBuilder fq) {
        com.google.common.base.Preconditions.checkNotNull((Object)fqPrefix, (Object)"Need a valid prefix!");
        com.google.common.base.Preconditions.checkNotNull((Object)key, (Object)"Need a valid key!");
        com.google.common.base.Preconditions.checkNotNull(list, (Object)"Need a valid list!");
        com.google.common.base.Preconditions.checkNotNull((Object)fq, (Object)"Need a valid string builder!");
        if (list.size() > 0) {
            fq.append(fqPrefix).append("(");
            String prefix = "";
            for (String n : list) {
                fq.append(prefix).append(key).append(":");
                fq.append('\"' + n + '\"');
                prefix = " AND ";
            }
            fq.append(")");
            return " AND ";
        }
        return "";
    }

    public static Timestamp parseTimestamp(String timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Found null timestamp!");
        }
        if (NONE.equals(timestamp)) {
            throw new IllegalArgumentException("Found timestamp with 'None' inside!");
        }
        return Timestamp.valueOf(timestamp.replace("T", " "));
    }

    @Nullable
    public static String formatTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Found null timestamp!");
        }
        Timestamp ret = Timestamp.valueOf(timestamp.toString());
        ret.setNanos(timestamp.getNanos() / 1000 * 1000);
        return Strings.padEnd((String)ret.toString().replace(" ", "T"), (int)"1970-01-01T01:00:00.000001".length(), (char)'0');
    }

    private static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            throw new JackanException("Unsupported encoding", ex);
        }
    }

    public synchronized SearchResults<CkanDataset> searchDatasets(CkanQuery query, int limit, int offset) {
        com.google.common.base.Preconditions.checkNotNull((Object)query, (Object)"Need a valid query!");
        StringBuilder params = new StringBuilder();
        params.append("rows=").append(limit).append("&start=").append(offset);
        if (query.getText().length() > 0) {
            params.append("&q=");
            params.append(CkanClient.urlEncode(query.getText()));
        }
        StringBuilder fq = new StringBuilder();
        String fqPrefix = "";
        fqPrefix = CkanClient.appendNamesList(fqPrefix, "groups", query.getGroupNames(), fq);
        fqPrefix = CkanClient.appendNamesList(fqPrefix, "organization", query.getOrganizationNames(), fq);
        fqPrefix = CkanClient.appendNamesList(fqPrefix, "tags", query.getTagNames(), fq);
        fqPrefix = CkanClient.appendNamesList(fqPrefix, "license_id", query.getLicenseIds(), fq);
        if (fq.length() > 0) {
            params.append("&fq=").append(CkanClient.urlEncode(fq.insert(0, "(").append(")").toString()));
        }
        DatasetSearchResponse dsr = this.getHttp(DatasetSearchResponse.class, "/api/3/action/package_search?" + params.toString(), new Object[0]);
        for (CkanDataset ds : dsr.result.getResults()) {
            for (CkanResource cr : ds.getResources()) {
                cr.setPackageId(ds.getId());
            }
        }
        return dsr.result;
    }

    private void checkToken(@Nullable String prependedErrorMessage) {
        if (this.ckanToken == null) {
            throw new CkanException(String.valueOf(prependedErrorMessage) + ", but ckan token was not set!", this);
        }
    }

    public synchronized CkanDataset createDataset(CkanDatasetBase dataset) {
        com.google.common.base.Preconditions.checkNotNull((Object)dataset, (Object)"Need a valid dataset!");
        this.checkToken("Tried to create dataset" + dataset.getName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanDatasetBase.class).writeValueAsString((Object)dataset);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + dataset.getClass().getSimpleName(), this, e);
        }
        DatasetResponse response = this.postHttp(DatasetResponse.class, "/api/3/action/package_create", json, ContentType.APPLICATION_JSON, new Object[0]);
        return response.result;
    }

    public synchronized CkanDataset updateDataset(CkanDatasetBase dataset) {
        com.google.common.base.Preconditions.checkNotNull((Object)dataset, (Object)"Need a valid dataset!");
        this.checkToken("Tried to update dataset" + dataset.getName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanDatasetBase.class).writeValueAsString((Object)dataset);
        }
        catch (IOException ex) {
            throw new CkanException(COULDNT_JSONIZE + dataset.getClass().getSimpleName(), this, ex);
        }
        return this.postHttp(DatasetResponse.class, (String)"/api/3/action/package_update", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public static List<CkanPair> extrasMapToList(Map<String, String> map) {
        ArrayList<CkanPair> ret = new ArrayList<CkanPair>();
        for (String key : map.keySet()) {
            ret.add(new CkanPair(key, map.get(key)));
        }
        return ret;
    }

    private void mergeResources(@Nullable List<CkanResource> resourcesToMerge, List<CkanResource> targetResources) {
        if (resourcesToMerge != null) {
            for (CkanResource resourceToMerge : resourcesToMerge) {
                boolean replaced = false;
                for (int i = 0; i < targetResources.size(); ++i) {
                    CkanResource targetRes = targetResources.get(i);
                    if (resourceToMerge.getId() == null || !resourceToMerge.getId().equals(targetRes.getId())) continue;
                    targetResources.set(i, resourceToMerge);
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                targetResources.add(resourceToMerge);
            }
        }
    }

    private void mergeGroups(@Nullable List<CkanGroup> groupsToMerge, List<CkanGroup> targetGroups) {
        if (groupsToMerge != null) {
            for (CkanGroup groupToMerge : groupsToMerge) {
                boolean replaced = false;
                for (int i = 0; i < targetGroups.size(); ++i) {
                    CkanGroup targetRes = targetGroups.get(i);
                    if (groupToMerge.getId() == null || !groupToMerge.getId().equals(targetRes.getId())) continue;
                    targetGroups.set(i, groupToMerge);
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                targetGroups.add(groupToMerge);
            }
        }
    }

    private void mergeRelationships(@Nullable List<CkanDatasetRelationship> relationshipsToMerge, List<CkanDatasetRelationship> targetDatasetRelationships) {
        if (relationshipsToMerge != null) {
            for (CkanDatasetRelationship relationshipToMerge : relationshipsToMerge) {
                boolean replaced = false;
                for (int i = 0; i < targetDatasetRelationships.size(); ++i) {
                    CkanDatasetRelationship targetRes = targetDatasetRelationships.get(i);
                    if (relationshipToMerge.getId() == null || !relationshipToMerge.getId().equals(targetRes.getId())) continue;
                    targetDatasetRelationships.set(i, relationshipToMerge);
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                targetDatasetRelationships.add(relationshipToMerge);
            }
        }
    }

    private void mergeTags(@Nullable List<CkanTag> tagsToMerge, List<CkanTag> targetTags) {
        if (tagsToMerge != null) {
            for (CkanTag tagToMerge : tagsToMerge) {
                boolean replaced = false;
                for (int i = 0; i < targetTags.size(); ++i) {
                    CkanTag targetRes = targetTags.get(i);
                    if (tagToMerge.getId() == null || !tagToMerge.getId().equals(targetRes.getId())) continue;
                    targetTags.set(i, tagToMerge);
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                targetTags.add(tagToMerge);
            }
        }
    }

    public synchronized CkanDataset patchUpdateDataset(CkanDatasetBase dataset) {
        com.google.common.base.Preconditions.checkNotNull((Object)dataset, (Object)"Need a valid dataset!");
        this.checkToken("Tried to patch update dataset" + dataset.getName());
        CkanDataset origDataset = this.getDataset(dataset.idOrName());
        HashMap<String, Object> newOthers = new HashMap<String, Object>();
        if (origDataset.getOthers() != null) {
            newOthers.putAll(origDataset.getOthers());
        }
        if (dataset.getOthers() != null) {
            newOthers.putAll(dataset.getOthers());
        }
        dataset.setOthers(newOthers);
        if (dataset.getExtras() == null) {
            dataset.setExtras(origDataset.getExtras());
        } else {
            HashMap<String, String> newExtras = new HashMap<String, String>();
            if (origDataset.getExtras() != null) {
                newExtras.putAll(origDataset.getExtrasAsHashMap());
            }
            if (dataset.getExtras() != null) {
                newExtras.putAll(dataset.getExtrasAsHashMap());
            }
            dataset.setExtras(CkanClient.extrasMapToList(newExtras));
        }
        ArrayList<CkanResource> newResources = new ArrayList<CkanResource>();
        this.mergeResources(origDataset.getResources(), newResources);
        this.mergeResources(dataset.getResources(), newResources);
        dataset.setResources(newResources);
        ArrayList<CkanGroup> newGroups = new ArrayList<CkanGroup>();
        this.mergeGroups(origDataset.getGroups(), newGroups);
        this.mergeGroups(dataset.getGroups(), newGroups);
        dataset.setGroups(newGroups);
        ArrayList<CkanTag> newTags = new ArrayList<CkanTag>();
        this.mergeTags(origDataset.getTags(), newTags);
        this.mergeTags(dataset.getTags(), newTags);
        dataset.setTags(newTags);
        ArrayList<CkanDatasetRelationship> newRelationshipsAsSubject = new ArrayList<CkanDatasetRelationship>();
        this.mergeRelationships(origDataset.getRelationshipsAsSubject(), newRelationshipsAsSubject);
        this.mergeRelationships(dataset.getRelationshipsAsSubject(), newRelationshipsAsSubject);
        dataset.setRelationshipsAsSubject(newRelationshipsAsSubject);
        ArrayList<CkanDatasetRelationship> newRelationshipsAsObject = new ArrayList<CkanDatasetRelationship>();
        this.mergeRelationships(origDataset.getRelationshipsAsObject(), newRelationshipsAsObject);
        this.mergeRelationships(dataset.getRelationshipsAsObject(), newRelationshipsAsObject);
        dataset.setRelationshipsAsObject(newRelationshipsAsObject);
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanDatasetBase.class).writeValueAsString((Object)dataset);
        }
        catch (IOException ex) {
            throw new JackanException(COULDNT_JSONIZE + dataset.getClass().getSimpleName(), ex);
        }
        return this.postHttp(DatasetResponse.class, (String)"/api/3/action/package_update", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public synchronized void deleteDataset(String nameOrId) {
        com.google.common.base.Preconditions.checkNotNull((Object)nameOrId, (Object)"Need a valid name or id!");
        this.checkToken("Tried to delete dataset" + nameOrId);
        String json = "{\"id\":\"" + nameOrId + "\"}";
        this.postHttp(CkanResponse.class, "/api/3/action/package_delete", json, ContentType.APPLICATION_JSON, new Object[0]);
    }

    public synchronized CkanOrganization createOrganization(CkanOrganization organization) {
        com.google.common.base.Preconditions.checkNotNull((Object)organization, (Object)("Need a valid " + organization + "!"));
        this.checkToken("Tried to create organization " + organization.getName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanOrganization.class).writeValueAsString((Object)organization);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + organization.getClass().getSimpleName(), this, e);
        }
        return this.postHttp(OrganizationResponse.class, (String)"/api/3/action/organization_create", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    public synchronized CkanGroup createGroup(CkanGroup group) {
        com.google.common.base.Preconditions.checkNotNull((Object)group, (Object)("Need a valid " + group + "!"));
        this.checkToken("Tried to create group " + group.idOrName());
        String json = null;
        try {
            json = CkanClient.getObjectMapperForPosting(CkanGroup.class).writeValueAsString((Object)group);
        }
        catch (IOException e) {
            throw new CkanException(COULDNT_JSONIZE + group.getClass().getSimpleName(), this, e);
        }
        return this.postHttp(GroupResponse.class, (String)"/api/3/action/group_create", (String)json, (ContentType)ContentType.APPLICATION_JSON, (Object[])new Object[0]).result;
    }

    @Nullable
    public String getProxy() {
        return this.proxy.toURI();
    }

    protected static Builder newBuilder(CkanClient client) {
        return new Builder(client);
    }

    static {
        OBJECT_MAPPERS_FOR_POSTING = new HashMap<String, ObjectMapper>();
    }

    public static class Builder {
        private CkanClient client;
        private boolean created;

        protected CkanClient getClient() {
            return this.client;
        }

        protected boolean getCreated() {
            return this.created;
        }

        protected void checkNotCreated() {
            if (this.created) {
                throw new IllegalStateException("Builder was already used to create a client!");
            }
        }

        protected Builder(CkanClient client) {
            com.google.common.base.Preconditions.checkNotNull((Object)client);
            this.client = client;
            this.created = false;
        }

        public Builder setCatalogUrl(String catalogUrl) {
            this.checkNotCreated();
            Preconditions.checkNotEmpty((String)catalogUrl, (Object)"invalid ckan catalog url");
            this.client.catalogUrl = TodUtils.removeTrailingSlash((String)catalogUrl);
            return this;
        }

        public Builder setCkanToken(@Nullable String ckanToken) {
            this.checkNotCreated();
            this.client.ckanToken = ckanToken;
            return this;
        }

        public Builder setProxy(@Nullable String proxyUrl) {
            this.checkNotCreated();
            if (proxyUrl == null) {
                this.client.proxy = null;
            } else {
                URI uri;
                try {
                    uri = new URI(proxyUrl.trim());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid proxy url!", e);
                }
                if (!uri.getPath().isEmpty()) {
                    throw new IllegalArgumentException("Proxy host shouldn't have context path! Found instead: " + uri.toString() + " with path " + uri.getPath());
                }
                this.client.proxy = URIUtils.extractHost(uri);
            }
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.checkNotCreated();
            com.google.common.base.Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Timeout must be > 0 ! Found instead %s", (Object[])new Object[]{timeout});
            this.client.timeout = timeout;
            return this;
        }

        public CkanClient build() {
            Preconditions.checkNotEmpty((String)this.client.catalogUrl, (Object)"Invalid catalog url!");
            this.created = true;
            return this.client;
        }
    }

    @JsonSerialize(as=CkanTagBase.class)
    private static abstract class CkanTagForPosting {
        private CkanTagForPosting() {
        }
    }

    @JsonSerialize(as=CkanUserBase.class)
    private static abstract class CkanUserForPosting {
        private CkanUserForPosting() {
        }
    }

    @JsonSerialize(as=GroupForDatasetPosting.class)
    static abstract class GroupForDatasetPosting
    extends CkanGroupOrgBase {
        GroupForDatasetPosting() {
        }

        @Override
        @JsonIgnore
        public List<CkanUser> getUsers() {
            return super.getUsers();
        }
    }

    @JsonSerialize(as=CkanGroupOrgBase.class)
    private static abstract class CkanGroupOrgForPosting {
        private CkanGroupOrgForPosting() {
        }
    }

    @JsonSerialize(as=CkanDatasetBase.class)
    private static abstract class CkanDatasetForPosting {
        private CkanDatasetForPosting() {
        }
    }

    @JsonSerialize(as=CkanResourceBase.class)
    private static abstract class CkanResourceForPosting {
        private CkanResourceForPosting() {
        }
    }
}

