/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CkanQuery {
    private String text = "";
    private List<String> groupNames = new ArrayList<String>();
    private List<String> organizationNames = new ArrayList<String>();
    private List<String> tagNames = new ArrayList<String>();
    private List<String> licenseIds = new ArrayList<String>();

    private CkanQuery() {
    }

    public CkanQuery byGroupNames(Iterable<String> groupNames) {
        this.groupNames = Lists.newArrayList(groupNames);
        return this;
    }

    public CkanQuery byGroupNames(String ... groupNames) {
        this.groupNames = Arrays.asList(groupNames);
        return this;
    }

    public CkanQuery byText(String text) {
        this.text = text;
        return this;
    }

    public CkanQuery byOrganizationName(String organizationName) {
        this.organizationNames = Lists.newArrayList((Object[])new String[]{organizationName});
        return this;
    }

    public CkanQuery byTagNames(Iterable<String> tagNames) {
        this.tagNames = Lists.newArrayList(tagNames);
        return this;
    }

    public CkanQuery byTagNames(String ... tagNames) {
        this.tagNames = Arrays.asList(tagNames);
        return this;
    }

    public CkanQuery byLicenseId(String licenseId) {
        this.licenseIds = Lists.newArrayList((Object[])new String[]{licenseId});
        return this;
    }

    public static CkanQuery filter() {
        return new CkanQuery();
    }

    public String getText() {
        return this.text;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public List<String> getOrganizationNames() {
        return this.organizationNames;
    }

    public List<String> getTagNames() {
        return this.tagNames;
    }

    public List<String> getLicenseIds() {
        return this.licenseIds;
    }
}

