/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import eu.trentorise.opendata.jackan.CkanClient;
import eu.trentorise.opendata.jackan.model.CkanDataset;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JackanModule
extends SimpleModule {
    private static final Logger LOG = Logger.getLogger(JackanModule.class.getName());

    public JackanModule() {
        this.setNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        this.addSerializer(Timestamp.class, (JsonSerializer)new StdSerializer<Timestamp>(Timestamp.class){

            public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                try {
                    String str = CkanClient.formatTimestamp(value);
                    jgen.writeString(str);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Couldn't format timestamp " + value + ", writing 'null'", ex);
                    jgen.writeNull();
                }
            }
        });
        this.addDeserializer(Timestamp.class, (JsonDeserializer)new JsonDeserializer<Timestamp>(){

            public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                JsonToken t = jp.getCurrentToken();
                if (t == JsonToken.VALUE_STRING) {
                    String str = jp.getText().trim();
                    try {
                        return CkanClient.parseTimestamp(str);
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.log(Level.SEVERE, "Couldn't parse timestamp " + str + ", returning null", ex);
                        return null;
                    }
                }
                if (t == JsonToken.VALUE_NULL) {
                    return null;
                }
                LOG.log(Level.SEVERE, "Unrecognized json token for timestamp {0}, returning null", t.asString());
                return null;
            }
        });
    }

    public static class GroupOrgPackagesDeserializer
    extends JsonDeserializer<List<CkanDataset>> {
        private static final Logger LOG = Logger.getLogger(GroupOrgPackagesDeserializer.class.getName());

        public List<CkanDataset> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return null;
            }
            if (t == JsonToken.START_ARRAY) {
                return (List)jp.readValueAs((TypeReference)new TypeReference<List<CkanDataset>>(){});
            }
            LOG.log(Level.SEVERE, "Unrecognized token {0} for 'packages' field, returning an empty array.", t.asString());
            return new ArrayList<CkanDataset>();
        }
    }
}

