/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.dcat;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.commons.PeriodOfTime;
import eu.trentorise.opendata.commons.TodUtils;
import eu.trentorise.opendata.commons.validation.Preconditions;
import eu.trentorise.opendata.jackan.CkanClient;
import eu.trentorise.opendata.jackan.exceptions.JackanException;
import eu.trentorise.opendata.jackan.exceptions.JackanNotFoundException;
import eu.trentorise.opendata.jackan.model.CkanDataset;
import eu.trentorise.opendata.jackan.model.CkanResource;
import eu.trentorise.opendata.jackan.model.CkanTag;
import eu.trentorise.opendata.traceprov.TraceProvModule;
import eu.trentorise.opendata.traceprov.dcat.AFoafAgent;
import eu.trentorise.opendata.traceprov.dcat.DcatDataset;
import eu.trentorise.opendata.traceprov.dcat.DcatDistribution;
import eu.trentorise.opendata.traceprov.dcat.FoafAgent;
import eu.trentorise.opendata.traceprov.dcat.SkosConcept;
import eu.trentorise.opendata.traceprov.dcat.SkosConceptScheme;
import eu.trentorise.opendata.traceprov.dcat.VCard;
import eu.trentorise.opendata.traceprov.geojson.Feature;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class DcatFactory {
    protected static final String ISSUED = "issued";
    protected static final String MODIFIED = "modified";
    protected static final String DESCRIPTION = "description";
    protected static final String URI_FIELD = "uri";
    protected static final String TITLE = "title";
    private Logger logger = Logger.getLogger(DcatFactory.class.getName());
    private ObjectMapper objectMapper = new ObjectMapper();

    public DcatFactory() {
        TraceProvModule.registerModulesInto((ObjectMapper)this.objectMapper);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        TraceProvModule.registerModulesInto((ObjectMapper)this.objectMapper);
    }

    protected String formatLanguages(Iterable<Locale> locales) {
        try {
            return this.objectMapper.writeValueAsString(locales);
        }
        catch (Exception ex) {
            throw new JackanException("Couldn't serialize locales! " + locales, ex);
        }
    }

    protected List<Locale> extractLanguages(CkanDataset dataset) {
        String string = this.extractFieldAsNonEmptyString(dataset, "language");
        try {
            return (List)this.objectMapper.readValue(string, (TypeReference)new TypeReference<List<Locale>>(){});
        }
        catch (Exception ex) {
            throw new JackanException("Couldn't deserialize locales: " + string, ex);
        }
    }

    protected String extractFieldAsNonEmptyString(CkanDataset dataset, String field) {
        String ret = this.extractFieldAsString(dataset, field).trim();
        if (ret.isEmpty()) {
            throw new JackanNotFoundException("Couldn't find valid non-empty field " + field + " in CkanDataset");
        }
        return ret;
    }

    protected String extractFieldAsNonEmptyString(CkanResource resource, String field) {
        String ret = this.extractFieldAsString(resource, field).trim();
        if (ret.isEmpty()) {
            throw new JackanNotFoundException("Couldn't find valid non-empty field " + field + " in CkanResource!");
        }
        return ret;
    }

    protected String extractFieldAsString(CkanDataset dataset, String field) {
        Object candidateObject;
        com.google.common.base.Preconditions.checkNotNull((Object)dataset);
        Preconditions.checkNotEmpty((String)field, (Object)"Invalid field to search!");
        String candidateString = null;
        if (dataset.getOthers() != null && (candidateObject = dataset.getOthers().get(field)) instanceof String) {
            candidateString = (String)candidateObject;
        }
        if (candidateString == null && dataset.getExtras() != null) {
            candidateString = dataset.getExtrasAsHashMap().get(field);
        }
        if (candidateString == null) {
            throw new JackanNotFoundException("Can't find string field " + field + "!");
        }
        return candidateString;
    }

    protected String extractFieldAsString(CkanResource resource, String field) {
        Object candidateObject;
        com.google.common.base.Preconditions.checkNotNull((Object)resource);
        Preconditions.checkNotEmpty((String)field, (Object)"Invalid field to search!");
        String candidateString = null;
        if (resource.getOthers() != null && (candidateObject = resource.getOthers().get(field)) instanceof String) {
            candidateString = (String)candidateObject;
        }
        if (candidateString == null) {
            throw new JackanNotFoundException("Can't find string field " + field + "!");
        }
        return candidateString;
    }

    protected Object extractFieldAsObject(CkanDataset dataset, String field) {
        com.google.common.base.Preconditions.checkNotNull((Object)dataset);
        Preconditions.checkNotEmpty((String)field, (Object)"Invalid field to search!");
        Object candidateObject = null;
        if (dataset.getOthers() != null) {
            candidateObject = dataset.getOthers().get(field);
        }
        if (candidateObject == null && dataset.getExtras() != null) {
            candidateObject = dataset.getExtrasAsHashMap().get(field);
        }
        if (candidateObject == null) {
            throw new JackanNotFoundException("Can't find object field " + field + "!");
        }
        return candidateObject;
    }

    protected <T> T extractField(CkanDataset dataset, String field, TypeReference<T> toType) {
        String json = this.extractFieldAsNonEmptyString(dataset, field);
        try {
            return (T)this.objectMapper.readValue(json, toType);
        }
        catch (Exception ex) {
            throw new JackanException("Error while extracting field " + field + " into type " + toType.toString(), ex);
        }
    }

    protected <T> T extractField(CkanDataset dataset, String field, Class<T> toClass) {
        String json = this.extractFieldAsNonEmptyString(dataset, field);
        try {
            return (T)this.objectMapper.readValue(json, toClass);
        }
        catch (Exception ex) {
            throw new JackanException("Error while extracting field " + field + " into class " + toClass, ex);
        }
    }

    protected String formatTimestamp(Timestamp timestamp) {
        return CkanClient.formatTimestamp(timestamp) + "Z";
    }

    private GeoJson calcGeoJson(String name, String description, String id, String spatialDump) {
        if (name.isEmpty() && description.isEmpty()) {
            throw new JackanNotFoundException("Could not find valid dataset spatial field nor natural language name!");
        }
        if (name.isEmpty() && !description.isEmpty()) {
            return Feature.builder().setProperties((Object)ImmutableMap.of((Object)DESCRIPTION, (Object)spatialDump)).setId(id).build();
        }
        this.logger.log(Level.INFO, "Putting found natural language name in Feature.properties['name']");
        if (!name.isEmpty() && description.isEmpty()) {
            return Feature.ofName((String)name).withId(id);
        }
        if (!name.isEmpty() && !description.isEmpty()) {
            return Feature.builder().setProperties((Object)ImmutableMap.of((Object)"name", (Object)name, (Object)DESCRIPTION, (Object)spatialDump)).setId(id).build();
        }
        throw new JackanException("Internal error, reached a supposedly unreachable place while extracting spatial attribute from CkanDataset.");
    }

    protected GeoJson extractSpatial(CkanDataset dataset) {
        String name = "";
        String description = "";
        String id = "";
        String spatial = "";
        GeoJson geoJson = null;
        try {
            id = this.extractFieldAsNonEmptyString(dataset, "spatial_uri").trim();
            this.logger.info("Found dataset 'spatial_uri' field, will set it to '@id' field of GeoJSON-LD");
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find dataset 'spatial_uri' field");
        }
        try {
            name = this.extractFieldAsNonEmptyString(dataset, "spatial_text").trim();
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find dataset 'spatial_text' field (should hold the natural language name of the place)");
        }
        try {
            spatial = this.extractFieldAsNonEmptyString(dataset, "spatial");
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Could not find dataset 'spatial' field");
        }
        if (!spatial.isEmpty()) {
            try {
                geoJson = (GeoJson)this.objectMapper.readValue(spatial, GeoJson.class);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error while parsing dataset 'spatial' field as GeoJson, will put the problematic json into Feature.properties['description'] ", ex);
                description = spatial;
            }
        }
        if (geoJson != null) {
            return geoJson;
        }
        return this.calcGeoJson(name, description, id, spatial);
    }

    protected List<SkosConcept> extractThemes(CkanDataset dataset, Locale locale, String catalogUrl) {
        List<String> candidateLabels;
        ArrayList<SkosConcept> ret = new ArrayList<SkosConcept>();
        try {
            candidateLabels = this.extractField(dataset, "theme", new TypeReference<List<String>>(){});
        }
        catch (JackanNotFoundException ex) {
            return ret;
        }
        for (String s : candidateLabels) {
            Dict prefLabel;
            String uri;
            String ts = s == null ? "" : s.trim();
            if (ts.isEmpty()) continue;
            try {
                URI.create(ts);
                uri = ts;
                prefLabel = Dict.of();
            }
            catch (Exception ex) {
                uri = "";
                prefLabel = Dict.of((Locale)locale, (String[])new String[]{ts});
            }
            ret.add(SkosConcept.of((SkosConceptScheme)SkosConceptScheme.of(), (Dict)prefLabel, (String)uri));
        }
        return ret;
    }

    protected String extractUri(CkanDataset dataset, String catalogUrl) {
        String uri = "";
        try {
            uri = this.extractFieldAsNonEmptyString(dataset, URI_FIELD);
        }
        catch (JackanNotFoundException jackanNotFoundException) {
            // empty catch block
        }
        if (DcatFactory.isTrimmedEmpty(uri)) {
            if (!DcatFactory.isTrimmedEmpty(dataset.getId())) {
                return CkanClient.makeDatasetUrl(catalogUrl, dataset.getId());
            }
            throw new JackanNotFoundException("Couldn't find any valid dataset uri!");
        }
        return uri;
    }

    protected PeriodOfTime extractTemporal(CkanDataset dataset) {
        String start = "";
        String end = "";
        try {
            start = this.extractFieldAsNonEmptyString(dataset, "temporal_start").trim();
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find valid dataset field 'temporal_start'");
        }
        try {
            end = this.extractFieldAsNonEmptyString(dataset, "temporal_end").trim();
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find valid dataset field 'temporal_end'");
        }
        if (start.isEmpty() && end.isEmpty()) {
            throw new JackanNotFoundException("Couldn't find any valid temporal information!");
        }
        try {
            return PeriodOfTime.of((String)start, (String)end);
        }
        catch (IllegalStateException ex) {
            this.logger.info("Couldn't find valid ISO8061 temporal_start/end fields, storing raw string.'");
            return PeriodOfTime.of((String)(start + "@joined@" + end));
        }
    }

    protected String extractIdentifier(CkanDataset dataset) {
        try {
            return this.extractFieldAsNonEmptyString(dataset, "identifier");
        }
        catch (JackanNotFoundException jackanNotFoundException) {
            try {
                return this.extractFieldAsNonEmptyString(dataset, "guid");
            }
            catch (JackanNotFoundException jackanNotFoundException2) {
                if (!DcatFactory.isTrimmedEmpty(dataset.getId())) {
                    return dataset.getId().trim();
                }
                throw new JackanNotFoundException("Couldn't find any valid identifier in the dataset!");
            }
        }
    }

    protected String extractIssued(CkanDataset dataset) {
        try {
            return this.extractFieldAsNonEmptyString(dataset, ISSUED);
        }
        catch (JackanNotFoundException ex) {
            if (dataset.getMetadataCreated() != null) {
                return CkanClient.formatTimestamp(dataset.getMetadataCreated());
            }
            throw new JackanNotFoundException("Couldn't find valid 'issued' field");
        }
    }

    protected String extractModified(CkanDataset dataset) {
        try {
            return this.extractFieldAsString(dataset, MODIFIED);
        }
        catch (JackanNotFoundException ex) {
            if (dataset.getMetadataModified() != null) {
                return CkanClient.formatTimestamp(dataset.getMetadataModified());
            }
            throw new JackanNotFoundException("Couldn't find valid 'modified' field");
        }
    }

    protected FoafAgent extractPublisher(CkanDataset dataset, Locale locale) {
        FoafAgent.Builder pubBuilder = FoafAgent.builder();
        try {
            pubBuilder.setUri(this.extractFieldAsNonEmptyString(dataset, "publisher_uri").trim());
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find valid field 'publisher_uri'");
        }
        try {
            pubBuilder.setName(Dict.of((Locale)locale, (String[])new String[]{this.extractFieldAsNonEmptyString(dataset, "publisher_name").trim()}));
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find valid field 'publisher_name'");
        }
        try {
            pubBuilder.setMbox(this.extractFieldAsNonEmptyString(dataset, "publisher_email").trim());
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find valid field 'publisher_email'");
            String candidateTitle = "";
            if (dataset.getOrganization() != null && dataset.getOrganization().getTitle() != null) {
                candidateTitle = dataset.getOrganization().getTitle().trim();
            }
            if (candidateTitle.isEmpty()) {
                this.logger.info("Couldn't find valid organization:title to use as publisher MBox");
            }
            pubBuilder.setMbox(candidateTitle);
        }
        try {
            pubBuilder.setHomepage(this.extractFieldAsNonEmptyString(dataset, "publisher_url").trim());
        }
        catch (JackanNotFoundException ex) {
            this.logger.info("Couldn't find valid field 'publisher_url' for publisher homepage");
        }
        FoafAgent ret = pubBuilder.build();
        if (ret.equals((Object)FoafAgent.of())) {
            throw new JackanNotFoundException("Couldn't find any valid field for a publisher!");
        }
        return ret;
    }

    protected VCard extractContactPoint(CkanDataset dataset) {
        String candidateContactEmail;
        VCard.Builder cpb;
        block14: {
            String candidateContactName;
            block13: {
                cpb = VCard.builder();
                try {
                    cpb.setUri(this.extractFieldAsNonEmptyString(dataset, "contact_uri"));
                }
                catch (JackanNotFoundException ex) {
                    this.logger.info("Couldn't find valid dataset contact uri, skipping it.");
                }
                candidateContactName = "";
                try {
                    candidateContactName = this.extractFieldAsNonEmptyString(dataset, "contact_name");
                }
                catch (JackanNotFoundException ex) {
                    if (dataset.getMaintainer() != null && !dataset.getMaintainer().trim().isEmpty()) {
                        candidateContactName = dataset.getMaintainer().trim();
                    }
                    if (dataset.getAuthor() == null || dataset.getAuthor().trim().isEmpty()) break block13;
                    candidateContactName = dataset.getAuthor().trim();
                }
            }
            if (candidateContactName.isEmpty()) {
                this.logger.info("Couldn't find valid dataset contact fn, skipping it.");
            } else {
                cpb.setFn(candidateContactName);
            }
            candidateContactEmail = "";
            try {
                candidateContactEmail = this.extractFieldAsNonEmptyString(dataset, "contact_email");
            }
            catch (JackanNotFoundException ex) {
                if (dataset.getMaintainer() != null && !dataset.getMaintainer().trim().isEmpty()) {
                    candidateContactEmail = dataset.getMaintainerEmail().trim();
                }
                if (dataset.getAuthor() == null || dataset.getAuthor().trim().isEmpty()) break block14;
                candidateContactEmail = dataset.getAuthorEmail().trim();
            }
        }
        if (candidateContactEmail.isEmpty()) {
            this.logger.info("Couldn't find valid dataset contact email, skipping it.");
        } else {
            cpb.setEmail(candidateContactEmail);
        }
        VCard ret = cpb.build();
        if (ret.equals((Object)VCard.of())) {
            throw new JackanNotFoundException("Couldn't find any valid contact info in dataset!");
        }
        return ret;
    }

    protected List<String> extractKeywords(CkanDataset dataset) {
        ArrayList<String> ret = new ArrayList<String>();
        if (dataset.getTags() == null) {
            throw new JackanNotFoundException("Found null tags!");
        }
        for (CkanTag tag : dataset.getTags()) {
            if (tag == null || DcatFactory.isTrimmedEmpty(tag.getName())) continue;
            ret.add(tag.getName().trim());
        }
        return ret;
    }

    protected static String trim(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    protected Dict extractTitle(CkanDataset dataset, Locale locale) {
        String s = DcatFactory.trim(dataset.getTitle());
        if (s.isEmpty()) {
            throw new JackanNotFoundException("Couldn't find valid title!");
        }
        return Dict.of((Locale)locale, (String[])new String[]{s});
    }

    protected Dict extractDescription(CkanDataset dataset, Locale locale) {
        String s = DcatFactory.trim(dataset.getNotes());
        if (s.isEmpty()) {
            throw new JackanNotFoundException("Couldn't find valid notes!");
        }
        return Dict.of((Locale)locale, (String[])new String[]{s});
    }

    protected String extractAccrualPeriodicity(CkanDataset dataset) {
        return this.extractFieldAsNonEmptyString(dataset, "frequency");
    }

    protected String extractLandingPage(CkanDataset dataset) {
        if (DcatFactory.isTrimmedEmpty(dataset.getUrl())) {
            throw new JackanNotFoundException("Couldn't find valid url field in dataset!");
        }
        return dataset.getUrl();
    }

    protected void logCantFind(String clazz, String attribute) {
        this.logger.log(Level.INFO, "Couldn''t find any valid " + clazz + " {0}, skipping it", attribute);
    }

    protected void logCantExtract(String clazz, String attribute, Throwable ex) {
        this.logger.log(Level.SEVERE, "Error while extracting " + clazz + " " + attribute + ", skipping it", ex);
    }

    protected void logDatasetCantFind(String attribute) {
        this.logCantFind("dataset", attribute);
    }

    protected void logDatasetCantExtract(String attribute, Throwable ex) {
        this.logCantExtract("dataset", attribute, ex);
    }

    @Beta
    public DcatDataset makeDataset(CkanDataset dataset, String catalogUrl, Locale locale) {
        DcatDataset.Builder ddb;
        String sanitizedCatalogUrl;
        block50: {
            this.logger.warning("CONVERSION FROM CKAN DATASET TO DCAT DATASET IS STILL EXPERIMENTAIL, IT MIGHT BE INCOMPLETE!!!");
            TodUtils.checkNotEmpty((String)catalogUrl, (Object)"invalid dcat dataset catalog URL");
            com.google.common.base.Preconditions.checkNotNull((Object)locale, (Object)"invalid dcat dataset locale");
            com.google.common.base.Preconditions.checkNotNull((Object)dataset, (Object)"Invalid dataset!");
            sanitizedCatalogUrl = TodUtils.removeTrailingSlash((String)catalogUrl);
            String sanitizedId = dataset.getId() == null ? "" : dataset.getId();
            String sanitizedLicenceId = dataset.getLicenseId() == null ? "" : dataset.getLicenseId();
            this.logger.warning("TODO - CONVERSION FROM CKAN DATASET TO DCAT DATASET IS STILL EXPERIMENTAL, IT MIGHT BE INCOMPLETE!!!");
            ddb = DcatDataset.builder();
            try {
                ddb.setAccrualPeriodicity(this.extractAccrualPeriodicity(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind("accrualPeriodicity");
            }
            catch (Exception ex) {
                this.logDatasetCantExtract("accrualPeriodicity", ex);
            }
            try {
                ddb.setContactPoint(this.extractContactPoint(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind("contactPoint");
            }
            catch (Exception ex) {
                this.logDatasetCantExtract("contactPoint", ex);
            }
            try {
                ddb.setDescription(this.extractDescription(dataset, locale));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind(DESCRIPTION);
            }
            catch (Exception ex) {
                this.logDatasetCantExtract(DESCRIPTION, ex);
            }
            if (dataset.getResources() != null) {
                for (CkanResource cr : dataset.getResources()) {
                    try {
                        ddb.addDistributions(this.makeDistribution(cr, sanitizedCatalogUrl, sanitizedId, sanitizedLicenceId, locale));
                    }
                    catch (Exception ex) {
                        this.logDatasetCantExtract("distribution", ex);
                    }
                }
            }
            try {
                ddb.setIdentifier(this.extractIdentifier(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind("identifier");
            }
            catch (Exception ex) {
                this.logDatasetCantExtract("identifier", ex);
            }
            try {
                ddb.setIssued(this.extractIssued(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind(ISSUED);
            }
            catch (Exception ex) {
                this.logDatasetCantExtract(ISSUED, ex);
            }
            try {
                ddb.setKeywords(this.extractKeywords(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind("keywords");
            }
            catch (Exception ex) {
                this.logDatasetCantExtract("keywords", ex);
            }
            try {
                ddb.setLandingPage(this.extractLandingPage(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind("landingPage");
            }
            catch (Exception ex) {
                this.logDatasetCantExtract("landingPage", ex);
            }
            try {
                ddb.setLanguages(this.extractLanguages(dataset));
            }
            catch (JackanNotFoundException ex) {
                this.logDatasetCantFind("language");
                if (!Locale.ROOT.equals(locale)) {
                    this.logger.log(Level.INFO, "Setting language field to provided locale {0}", locale);
                    ddb.addLanguages(locale);
                }
            }
            catch (Exception ex) {
                this.logDatasetCantExtract("language", ex);
                if (Locale.ROOT.equals(locale)) break block50;
                this.logger.log(Level.INFO, "Setting language field to provided locale {0}", locale);
                ddb.addLanguages(locale);
            }
        }
        try {
            ddb.setModified(this.extractModified(dataset));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind(MODIFIED);
        }
        catch (Exception ex) {
            this.logDatasetCantExtract(MODIFIED, ex);
        }
        try {
            ddb.setPublisher((AFoafAgent)this.extractPublisher(dataset, locale));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind("publisher");
        }
        catch (Exception ex) {
            this.logDatasetCantExtract("publisher", ex);
        }
        try {
            ddb.setSpatial(this.extractSpatial(dataset));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind("spatial");
        }
        catch (Exception ex) {
            this.logDatasetCantExtract("spatial", ex);
        }
        try {
            ddb.setTemporal(this.extractTemporal(dataset));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind("temporal");
        }
        catch (Exception ex) {
            this.logDatasetCantExtract("temporal", ex);
        }
        try {
            ddb.setThemes(this.extractThemes(dataset, locale, sanitizedCatalogUrl));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind("theme");
        }
        catch (Exception ex) {
            this.logDatasetCantExtract("theme", ex);
        }
        try {
            ddb.setTitle(this.extractTitle(dataset, locale));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind(TITLE);
        }
        catch (Exception ex) {
            this.logDatasetCantExtract(TITLE, ex);
        }
        try {
            ddb.setUri(this.extractUri(dataset, sanitizedCatalogUrl));
        }
        catch (JackanNotFoundException ex) {
            this.logDatasetCantFind(URI_FIELD);
        }
        catch (Exception ex) {
            this.logDatasetCantExtract(URI_FIELD, ex);
        }
        this.postProcessDataset(ddb, catalogUrl, locale);
        return ddb.build();
    }

    protected void postProcessDataset(DcatDataset.Builder datasetBuilder, String catalogUrl, Locale locale) {
    }

    protected void logDistribCantFind(String attribute) {
        this.logCantFind("distribution", attribute);
    }

    protected void logDistribCantExtract(String attribute, Throwable ex) {
        this.logCantExtract("distribution", attribute, ex);
    }

    protected String extractUri(CkanResource resource, String catalogUrl, String datasetId) {
        String candidateUri = "";
        try {
            candidateUri = this.extractFieldAsString(resource, URI_FIELD).trim();
        }
        catch (JackanNotFoundException jackanNotFoundException) {
            // empty catch block
        }
        if (candidateUri.isEmpty()) {
            if (TodUtils.isNotEmpty((String)catalogUrl) && TodUtils.isNotEmpty((String)datasetId) && TodUtils.isNotEmpty((String)resource.getId())) {
                return CkanClient.makeResourceUrl(catalogUrl, datasetId, resource.getId());
            }
            throw new JackanNotFoundException("Couldn't find valid 'uri' for resource!");
        }
        return candidateUri;
    }

    protected static boolean isTrimmedEmpty(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    protected void postProcessDistribution(DcatDistribution.Builder distributionBuilder, CkanResource resource, String catalogURL, String datasetId, String license, Locale locale) {
    }

    protected String extractModified(CkanResource resource) {
        return this.extractFieldAsString(resource, MODIFIED).trim();
    }

    protected String extractIssued(CkanResource resource) {
        return this.extractFieldAsString(resource, ISSUED).trim();
    }

    protected String extractAccessUrl(CkanResource resource) {
        if (!DcatFactory.isTrimmedEmpty(resource.getUrl())) {
            return resource.getUrl().trim();
        }
        throw new JackanNotFoundException("Couldn't find valid access url!");
    }

    protected String extractDownloadUrl(CkanResource resource) {
        return this.extractFieldAsNonEmptyString(resource, "download_url");
    }

    protected int extractByteSize(CkanResource resource) {
        if (DcatFactory.isTrimmedEmpty(resource.getSize())) {
            throw new JackanNotFoundException("Couldn't find valid size in resource!");
        }
        try {
            return Integer.parseInt(resource.getSize());
        }
        catch (NumberFormatException ex) {
            throw new JackanException("COULDN'T CONVERT CKAN RESOURCE SIZE TO DCAT! REQUIRED AN INTEGER, FOUND " + resource.getSize() + " (ALTHOUGH STRINGS ARE VALID CKAN SIZES)", ex);
        }
    }

    protected Dict extractDescription(CkanResource dataset, Locale locale) {
        String s = DcatFactory.trim(dataset.getDescription());
        if (s.isEmpty()) {
            throw new JackanNotFoundException("Couldn't find valid description!");
        }
        return Dict.of((Locale)locale, (String[])new String[]{s});
    }

    protected String extractFormat(CkanResource resource) {
        if (DcatFactory.isTrimmedEmpty(resource.getFormat())) {
            throw new JackanNotFoundException("Couldn't find a valid format!");
        }
        return resource.getFormat().trim();
    }

    protected String extractLicense(CkanResource resource, String license) {
        try {
            this.extractFieldAsNonEmptyString(resource, "license");
        }
        catch (JackanNotFoundException ex) {
            if (TodUtils.isNotEmpty((String)license)) {
                return license;
            }
            throw new JackanNotFoundException("Couldn't find valid license in resource!", ex);
        }
        if (DcatFactory.isTrimmedEmpty(license)) {
            throw new JackanNotFoundException("Couldn't find a valid license!");
        }
        return license.trim();
    }

    protected String extractMediaType(CkanResource resource) {
        if (DcatFactory.isTrimmedEmpty(resource.getMimetype())) {
            throw new JackanNotFoundException("Couldn't find a valid media type!");
        }
        return resource.getMimetype();
    }

    protected String extractRights(CkanResource resource) {
        return this.extractFieldAsNonEmptyString(resource, "rights");
    }

    protected Dict extractTitle(CkanResource resource, Locale locale) {
        if (DcatFactory.isTrimmedEmpty(resource.getName())) {
            this.logger.info("Couldn't find valid distribution title, skipping it");
            throw new JackanNotFoundException("Couldn't find a valid title!");
        }
        return Dict.of((Locale)locale, (String[])new String[]{resource.getName().trim()});
    }

    @Beta
    public DcatDistribution makeDistribution(CkanResource resource, String catalogURL, String datasetIdOrName, String license, Locale locale) {
        this.logger.warning("CONVERSION FROM CKAN RESOURCE TO DCAT DISTRIBUTION IS STILL EXPERIMENTAIL, IT MIGHT BE INCOMPLETE!!!");
        com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"invalid ckan resource");
        Preconditions.checkNotEmpty((String)catalogURL, (Object)"invalid catalog URL");
        Preconditions.checkNotEmpty((String)datasetIdOrName, (Object)"invalid dataset id");
        com.google.common.base.Preconditions.checkNotNull((Object)license, (Object)"invalid license");
        String sanitizedCatalogUrl = TodUtils.removeTrailingSlash((String)catalogURL);
        DcatDistribution.Builder ddb = DcatDistribution.builder();
        try {
            ddb.setUri(this.extractUri(resource, sanitizedCatalogUrl, datasetIdOrName));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind(URI_FIELD);
        }
        catch (Exception ex) {
            this.logDistribCantExtract(URI_FIELD, ex);
        }
        try {
            ddb.setAccessURL(this.extractAccessUrl(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("accessURL");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("accessURL", ex);
        }
        try {
            ddb.setDownloadURL(this.extractDownloadUrl(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("downloadURL");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("downloadURL", ex);
        }
        try {
            ddb.setByteSize(this.extractByteSize(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("byteSize");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("byteSize", ex);
        }
        ddb.setDatasetUri(CkanClient.makeDatasetUrl(sanitizedCatalogUrl, datasetIdOrName));
        try {
            ddb.setDescription(this.extractDescription(resource, locale));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind(DESCRIPTION);
        }
        catch (Exception ex) {
            this.logDistribCantExtract(DESCRIPTION, ex);
        }
        try {
            ddb.setFormat(this.extractFormat(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("format");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("format", ex);
        }
        try {
            ddb.setIssued(this.extractIssued(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind(ISSUED);
        }
        catch (Exception ex) {
            this.logDistribCantExtract(ISSUED, ex);
        }
        try {
            ddb.setLicense(this.extractLicense(resource, license));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("license");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("license", ex);
        }
        try {
            ddb.setModified(this.extractModified(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind(MODIFIED);
        }
        catch (Exception ex) {
            this.logDistribCantExtract(MODIFIED, ex);
        }
        try {
            ddb.setMediaType(this.extractMediaType(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("mediaType");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("mediaType", ex);
        }
        try {
            ddb.setRights(this.extractRights(resource));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind("rights");
        }
        catch (Exception ex) {
            this.logDistribCantExtract("rights", ex);
        }
        try {
            ddb.setTitle(this.extractTitle(resource, locale));
        }
        catch (JackanNotFoundException ex) {
            this.logDistribCantFind(TITLE);
        }
        catch (Exception ex) {
            this.logDistribCantExtract(TITLE, ex);
        }
        this.postProcessDistribution(ddb, resource, sanitizedCatalogUrl, datasetIdOrName, license, locale);
        return ddb.build();
    }
}

