/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.dcat;

import com.google.common.annotations.Beta;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.jackan.CkanClient;
import eu.trentorise.opendata.jackan.dcat.DcatFactory;
import eu.trentorise.opendata.jackan.exceptions.JackanNotFoundException;
import eu.trentorise.opendata.jackan.model.CkanDataset;
import eu.trentorise.opendata.jackan.model.CkanGroup;
import eu.trentorise.opendata.jackan.model.CkanOrganization;
import eu.trentorise.opendata.jackan.model.CkanResource;
import eu.trentorise.opendata.traceprov.dcat.SkosConcept;
import eu.trentorise.opendata.traceprov.dcat.SkosConceptScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;

@Beta
public class GreedyDcatFactory
extends DcatFactory {
    private static final Logger LOG = Logger.getLogger(GreedyDcatFactory.class.getName());

    @Override
    protected List<SkosConcept> extractThemes(CkanDataset dataset, Locale locale, String catalogUrl) {
        try {
            List<SkosConcept> themes1 = super.extractThemes(dataset, locale, catalogUrl);
            if (!themes1.isEmpty()) {
                return themes1;
            }
        }
        catch (Exception themes1) {
            // empty catch block
        }
        ArrayList<SkosConcept> ret = new ArrayList<SkosConcept>();
        LOG.info("Couldn't fine 'theme' field in dataset, will try to extract themes froum groups");
        if (dataset.getGroups() != null) {
            LOG.warning("TODO - USING EMPTY SkosConceptTheme.of() WHILE CONVERTING FROM CKAN TO DCAT DATASET");
            for (CkanGroup cg : dataset.getGroups()) {
                if (cg == null || GreedyDcatFactory.isTrimmedEmpty(cg.getTitle())) continue;
                ret.add(SkosConcept.of((SkosConceptScheme)SkosConceptScheme.of(), (Dict)Dict.of((Locale)locale, (String[])new String[]{cg.getTitle()}), (String)CkanClient.makeGroupUrl(catalogUrl, cg.nameOrId())));
            }
        }
        if (ret.isEmpty() && dataset.getGroups() != null) {
            LOG.warning("TODO - USING EMPTY SkosConceptTheme.of() WHILE CONVERTING FROM CKAN TO DCAT DATASET");
            LOG.info("Couldn't fine 'groups' field in dataset, will try to extract themes froum organization");
            CkanOrganization cg = dataset.getOrganization();
            if (cg != null && !GreedyDcatFactory.isTrimmedEmpty(cg.getTitle())) {
                ret.add(SkosConcept.of((SkosConceptScheme)SkosConceptScheme.of(), (Dict)Dict.of((Locale)locale, (String[])new String[]{cg.getTitle()}), (String)CkanClient.makeOrganizationUrl(catalogUrl, cg.nameOrId())));
            }
        }
        return ret;
    }

    @Override
    protected String extractModified(CkanResource resource) {
        try {
            return super.extractModified(resource);
        }
        catch (JackanNotFoundException ex) {
            if (!GreedyDcatFactory.isTrimmedEmpty(resource.getLastModified())) {
                return resource.getLastModified();
            }
            throw new JackanNotFoundException("Couldn't find modified nor lastModified valid fields in resource!", ex);
        }
    }
}

