/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.internal.org.apache.http.client.fluent;

import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpEntity;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpResponse;
import eu.trentorise.opendata.jackan.internal.org.apache.http.StatusLine;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.ClientProtocolException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.HttpResponseException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.ResponseHandler;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.fluent.Content;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.ContentType;
import eu.trentorise.opendata.jackan.internal.org.apache.http.util.EntityUtils;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContentResponseHandler
implements ResponseHandler<Content> {
    ContentResponseHandler() {
    }

    @Override
    public Content handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (entity != null) {
            return new Content(EntityUtils.toByteArray(entity), ContentType.getOrDefault(entity));
        }
        return Content.NO_CONTENT;
    }
}

