/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.internal.org.apache.http.client.protocol;

import eu.trentorise.opendata.jackan.internal.org.apache.commons.logging.Log;
import eu.trentorise.opendata.jackan.internal.org.apache.commons.logging.LogFactory;
import eu.trentorise.opendata.jackan.internal.org.apache.http.Header;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpHost;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpRequest;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpRequestInterceptor;
import eu.trentorise.opendata.jackan.internal.org.apache.http.annotation.Immutable;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.CookieStore;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.config.RequestConfig;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.HttpUriRequest;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.protocol.HttpClientContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.config.Lookup;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.routing.RouteInfo;
import eu.trentorise.opendata.jackan.internal.org.apache.http.cookie.Cookie;
import eu.trentorise.opendata.jackan.internal.org.apache.http.cookie.CookieOrigin;
import eu.trentorise.opendata.jackan.internal.org.apache.http.cookie.CookieSpec;
import eu.trentorise.opendata.jackan.internal.org.apache.http.cookie.CookieSpecProvider;
import eu.trentorise.opendata.jackan.internal.org.apache.http.cookie.SetCookie2;
import eu.trentorise.opendata.jackan.internal.org.apache.http.protocol.HttpContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.util.Args;
import eu.trentorise.opendata.jackan.internal.org.apache.http.util.TextUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        int ver;
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        CookieStore cookieStore = clientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        Lookup<CookieSpecProvider> registry = clientContext.getCookieSpecRegistry();
        if (registry == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost targetHost = clientContext.getTargetHost();
        if (targetHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        RequestConfig config = clientContext.getRequestConfig();
        String policy = config.getCookieSpec();
        if (policy == null) {
            policy = "best-match";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + policy);
        }
        URI requestURI = null;
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
        }
        String path = requestURI != null ? requestURI.getPath() : null;
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            port = route.getTargetHost().getPort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port >= 0 ? port : 0, !TextUtils.isEmpty(path) ? path : "/", route.isSecure());
        CookieSpecProvider provider = registry.lookup(policy);
        if (provider == null) {
            throw new HttpException("Unsupported cookie policy: " + policy);
        }
        CookieSpec cookieSpec = provider.create(clientContext);
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + cookie + " match " + cookieOrigin);
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + cookie + " expired");
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0) {
            Header header;
            boolean needVersionHeader = false;
            for (Cookie cookie : matchedCookies) {
                if (ver == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                needVersionHeader = true;
            }
            if (needVersionHeader && (header = cookieSpec.getVersionHeader()) != null) {
                request.addHeader(header);
            }
        }
        context.setAttribute("http.cookie-spec", cookieSpec);
        context.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

