/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.internal.org.apache.http.impl.client;

import eu.trentorise.opendata.jackan.internal.org.apache.http.HeaderElement;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpResponse;
import eu.trentorise.opendata.jackan.internal.org.apache.http.annotation.Immutable;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.ConnectionKeepAliveStrategy;
import eu.trentorise.opendata.jackan.internal.org.apache.http.message.BasicHeaderElementIterator;
import eu.trentorise.opendata.jackan.internal.org.apache.http.protocol.HttpContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

