/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.internal.org.apache.http.impl.client;

import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpHost;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpRequest;
import eu.trentorise.opendata.jackan.internal.org.apache.http.annotation.ThreadSafe;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.ClientProtocolException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.config.RequestConfig;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.CloseableHttpResponse;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.Configurable;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.HttpExecutionAware;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.HttpRequestWrapper;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.protocol.HttpClientContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.ClientConnectionManager;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.ClientConnectionRequest;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.HttpClientConnectionManager;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.ManagedClientConnection;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.routing.HttpRoute;
import eu.trentorise.opendata.jackan.internal.org.apache.http.conn.scheme.SchemeRegistry;
import eu.trentorise.opendata.jackan.internal.org.apache.http.impl.DefaultConnectionReuseStrategy;
import eu.trentorise.opendata.jackan.internal.org.apache.http.impl.client.CloseableHttpClient;
import eu.trentorise.opendata.jackan.internal.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import eu.trentorise.opendata.jackan.internal.org.apache.http.impl.execchain.MinimalClientExec;
import eu.trentorise.opendata.jackan.internal.org.apache.http.params.BasicHttpParams;
import eu.trentorise.opendata.jackan.internal.org.apache.http.params.HttpParams;
import eu.trentorise.opendata.jackan.internal.org.apache.http.protocol.BasicHttpContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.protocol.HttpContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.protocol.HttpRequestExecutor;
import eu.trentorise.opendata.jackan.internal.org.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

