/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.internal.org.apache.http.protocol;

import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpRequest;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpRequestInterceptor;
import eu.trentorise.opendata.jackan.internal.org.apache.http.annotation.Immutable;
import eu.trentorise.opendata.jackan.internal.org.apache.http.params.HttpParams;
import eu.trentorise.opendata.jackan.internal.org.apache.http.protocol.HttpContext;
import eu.trentorise.opendata.jackan.internal.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

