/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.jackan.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.trentorise.opendata.commons.TodUtils;
import eu.trentorise.opendata.jackan.model.CkanDatasetRelationship;
import eu.trentorise.opendata.jackan.model.CkanGroup;
import eu.trentorise.opendata.jackan.model.CkanPair;
import eu.trentorise.opendata.jackan.model.CkanResource;
import eu.trentorise.opendata.jackan.model.CkanState;
import eu.trentorise.opendata.jackan.model.CkanTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class CkanDatasetBase {
    private String author;
    private String authorEmail;
    private List<CkanPair> extras;
    private List<CkanGroup> groups;
    private String id;
    private String licenseId;
    private String maintainer;
    private String maintainerEmail;
    private String name;
    private String notes;
    private String ownerOrg;
    private List<CkanDatasetRelationship> relationshipsAsObject;
    private List<CkanDatasetRelationship> relationshipsAsSubject;
    private List<CkanResource> resources;
    private CkanState state;
    private List<CkanTag> tags;
    private String title;
    private String type;
    private String url;
    private String version;
    @Nullable
    private Map<String, Object> others;

    public CkanDatasetBase() {
    }

    public CkanDatasetBase(String name) {
        this();
        this.name = name;
    }

    @JsonAnyGetter
    @Nullable
    public Map<String, Object> getOthers() {
        return this.others;
    }

    public void setOthers(@Nullable Map<String, Object> others) {
        this.others = others;
    }

    @JsonAnySetter
    public void putOthers(String name, Object value) {
        if (this.others == null) {
            this.others = new HashMap<String, Object>();
        }
        this.others.put(name, value);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public List<CkanGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<CkanGroup> groups) {
        this.groups = groups;
    }

    public List<CkanPair> getExtras() {
        return this.extras;
    }

    @JsonIgnore
    public Map<String, String> getExtrasAsHashMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (this.extras != null) {
            for (CkanPair cp : this.extras) {
                hm.put(cp.getKey(), cp.getValue());
            }
        }
        return hm;
    }

    public void setExtras(List<CkanPair> extras) {
        this.extras = extras;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public String getMaintainerEmail() {
        return this.maintainerEmail;
    }

    public void setMaintainerEmail(String maintainerEmail) {
        this.maintainerEmail = maintainerEmail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getOwnerOrg() {
        return this.ownerOrg;
    }

    public void setOwnerOrg(String ownerOrg) {
        this.ownerOrg = ownerOrg;
    }

    public List<CkanDatasetRelationship> getRelationshipsAsObject() {
        return this.relationshipsAsObject;
    }

    public void setRelationshipsAsObject(List<CkanDatasetRelationship> relationshipsAsObject) {
        this.relationshipsAsObject = relationshipsAsObject;
    }

    public List<CkanDatasetRelationship> getRelationshipsAsSubject() {
        return this.relationshipsAsSubject;
    }

    public void setRelationshipsAsSubject(List<CkanDatasetRelationship> relationshipsAsSubject) {
        this.relationshipsAsSubject = relationshipsAsSubject;
    }

    public List<CkanResource> getResources() {
        return this.resources;
    }

    public void setResources(List<CkanResource> resources) {
        this.resources = resources;
    }

    public CkanState getState() {
        return this.state;
    }

    public void setState(CkanState state) {
        this.state = state;
    }

    public List<CkanTag> getTags() {
        return this.tags;
    }

    public void setTags(List<CkanTag> tags) {
        this.tags = tags;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nullable
    public String idOrName() {
        return TodUtils.isNotEmpty((String)this.getId()) ? this.getId() : this.getName();
    }

    @Nullable
    public String nameOrId() {
        return TodUtils.isNotEmpty((String)this.getName()) ? this.getName() : this.getId();
    }
}

